/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.client.renderer;

import java.awt.Color;
import java.util.EnumSet;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mods.flammpfeil.slashblade.capability.slashblade.CapabilitySlashBlade;
import mods.flammpfeil.slashblade.capability.slashblade.ISlashBladeState;
import mods.flammpfeil.slashblade.client.renderer.model.BladeFirstPersonRender;
import mods.flammpfeil.slashblade.client.renderer.model.BladeModel;
import mods.flammpfeil.slashblade.client.renderer.model.BladeModelManager;
import mods.flammpfeil.slashblade.client.renderer.model.obj.WavefrontObject;
import mods.flammpfeil.slashblade.client.renderer.util.BladeRenderState;
import mods.flammpfeil.slashblade.client.renderer.util.MSAutoCloser;
import mods.flammpfeil.slashblade.entity.BladeStandEntity;
import mods.flammpfeil.slashblade.init.DefaultResources;
import mods.flammpfeil.slashblade.init.SBItems;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.item.ItemSlashBladeDetune;
import mods.flammpfeil.slashblade.item.SwordType;
import mods.flammpfeil.slashblade.registry.slashblade.SlashBladeDefinition;
import net.minecraft.class_1306;
import net.minecraft.class_1533;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4050;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5599;
import net.minecraft.class_756;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_824;

public class SlashBladeTEISR
extends class_756 {
    public static final class_756 INSTANCE = new SlashBladeTEISR(class_310.method_1551().method_31975(), class_310.method_1551().method_31974());

    public SlashBladeTEISR(class_824 p_172550_, class_5599 p_172551_) {
        super(p_172550_, p_172551_);
    }

    public void method_3166(class_1799 itemStackIn, class_811 type, class_4587 matrixStack, class_4597 bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (!(itemStackIn.method_7909() instanceof ItemSlashBlade)) {
            return;
        }
        this.renderBlade(itemStackIn, type, matrixStack, bufferIn, combinedLightIn, combinedOverlayIn);
    }

    boolean checkRenderNaked() {
        class_1799 mainHand = BladeModel.user.method_6047();
        return !(mainHand.method_7909() instanceof ItemSlashBlade);
    }

    public boolean renderBlade(class_1799 stack, class_811 transformType, class_4587 matrixStack, class_4597 bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (transformType == class_811.field_4323 || transformType == class_811.field_4320 || transformType == class_811.field_4321 || transformType == class_811.field_4322 || transformType == class_811.field_4315) {
            if (BladeModel.user == null) {
                class_310 minecraftInstance = class_310.method_1551();
                BladeModel.user = minecraftInstance.field_1724;
            }
            boolean handle = false;
            boolean bl = BladeModel.user.method_6068() == class_1306.field_6183 ? transformType == class_811.field_4322 : (handle = transformType == class_811.field_4321);
            if (handle) {
                BladeFirstPersonRender.getInstance().render(matrixStack, bufferIn, combinedLightIn);
            }
            return false;
        }
        try (MSAutoCloser msacA = MSAutoCloser.pushMatrix(matrixStack);){
            matrixStack.method_46416(0.5f, 0.5f, 0.5f);
            if (transformType == class_811.field_4318) {
                matrixStack.method_46416(0.0f, 0.15f, 0.0f);
                this.renderIcon(stack, matrixStack, bufferIn, combinedLightIn, 0.005f);
            } else if (transformType == class_811.field_4317) {
                this.renderIcon(stack, matrixStack, bufferIn, combinedLightIn, 0.008f, true);
            } else if (transformType == class_811.field_4319) {
                if (stack.method_7961() && stack.method_7945() instanceof BladeStandEntity) {
                    this.renderModel(stack, matrixStack, bufferIn, combinedLightIn);
                } else {
                    matrixStack.method_22907(class_7833.field_40716.rotationDegrees(180.0f));
                    this.renderIcon(stack, matrixStack, bufferIn, combinedLightIn, 0.0095f);
                }
            } else {
                this.renderIcon(stack, matrixStack, bufferIn, combinedLightIn, 0.0095f);
            }
        }
        return true;
    }

    public void renderIcon(class_1799 stack, class_4587 matrixStack, class_4597 bufferIn, int lightIn, float scale) {
        this.renderIcon(stack, matrixStack, bufferIn, lightIn, scale, false);
    }

    public void renderIcon(class_1799 stack, class_4587 matrixStack, class_4597 bufferIn, int lightIn, float scale, boolean renderDurability) {
        matrixStack.method_22905(scale, scale, scale);
        EnumSet<SwordType> types = SwordType.from(stack);
        class_2960 modelLocation = CapabilitySlashBlade.getBladeState(stack).filter(s -> s.getModel().isPresent()).map(s -> s.getModel().get()).orElseGet(() -> this.stackDefaultModel(stack));
        WavefrontObject model = BladeModelManager.getInstance().getModel(modelLocation);
        class_2960 textureLocation = CapabilitySlashBlade.getBladeState(stack).filter(s -> s.getTexture().isPresent()).map(s -> s.getTexture().get()).orElseGet(() -> this.stackDefaultTexture(stack));
        String renderTarget = types.contains((Object)SwordType.BROKEN) ? "item_damaged" : (types.contains((Object)SwordType.NOSCABBARD) ? "item_bladens" : "item_blade");
        BladeRenderState.renderOverrided(stack, model, renderTarget, textureLocation, matrixStack, bufferIn, lightIn);
        BladeRenderState.renderOverridedLuminous(stack, model, renderTarget + "_luminous", textureLocation, matrixStack, bufferIn, lightIn);
        if (renderDurability) {
            WavefrontObject durabilityModel = BladeModelManager.getInstance().getModel(DefaultResources.resourceDurabilityModel);
            float durability = (float)stack.method_7919() / (float)stack.method_7936();
            matrixStack.method_46416(0.0f, 0.0f, 0.1f);
            Color aCol = new Color(0.25f, 0.25f, 0.25f, 1.0f);
            Color bCol = new Color(10824803);
            int r = 0xFF & (int)class_3532.method_16439((float)aCol.getRed(), (float)bCol.getRed(), (float)durability);
            int g = 0xFF & (int)class_3532.method_16439((float)aCol.getGreen(), (float)bCol.getGreen(), (float)durability);
            int b = 0xFF & (int)class_3532.method_16439((float)aCol.getBlue(), (float)bCol.getBlue(), (float)durability);
            BladeRenderState.setCol(new Color(r, g, b));
            BladeRenderState.renderOverrided(stack, durabilityModel, "base", DefaultResources.resourceDurabilityTexture, matrixStack, bufferIn, lightIn);
            boolean isBroken = types.contains((Object)SwordType.BROKEN);
            matrixStack.method_46416(0.0f, 0.0f, -2.0f * durability);
            BladeRenderState.renderOverrided(stack, durabilityModel, isBroken ? "color_r" : "color", DefaultResources.resourceDurabilityTexture, matrixStack, bufferIn, lightIn);
        }
    }

    public class_2960 stackDefaultModel(class_1799 stack) {
        String key;
        Optional<ISlashBladeState> cap = CapabilitySlashBlade.getBladeState(stack);
        if (cap.isEmpty()) {
            return DefaultResources.resourceDefaultModel;
        }
        String name = cap.get().getModel().map(class_2960::toString).orElse("");
        if (!(stack.method_7909() instanceof ItemSlashBladeDetune) && !(key = cap.get().getTranslationKey()).isBlank()) {
            class_2960 bladeName = class_2960.method_12829((String)key.substring(5).replaceFirst(Pattern.quote("."), Matcher.quoteReplacement(":")));
            SlashBladeDefinition slashBladeDefinition = (SlashBladeDefinition)BladeModelManager.getClientSlashBladeRegistry().method_10223(bladeName);
            if (slashBladeDefinition != null) {
                name = slashBladeDefinition.getRenderDefinition().getModelName().toString();
            }
        }
        return !name.isBlank() ? class_2960.method_12829((String)name) : DefaultResources.resourceDefaultModel;
    }

    public class_2960 stackDefaultTexture(class_1799 stack) {
        String key;
        Optional<ISlashBladeState> cap = CapabilitySlashBlade.getBladeState(stack);
        if (cap.isEmpty()) {
            return DefaultResources.resourceDefaultTexture;
        }
        String name = cap.get().getTexture().map(class_2960::toString).orElse("");
        if (!(stack.method_7909() instanceof ItemSlashBladeDetune) && !(key = cap.get().getTranslationKey()).isBlank()) {
            class_2960 bladeName = class_2960.method_12829((String)key.substring(5).replaceFirst(Pattern.quote("."), Matcher.quoteReplacement(":")));
            SlashBladeDefinition slashBladeDefinition = (SlashBladeDefinition)BladeModelManager.getClientSlashBladeRegistry().method_10223(bladeName);
            if (slashBladeDefinition != null) {
                name = slashBladeDefinition.getRenderDefinition().getTextureName().toString();
            }
        }
        return !name.isBlank() ? class_2960.method_12829((String)name) : DefaultResources.resourceDefaultTexture;
    }

    public void renderModel(class_1799 stack, class_4587 matrixStack, class_4597 bufferIn, int lightIn) {
        String renderTarget;
        class_1533 class_15332;
        float scale = 0.003125f;
        matrixStack.method_22905(scale, scale, scale);
        float defaultOffset = 130.0f;
        matrixStack.method_46416(defaultOffset, 0.0f, 0.0f);
        EnumSet<SwordType> types = SwordType.from(stack);
        class_2960 modelLocation = CapabilitySlashBlade.getBladeState(stack).filter(s -> s.getModel().isPresent()).map(s -> s.getModel().get()).orElseGet(() -> this.stackDefaultModel(stack));
        WavefrontObject model = BladeModelManager.getInstance().getModel(modelLocation);
        class_2960 textureLocation = CapabilitySlashBlade.getBladeState(stack).filter(s -> s.getTexture().isPresent()).map(s -> s.getTexture().get()).orElseGet(() -> this.stackDefaultTexture(stack));
        class_243 bladeOffset = class_243.field_1353;
        float bladeOffsetRot = 0.0f;
        float bladeOffsetBaseRot = -3.0f;
        class_243 sheathOffset = class_243.field_1353;
        float sheathOffsetRot = 0.0f;
        float sheathOffsetBaseRot = -3.0f;
        boolean vFlip = false;
        boolean hFlip = false;
        boolean hasScabbard = true;
        if (stack.method_7961() && (class_15332 = stack.method_7945()) instanceof BladeStandEntity) {
            BladeStandEntity stand = (BladeStandEntity)class_15332;
            class_1792 type = stand.currentType;
            class_4050 pose = stand.method_18376();
            switch (pose.ordinal()) {
                case 0: {
                    vFlip = false;
                    hFlip = false;
                    break;
                }
                case 1: {
                    vFlip = true;
                    hFlip = false;
                    break;
                }
                case 2: {
                    vFlip = true;
                    hFlip = true;
                    break;
                }
                case 3: {
                    vFlip = false;
                    hFlip = true;
                    break;
                }
                case 4: {
                    vFlip = false;
                    hFlip = false;
                    hasScabbard = false;
                    break;
                }
                case 5: {
                    vFlip = false;
                    hFlip = true;
                    hasScabbard = false;
                }
            }
            if (type == SBItems.bladestand_1) {
                bladeOffset = class_243.field_1353;
                sheathOffset = class_243.field_1353;
            } else if (type == SBItems.bladestand_2) {
                bladeOffset = new class_243(0.0, 21.5, 0.0);
                sheathOffset = hFlip ? new class_243(-40.0, -27.0, 0.0) : new class_243(40.0, -27.0, 0.0);
                sheathOffsetBaseRot = -4.0f;
            } else if (type == SBItems.bladestand_v) {
                bladeOffset = new class_243(-100.0, 230.0, 0.0);
                sheathOffset = new class_243(-100.0, 230.0, 0.0);
                bladeOffsetRot = 80.0f;
                sheathOffsetRot = 80.0f;
            } else if (type == SBItems.bladestand_s) {
                if (hFlip) {
                    bladeOffset = new class_243(60.0, -25.0, 0.0);
                    sheathOffset = new class_243(60.0, -25.0, 0.0);
                } else {
                    bladeOffset = new class_243(-60.0, -25.0, 0.0);
                    sheathOffset = new class_243(-60.0, -25.0, 0.0);
                }
            } else if (type == SBItems.bladestand_1w) {
                bladeOffset = class_243.field_1353;
                sheathOffset = class_243.field_1353;
            } else if (type == SBItems.bladestand_2w) {
                bladeOffset = new class_243(0.0, 21.5, 0.0);
                sheathOffset = hFlip ? new class_243(-40.0, -27.0, 0.0) : new class_243(40.0, -27.0, 0.0);
                sheathOffsetBaseRot = -4.0f;
            }
        }
        try (MSAutoCloser msac = MSAutoCloser.pushMatrix(matrixStack);){
            renderTarget = types.contains((Object)SwordType.BROKEN) ? "blade_damaged" : "blade";
            matrixStack.method_22904(bladeOffset.field_1352, bladeOffset.field_1351, bladeOffset.field_1350);
            matrixStack.method_22907(class_7833.field_40718.rotationDegrees(bladeOffsetRot));
            if (vFlip) {
                matrixStack.method_22907(class_7833.field_40714.rotationDegrees(180.0f));
                matrixStack.method_46416(0.0f, -15.0f, 0.0f);
                matrixStack.method_46416(0.0f, 5.0f, 0.0f);
            }
            if (hFlip) {
                double offset = defaultOffset;
                matrixStack.method_22904(-offset, 0.0, 0.0);
                matrixStack.method_22907(class_7833.field_40716.rotationDegrees(180.0f));
                matrixStack.method_22904(offset, 0.0, 0.0);
            }
            matrixStack.method_22907(class_7833.field_40718.rotationDegrees(bladeOffsetBaseRot));
            BladeRenderState.renderOverrided(stack, model, renderTarget, textureLocation, matrixStack, bufferIn, lightIn);
            BladeRenderState.renderOverridedLuminous(stack, model, renderTarget + "_luminous", textureLocation, matrixStack, bufferIn, lightIn);
        }
        if (hasScabbard) {
            msac = MSAutoCloser.pushMatrix(matrixStack);
            try {
                renderTarget = "sheath";
                matrixStack.method_22904(sheathOffset.field_1352, sheathOffset.field_1351, sheathOffset.field_1350);
                matrixStack.method_22907(class_7833.field_40718.rotationDegrees(sheathOffsetRot));
                if (vFlip) {
                    matrixStack.method_22907(class_7833.field_40714.rotationDegrees(180.0f));
                    matrixStack.method_46416(0.0f, -15.0f, 0.0f);
                    matrixStack.method_46416(0.0f, 5.0f, 0.0f);
                }
                if (hFlip) {
                    double offset = defaultOffset;
                    matrixStack.method_22904(-offset, 0.0, 0.0);
                    matrixStack.method_22907(class_7833.field_40716.rotationDegrees(180.0f));
                    matrixStack.method_22904(offset, 0.0, 0.0);
                }
                matrixStack.method_22907(class_7833.field_40718.rotationDegrees(sheathOffsetBaseRot));
                BladeRenderState.renderOverrided(stack, model, renderTarget, textureLocation, matrixStack, bufferIn, lightIn);
                BladeRenderState.renderOverridedLuminous(stack, model, renderTarget + "_luminous", textureLocation, matrixStack, bufferIn, lightIn);
            }
            finally {
                if (msac != null) {
                    msac.close();
                }
            }
        }
    }
}

