/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.client.renderer.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import mods.flammpfeil.slashblade.capability.concentrationrank.CapabilityConcentrationRank;
import mods.flammpfeil.slashblade.capability.concentrationrank.IConcentrationRank;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_1060;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_408;
import net.minecraft.class_4587;
import net.minecraft.class_746;
import net.minecraft.class_757;
import net.minecraft.class_9779;
import net.minecraft.class_9801;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public class RankRenderer {
    static class_2960 RankImg = class_2960.method_60655((String)"slashblade", (String)"textures/gui/rank.png");

    public static RankRenderer getInstance() {
        return SingletonHolder.instance;
    }

    private RankRenderer() {
    }

    public void register() {
        HudRenderCallback.EVENT.register(this::renderTick);
    }

    @Environment(value=EnvType.CLIENT)
    public void renderTick(class_332 drawContext, class_9779 timer) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1724 == null) {
            return;
        }
        if (!class_310.method_1498()) {
            return;
        }
        if (mc.field_1755 != null && !(mc.field_1755 instanceof class_408)) {
            return;
        }
        class_746 player = mc.field_1724;
        long time = System.currentTimeMillis();
        this.renderRankHud(timer, player, time);
    }

    private void renderRankHud(class_9779 timer, class_746 player, long time) {
        class_310 mc = class_310.method_1551();
        CapabilityConcentrationRank.RANK_POINT.maybeGet((Object)player).ifPresent(cr -> {
            long now = player.method_37908().method_8510();
            IConcentrationRank.ConcentrationRanks rank = cr.getRank(now);
            if (rank == IConcentrationRank.ConcentrationRanks.NONE) {
                return;
            }
            int k = mc.method_22683().method_4486();
            int l = mc.method_22683().method_4502();
            class_4587 poseStack = new class_4587();
            poseStack.method_46416((float)(k * 2 / 3), (float)(l / 5), 0.0f);
            RenderSystem.disableDepthTest();
            class_1060 texturemanager = class_310.method_1551().method_1531();
            texturemanager.method_4619(RankImg).method_4527(false, false);
            RenderSystem.setShaderTexture((int)0, (class_2960)RankImg);
            boolean showTextRank = false;
            long textTimeout = cr.getLastRankRise() + 20L;
            long visibleTimeout = cr.getLastUpdate() + 120L;
            if (now < textTimeout) {
                showTextRank = true;
            }
            if (now < visibleTimeout) {
                int rankOffset = 32 * (rank.level - 1);
                int textOffset = showTextRank ? 128 : 0;
                int progress = (int)(33.0f * cr.getRankProgress(now));
                int progressIcon = (int)(18.0f * cr.getRankProgress(now));
                int progressIconInv = 17 - progressIcon;
                RankRenderer.drawTexturedQuad(poseStack, 0, 0, textOffset + 64, rankOffset, 64, 32, -95.0f);
                RankRenderer.drawTexturedQuad(poseStack, 0, progressIconInv + 7, textOffset, rankOffset + progressIconInv + 7, 64, progressIcon, -90.0f);
                RankRenderer.drawTexturedQuad(poseStack, 0, 32, 0, 240, 64, 16, -90.0f);
                RankRenderer.drawTexturedQuad(poseStack, 16, 32, 16, 224, progress, 16, -95.0f);
            }
        });
    }

    public static void drawTexturedQuad(class_4587 poseStack, int x, int y, int u, int v, int width, int height, float zLevel) {
        float var7 = 0.00390625f;
        float var8 = 0.00390625f;
        RenderSystem.setShader(class_757::method_34542);
        class_289 tessellator = class_289.method_1348();
        class_287 wr = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1585);
        Matrix4f m = poseStack.method_23760().method_23761();
        wr.method_22918(m, (float)x, (float)(y + height), zLevel).method_22913(((float)u + 0.0f) * var7, (float)(v + height) * var8);
        wr.method_22918(m, (float)(x + width), (float)(y + height), zLevel).method_22913((float)(u + width) * var7, (float)(v + height) * var8);
        wr.method_22918(m, (float)(x + width), (float)y, zLevel).method_22913((float)(u + width) * var7, (float)v * var8);
        wr.method_22918(m, (float)x, (float)y, zLevel).method_22913((float)u * var7, (float)v * var8);
        class_286.method_43433((class_9801)wr.method_60800());
    }

    private static final class SingletonHolder {
        private static final RankRenderer instance = new RankRenderer();

        private SingletonHolder() {
        }
    }
}

