/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.ability;

import cn.sh1rocu.slashblade.api.event.LivingJumpEvent;
import cn.sh1rocu.slashblade.api.event.LivingTickEvent;
import io.github.fabricators_of_create.porting_lib.entity.events.LivingAttackEvent;
import io.github.fabricators_of_create.porting_lib.entity.events.living.LivingHurtEvent;
import java.util.List;
import java.util.Optional;
import mods.flammpfeil.slashblade.ability.StunManager;
import mods.flammpfeil.slashblade.capability.mobeffect.CapabilityMobEffect;
import mods.flammpfeil.slashblade.capability.slashblade.CapabilitySlashBlade;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1297;
import net.minecraft.class_1309;

public class Untouchable {
    static final int JUMP_TICKS = 10;

    public static Untouchable getInstance() {
        return SingletonHolder.instance;
    }

    private Untouchable() {
    }

    public void register() {
        LivingHurtEvent.HURT.register(this::onLivingHurt);
        ServerLivingEntityEvents.ALLOW_DAMAGE.register(this::onLivingDamage);
        LivingAttackEvent.ATTACK.register(this::onLivingAttack);
        ServerLivingEntityEvents.ALLOW_DEATH.register(this::onLivingDeath);
        LivingTickEvent.CALLBACK.register(this::onLivingTicks);
        LivingJumpEvent.CALLBACK.register(this::onPlayerJump);
    }

    public static void setUntouchable(class_1309 entity, int ticks) {
        CapabilityMobEffect.MOB_EFFECT.maybeGet((Object)entity).ifPresent(ef -> {
            ef.setManagedUntouchable(entity.method_37908().method_8510(), ticks);
            ef.storeEffects(entity.method_6088().keySet());
            ef.storeHealth(entity.method_6032());
        });
    }

    private boolean checkUntouchable(class_1309 entity) {
        Optional<Boolean> isUntouchable = CapabilityMobEffect.MOB_EFFECT.maybeGet((Object)entity).map(ef -> ef.isUntouchable(entity.method_5770().method_8510()));
        return isUntouchable.orElseGet(() -> false);
    }

    private void doWitchTime(class_1297 entity) {
        if (entity == null) {
            return;
        }
        if (!(entity instanceof class_1309)) {
            return;
        }
        StunManager.setStun((class_1309)entity);
    }

    public boolean doUntouchable(class_1309 self, class_1297 other) {
        if (this.checkUntouchable(self)) {
            this.doWitchTime(other);
            return true;
        }
        return false;
    }

    public void onLivingHurt(LivingHurtEvent event) {
        if (this.doUntouchable(event.getEntity(), event.getSource().method_5529())) {
            event.setCanceled(true);
        }
    }

    public boolean onLivingDamage(class_1309 entity, class_1282 source, float amount) {
        return !this.doUntouchable(entity, source.method_5529());
    }

    public void onLivingAttack(LivingAttackEvent event) {
        if (this.checkUntouchable(event.getEntity())) {
            event.setCanceled(true);
        }
    }

    public boolean onLivingDeath(class_1309 entity, class_1282 damageSource, float damageAmount) {
        if (this.doUntouchable(entity, damageSource.method_5529())) {
            CapabilityMobEffect.MOB_EFFECT.maybeGet((Object)entity).ifPresent(ef -> {
                if (ef.hasUntouchableWorked()) {
                    List<class_1291> filterd = entity.method_6088().keySet().stream().filter(p -> !ef.getEffectSet().contains(p) && !p.method_5573()).toList();
                    filterd.forEach(arg_0 -> ((class_1309)entity).method_6016(arg_0));
                    float storedHealth = ef.getStoredHealth();
                    if (ef.getStoredHealth() < storedHealth) {
                        entity.method_6033(ef.getStoredHealth());
                    }
                }
            });
            return false;
        }
        return true;
    }

    public void onLivingTicks(LivingTickEvent event) {
        class_1309 entity = event.getEntity();
        if (entity.method_37908().method_8608()) {
            return;
        }
        CapabilityMobEffect.MOB_EFFECT.maybeGet((Object)entity).ifPresent(ef -> {
            if (ef.hasUntouchableWorked()) {
                ef.setUntouchableWorked(false);
                List<class_1291> filterd = entity.method_6088().keySet().stream().filter(p -> !ef.getEffectSet().contains(p) && !p.method_5573()).toList();
                filterd.forEach(arg_0 -> ((class_1309)entity).method_6016(arg_0));
                float storedHealth = ef.getStoredHealth();
                if (ef.getStoredHealth() < storedHealth) {
                    entity.method_6033(ef.getStoredHealth());
                }
            }
        });
    }

    public void onPlayerJump(LivingJumpEvent event) {
        if (CapabilitySlashBlade.BLADESTATE.maybeGet((Object)event.getEntity().method_6047()).isEmpty()) {
            return;
        }
        Untouchable.setUntouchable(event.getEntity(), 10);
    }

    private static final class SingletonHolder {
        private static final Untouchable instance = new Untouchable();

        private SingletonHolder() {
        }
    }
}

