/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.client.renderer.layers;

import cn.sh1rocu.slashblade.util.LazyOptional;
import dev.kosmx.playerAnim.api.TransformType;
import dev.kosmx.playerAnim.core.util.Vec3f;
import dev.kosmx.playerAnim.impl.IAnimatedPlayer;
import dev.kosmx.playerAnim.impl.animation.AnimationApplier;
import java.io.IOException;
import java.util.Optional;
import jp.nyatla.nymmd.MmdException;
import jp.nyatla.nymmd.MmdMotionPlayerGL2;
import jp.nyatla.nymmd.MmdPmdModelMc;
import jp.nyatla.nymmd.MmdPmdModel_BasicClass;
import jp.nyatla.nymmd.MmdVmdMotionMc;
import mods.flammpfeil.slashblade.capability.slashblade.CapabilitySlashBlade;
import mods.flammpfeil.slashblade.client.renderer.CarryType;
import mods.flammpfeil.slashblade.client.renderer.model.BladeModelManager;
import mods.flammpfeil.slashblade.client.renderer.model.BladeMotionManager;
import mods.flammpfeil.slashblade.client.renderer.model.obj.WavefrontObject;
import mods.flammpfeil.slashblade.client.renderer.util.BladeRenderState;
import mods.flammpfeil.slashblade.client.renderer.util.MSAutoCloser;
import mods.flammpfeil.slashblade.data.tag.SlashBladeEntityTypeTagProvider;
import mods.flammpfeil.slashblade.event.client.UserPoseOverrider;
import mods.flammpfeil.slashblade.init.DefaultResources;
import mods.flammpfeil.slashblade.registry.ComboStateRegistry;
import mods.flammpfeil.slashblade.registry.combo.ComboState;
import mods.flammpfeil.slashblade.util.TimeValueHelper;
import mods.flammpfeil.slashblade.util.VectorHelper;
import net.minecraft.class_1268;
import net.minecraft.class_1292;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5498;
import net.minecraft.class_583;
import net.minecraft.class_742;
import net.minecraft.class_7833;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;

public class LayerMainBlade<T extends class_1309, M extends class_583<T>>
extends class_3887<T, M> {
    final LazyOptional<MmdPmdModelMc> bladeholder = LazyOptional.of(() -> {
        try {
            return new MmdPmdModelMc(new class_2960("slashblade", "model/bladeholder.pmd"));
        }
        catch (IOException | MmdException e) {
            e.printStackTrace();
            return null;
        }
    });
    final LazyOptional<MmdMotionPlayerGL2> motionPlayer = LazyOptional.of(() -> {
        MmdMotionPlayerGL2 mmp = new MmdMotionPlayerGL2();
        this.bladeholder.ifPresent(pmd -> {
            try {
                mmp.setPmd((MmdPmdModel_BasicClass)pmd);
            }
            catch (MmdException e) {
                e.printStackTrace();
            }
        });
        return mmp;
    });

    public LayerMainBlade(class_3883<T, M> entityRendererIn) {
        super(entityRendererIn);
    }

    public float modifiedSpeed(float baseSpeed, class_1309 entity) {
        float modif = 6.0f;
        if (class_1292.method_5576((class_1309)entity)) {
            modif = 6 - (1 + class_1292.method_5575((class_1309)entity));
        } else if (entity.method_6059(class_1294.field_5901)) {
            modif = 6 + (1 + entity.method_6112(class_1294.field_5901).method_5578()) * 2;
        }
        return baseSpeed / (modif /= 6.0f);
    }

    public void renderOffhandItem(class_4587 matrixStack, class_4597 bufferIn, int lightIn, T entity) {
        class_1799 offhandStack = entity.method_5998(class_1268.field_5810);
        if (offhandStack.method_7960() || CapabilitySlashBlade.BLADESTATE.maybeGet((Object)offhandStack).isEmpty()) {
            this.renderHotbarItem(matrixStack, bufferIn, lightIn, entity);
            return;
        }
        this.renderStandbyBlade(matrixStack, bufferIn, lightIn, offhandStack, entity);
    }

    public void renderHotbarItem(class_4587 matrixStack, class_4597 bufferIn, int lightIn, T entity) {
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            if (player.method_31548().field_7545 == 0) {
                return;
            }
            class_1799 blade = player.method_31548().method_5438(0);
            if (blade.method_7960()) {
                return;
            }
            this.renderStandbyBlade(matrixStack, bufferIn, lightIn, blade, entity);
        }
    }

    public void renderStandbyBlade(class_4587 matrixStack, class_4597 bufferIn, int lightIn, class_1799 blade, T entity) {
        Optional state = CapabilitySlashBlade.BLADESTATE.maybeGet((Object)blade);
        state.ifPresent(s -> {
            double modelScaleBase = 0.0078125;
            double motionScale = 0.125;
            class_2960 textureLocation = s.getTexture().orElse(DefaultResources.resourceDefaultTexture);
            WavefrontObject obj = BladeModelManager.getInstance().getModel(s.getModel().orElse(DefaultResources.resourceDefaultModel));
            try (MSAutoCloser msacA = MSAutoCloser.pushMatrix(matrixStack);){
                matrixStack.method_46416(0.0f, 1.5f, 0.0f);
                CarryType carrytype = s.getCarryType();
                class_310 mcinstance = class_310.method_1551();
                switch (carrytype) {
                    case PSO2: {
                        matrixStack.method_46416(1.0f, -1.125f, 0.2f);
                        matrixStack.method_22907(new Quaternionf().rotateZYX(-0.122173f, 0.0f, 0.0f));
                        if (mcinstance.field_1690.method_31044() != class_5498.field_26664 || entity != mcinstance.field_1724) break;
                        return;
                    }
                    case KATANA: {
                        matrixStack.method_46416(0.25f, -0.875f, -0.55f);
                        matrixStack.method_22907(new Quaternionf().rotateZYX((float)Math.PI, 1.570796f, 0.261799f));
                        break;
                    }
                    case DEFAULT: {
                        matrixStack.method_46416(0.25f, -0.875f, -0.55f);
                        matrixStack.method_22907(new Quaternionf().rotateZYX(0.0f, 1.570796f, 0.261799f));
                        break;
                    }
                    case NINJA: {
                        matrixStack.method_46416(-0.5f, -2.0f, 0.2f);
                        matrixStack.method_22907(new Quaternionf().rotateZYX(-2.094395f, 0.0f, (float)Math.PI));
                        if (mcinstance.field_1690.method_31044() != class_5498.field_26664 || entity != mcinstance.field_1724) break;
                        return;
                    }
                    case RNINJA: {
                        matrixStack.method_46416(0.5f, -2.0f, 0.2f);
                        matrixStack.method_22907(new Quaternionf().rotateZYX(-1.047198f, 0.0f, 0.0f));
                        if (mcinstance.field_1690.method_31044() != class_5498.field_26664 || entity != mcinstance.field_1724) break;
                        return;
                    }
                    default: {
                        return;
                    }
                }
                float modelScale = (float)(modelScaleBase * (1.0 / motionScale));
                matrixStack.method_22905((float)motionScale, (float)motionScale, (float)motionScale);
                matrixStack.method_22905(modelScale, modelScale, modelScale);
                try (MSAutoCloser msac = MSAutoCloser.pushMatrix(matrixStack);){
                    String part = s.isBroken() ? "blade_damaged" : "blade";
                    BladeRenderState.renderOverrided(blade, obj, part, textureLocation, matrixStack, bufferIn, lightIn);
                    BladeRenderState.renderOverridedLuminous(blade, obj, part + "_luminous", textureLocation, matrixStack, bufferIn, lightIn);
                    BladeRenderState.renderOverrided(blade, obj, "sheath", textureLocation, matrixStack, bufferIn, lightIn);
                    BladeRenderState.renderOverridedLuminous(blade, obj, "sheath_luminous", textureLocation, matrixStack, bufferIn, lightIn);
                }
            }
        });
    }

    public void render(class_4587 matrixStack, class_4597 bufferIn, int lightIn, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        this.renderOffhandItem(matrixStack, bufferIn, lightIn, entity);
        float motionYOffset = 1.5f;
        double motionScale = 0.125;
        double modelScaleBase = 0.0078125;
        class_1799 stack = entity.method_5998(class_1268.field_5808);
        if (stack.method_7960()) {
            return;
        }
        if (entity.method_5864().method_20210(SlashBladeEntityTypeTagProvider.EntityTypeTags.RENDER_LAYER_BLACKLIST)) {
            return;
        }
        Optional state = CapabilitySlashBlade.BLADESTATE.maybeGet((Object)stack);
        state.ifPresent(s -> this.motionPlayer.ifPresent(mmp -> {
            double time;
            ComboState combo = ComboStateRegistry.COMBO_STATE.method_10223(s.getComboSeq()) != null ? (ComboState)ComboStateRegistry.COMBO_STATE.method_10223(s.getComboSeq()) : ComboStateRegistry.NONE;
            for (time = TimeValueHelper.getMSecFromTicks((float)Math.max(0L, entity.method_37908().method_8510() - s.getLastActionTime()) + partialTicks); combo != ComboStateRegistry.NONE && (double)combo.getTimeoutMS() < time; time -= (double)combo.getTimeoutMS()) {
                combo = ComboStateRegistry.COMBO_STATE.method_10223(combo.getNextOfTimeout((class_1309)entity)) != null ? (ComboState)ComboStateRegistry.COMBO_STATE.method_10223(combo.getNextOfTimeout((class_1309)entity)) : ComboStateRegistry.NONE;
            }
            if (combo == ComboStateRegistry.NONE) {
                combo = ComboStateRegistry.COMBO_STATE.method_10223(s.getComboRoot()) != null ? (ComboState)ComboStateRegistry.COMBO_STATE.method_10223(s.getComboRoot()) : ComboStateRegistry.STANDBY;
            }
            MmdVmdMotionMc motion = BladeMotionManager.getInstance().getMotion(combo.getMotionLoc());
            double maxSeconds = 0.0;
            try {
                mmp.setVmd(motion);
                maxSeconds = TimeValueHelper.getMSecFromFrames(motion.getMaxFrame());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            double start = TimeValueHelper.getMSecFromFrames(combo.getStartFrame());
            double end = TimeValueHelper.getMSecFromFrames(combo.getEndFrame());
            double span = Math.abs(end - start);
            span = Math.min(maxSeconds, span);
            if (combo.getLoop()) {
                time %= span;
            }
            time = Math.min(span, time);
            time = start + time;
            try {
                mmp.updateMotion((float)time);
            }
            catch (MmdException e) {
                e.printStackTrace();
            }
            try (MSAutoCloser msacA = MSAutoCloser.pushMatrix(matrixStack);){
                class_4587.class_4665 entry;
                Matrix4f mat;
                int idx;
                this.setUserPose(matrixStack, entity, partialTicks);
                matrixStack.method_46416(0.0f, motionYOffset, 0.0f);
                matrixStack.method_22905((float)motionScale, (float)motionScale, (float)motionScale);
                matrixStack.method_22907(class_7833.field_40718.rotationDegrees(180.0f));
                class_2960 textureLocation = s.getTexture().orElse(DefaultResources.resourceDefaultTexture);
                WavefrontObject obj = BladeModelManager.getInstance().getModel(s.getModel().orElse(DefaultResources.resourceDefaultModel));
                try (MSAutoCloser msac = MSAutoCloser.pushMatrix(matrixStack);){
                    idx = mmp.getBoneIndexByName("hardpointA");
                    if (0 <= idx) {
                        float[] buf = new float[16];
                        mmp._skinning_mat[idx].getValue(buf);
                        mat = VectorHelper.matrix4fFromArray(buf);
                        matrixStack.method_22905(-1.0f, 1.0f, 1.0f);
                        entry = matrixStack.method_23760();
                        entry.method_23761().mul((Matrix4fc)mat);
                        matrixStack.method_22905(-1.0f, 1.0f, 1.0f);
                    }
                    float modelScale = (float)(modelScaleBase * (1.0 / motionScale));
                    matrixStack.method_22905(modelScale, modelScale, modelScale);
                    String part = s.isBroken() ? "blade_damaged" : "blade";
                    BladeRenderState.renderOverrided(stack, obj, part, textureLocation, matrixStack, bufferIn, lightIn);
                    BladeRenderState.renderOverridedLuminous(stack, obj, part + "_luminous", textureLocation, matrixStack, bufferIn, lightIn);
                }
                msac = MSAutoCloser.pushMatrix(matrixStack);
                try {
                    idx = mmp.getBoneIndexByName("hardpointB");
                    if (0 <= idx) {
                        float[] buf = new float[16];
                        mmp._skinning_mat[idx].getValue(buf);
                        mat = VectorHelper.matrix4fFromArray(buf);
                        matrixStack.method_22905(-1.0f, 1.0f, 1.0f);
                        entry = matrixStack.method_23760();
                        entry.method_23761().mul((Matrix4fc)mat);
                        matrixStack.method_22905(-1.0f, 1.0f, 1.0f);
                    }
                    float modelScale = (float)(modelScaleBase * (1.0 / motionScale));
                    matrixStack.method_22905(modelScale, modelScale, modelScale);
                    BladeRenderState.renderOverrided(stack, obj, "sheath", textureLocation, matrixStack, bufferIn, lightIn);
                    BladeRenderState.renderOverridedLuminous(stack, obj, "sheath_luminous", textureLocation, matrixStack, bufferIn, lightIn);
                    if (s.isCharged((class_1309)entity)) {
                        float f = (float)entity.field_6012 + partialTicks;
                        BladeRenderState.renderChargeEffect(stack, f, obj, "effect", new class_2960("textures/entity/creeper/creeper_armor.png"), matrixStack, bufferIn, lightIn);
                    }
                }
                finally {
                    if (msac != null) {
                        msac.close();
                    }
                }
            }
        }));
    }

    public void setUserPose(class_4587 matrixStack, T entity, float partialTicks) {
        if (!UserPoseOverrider.UsePoseOverrider && entity instanceof class_742) {
            AnimationApplier animationPlayer = ((IAnimatedPlayer)entity).playerAnimator_getAnimation();
            animationPlayer.setTickDelta(partialTicks);
            if (animationPlayer.isActive()) {
                Vec3f vec3d = animationPlayer.get3DTransform("body", TransformType.POSITION, Vec3f.ZERO);
                matrixStack.method_22904((double)(-((Float)vec3d.getX()).floatValue()), (double)((Float)vec3d.getY()).floatValue() + 0.7, (double)(-((Float)vec3d.getZ()).floatValue()));
                Vec3f vec3f = animationPlayer.get3DTransform("body", TransformType.ROTATION, Vec3f.ZERO);
                matrixStack.method_22907(class_7833.field_40718.rotation(((Float)vec3f.getZ()).floatValue()));
                matrixStack.method_22907(class_7833.field_40716.rotation(((Float)vec3f.getY()).floatValue()));
                matrixStack.method_22907(class_7833.field_40714.rotation(((Float)vec3f.getX()).floatValue()));
                matrixStack.method_22904(0.0, -0.7, 0.0);
            }
        } else {
            UserPoseOverrider.invertRot(matrixStack, entity, partialTicks);
        }
    }
}

