/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.util;

import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2499;
import net.minecraft.class_2520;

public class NBTHelper {
    public static class_243 getVector3d(class_2487 tag, String key) {
        class_2499 listnbt = tag.method_10554(key, 6);
        return new class_243(listnbt.method_10611(0), listnbt.method_10611(1), listnbt.method_10611(2));
    }

    public static void putVector3d(class_2487 tag, String key, class_243 value) {
        tag.method_10566(key, (class_2520)NBTHelper.newDoubleNBTList(value.field_1352, value.field_1351, value.field_1350));
    }

    public static class_2499 newDoubleNBTList(class_243 value) {
        return NBTHelper.newDoubleNBTList(value.field_1352, value.field_1351, value.field_1350);
    }

    public static class_2499 newDoubleNBTList(double ... numbers) {
        class_2499 listnbt = new class_2499();
        for (double dValue : numbers) {
            listnbt.add((Object)class_2489.method_23241((double)dValue));
        }
        return listnbt;
    }

    public static NBTCoupler getNBTCoupler(class_2487 tag) {
        return new NBTCoupler(tag);
    }

    public static <T> void writeNBT(class_2487 dest, String key, T ... value) {
        if (value == null || value.length != 1 || value[0] == null) {
            return;
        }
        Class<?> type = value.getClass().getComponentType();
        if (type.equals(Integer.class)) {
            dest.method_10569(key, ((Integer)value[0]).intValue());
        } else if (type.equals(Float.class)) {
            dest.method_10548(key, ((Float)value[0]).floatValue());
        } else if (type.equals(Short.class)) {
            dest.method_10575(key, ((Short)value[0]).shortValue());
        } else if (type.equals(Byte.class)) {
            dest.method_10567(key, ((Byte)value[0]).byteValue());
        } else if (type.equals(Long.class)) {
            dest.method_10544(key, ((Long)value[0]).longValue());
        } else if (type.equals(Double.class)) {
            dest.method_10549(key, ((Double)value[0]).doubleValue());
        } else if (type.equals(Boolean.class)) {
            dest.method_10556(key, ((Boolean)value[0]).booleanValue());
        } else if (value[0] != null) {
            if (type.equals(UUID.class)) {
                dest.method_25927(key, (UUID)value[0]);
            } else if (type.equals(byte[].class)) {
                dest.method_10570(key, (byte[])value[0]);
            } else if (type.equals(int[].class)) {
                dest.method_10539(key, (int[])value[0]);
            } else if (type.equals(long[].class)) {
                dest.method_10564(key, (long[])value[0]);
            } else if (type.equals(class_2487.class)) {
                dest.method_10566(key, (class_2520)((class_2487)value[0]));
            } else if (type.equals(String.class)) {
                dest.method_10582(key, (String)value[0]);
            } else if (type.equals(class_243.class)) {
                NBTHelper.putVector3d(dest, key, (class_243)value[0]);
            }
        }
    }

    public static <T> void readNBT(class_2487 src, String key, Consumer<T> dest, T ... values) {
        NBTHelper.readNBT(src, key, dest, false, values);
    }

    public static <T> void readNBT(class_2487 src, String key, Consumer<T> dest, boolean isNullable, T ... defaultValue) {
        if (isNullable) {
            dest.accept(NBTHelper.castValue(key, src, defaultValue).orElse(null));
        } else {
            NBTHelper.castValue(key, src, defaultValue).ifPresent(dest);
        }
    }

    public static <T> Optional<T> castValue(String key, class_2487 src, T ... defaultValue) {
        if (defaultValue == null) {
            return Optional.empty();
        }
        Class<?> type = defaultValue.getClass().getComponentType();
        Object result = null;
        int typeId = -1;
        if (type.equals(Integer.class)) {
            typeId = 99;
            result = src.method_10550(key);
        } else if (type.equals(Float.class)) {
            typeId = 99;
            result = Float.valueOf(src.method_10583(key));
        } else if (type.equals(Short.class)) {
            typeId = 99;
            result = src.method_10568(key);
        } else if (type.equals(Byte.class)) {
            typeId = 99;
            result = src.method_10571(key);
        } else if (type.equals(Long.class)) {
            typeId = 99;
            result = src.method_10537(key);
        } else if (type.equals(Double.class)) {
            typeId = 99;
            result = src.method_10574(key);
        } else if (type.equals(Boolean.class)) {
            typeId = 99;
            result = src.method_10577(key);
        } else if (src.method_10545(key)) {
            if (type.equals(UUID.class)) {
                typeId = -2;
                if (src.method_25928(key)) {
                    result = src.method_25926(key);
                }
            } else if (type.equals(byte[].class)) {
                typeId = 7;
                result = src.method_10547(key);
            } else if (type.equals(int[].class)) {
                typeId = 11;
                result = src.method_10561(key);
            } else if (type.equals(long[].class)) {
                typeId = 12;
                result = src.method_10565(key);
            } else if (type.equals(class_2487.class)) {
                typeId = 10;
                result = src.method_10562(key);
            } else if (type.equals(String.class)) {
                typeId = 8;
                result = src.method_10558(key);
            }
        } else if (type.equals(class_243.class)) {
            typeId = 6;
            result = NBTHelper.getVector3d(src, key);
        }
        if (0 < defaultValue.length) {
            boolean exists;
            boolean bl = exists = typeId == -2 ? src.method_25928(key) : src.method_10573(key, typeId);
            if (!exists) {
                result = defaultValue;
            }
        }
        return Optional.ofNullable(result);
    }

    public static class NBTCoupler {
        class_2487 instance;
        NBTCoupler parent = null;

        protected NBTCoupler(class_2487 tag) {
            this.instance = tag;
        }

        public <T> NBTCoupler put(String key, T ... value) {
            NBTHelper.writeNBT(this.instance, key, value);
            return this;
        }

        public <T> NBTCoupler get(String key, Consumer<T> dest, T ... values) {
            return this.get(key, dest, false, values);
        }

        public <T> NBTCoupler get(String key, Consumer<T> dest, boolean isNullable, T ... values) {
            NBTHelper.readNBT(this.instance, key, dest, isNullable, values);
            return this;
        }

        public NBTCoupler remove(String key) {
            if (this.instance.method_25928(key)) {
                this.instance.method_10551(key + "Most");
                this.instance.method_10551(key + "Least");
            } else {
                this.instance.method_10551(key);
            }
            return this;
        }

        public NBTCoupler getChild(String key) {
            class_2487 tag;
            if (this.instance.method_10573(key, 10)) {
                tag = this.instance.method_10562(key);
            } else {
                tag = new class_2487();
                this.instance.method_10566(key, (class_2520)tag);
            }
            return NBTHelper.getNBTCoupler(tag);
        }

        public NBTCoupler getParent() {
            if (this.parent != null) {
                return this.parent;
            }
            return this;
        }

        public class_2487 getRawCompound() {
            return this.instance;
        }

        public class_2487 getRawCompound(String key) {
            if (this.instance.method_10573(key, 10)) {
                return this.instance.method_10562(key);
            }
            class_2487 nbt = new class_2487();
            this.instance.method_10566(key, (class_2520)nbt);
            return nbt;
        }

        public NBTCoupler doRawCompound(String key, Consumer<class_2487> action) {
            if (this.instance.method_10573(key, 10)) {
                action.accept(this.instance.method_10562(key));
            }
            return this;
        }
    }
}

