/*
 * Decompiled with CFR 0.152.
 */
package michaelsebero.betterbiomeblend.client;

import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.locks.ReentrantLock;
import michaelsebero.betterbiomeblend.client.Color;
import michaelsebero.betterbiomeblend.client.ColorBlendCache;
import michaelsebero.betterbiomeblend.client.ColorChunk;
import michaelsebero.betterbiomeblend.client.ColorChunkCache;
import michaelsebero.betterbiomeblend.client.ColorChunkCacheProvider;
import michaelsebero.betterbiomeblend.client.StaticCompatibilityCache;
import michaelsebero.betterbiomeblend.client.optifine.OptifineCompatibility;
import michaelsebero.betterbiomeblend.config.BetterBiomeBlendConfig;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeColorHelper;

public final class BiomeColor {
    private static final ReentrantLock freeBlendCachesLock = new ReentrantLock();
    private static final Queue<ColorBlendCache> freeBlendCaches = new ArrayDeque<ColorBlendCache>();
    private static final byte[] NEIGHBOR_OFFSETS = new byte[]{-1, -1, 0, -1, 1, -1, -1, 0, 0, 0, 1, 0, -1, 1, 0, 1, 1, 1};
    private static final byte[] NEIGHBOR_RECT_PARAMS = new byte[]{-1, -1, 0, 0, -16, -16, 0, 0, 0, -1, 0, 0, 0, -16, 0, 0, 0, -1, -1, 0, 16, -16, 0, 0, -1, 0, 0, 0, -16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, 16, 0, 0, 0, -1, 0, 0, -1, -16, 16, 0, 0, 0, 0, 0, -1, 0, 16, 0, 0, 0, 0, -1, -1, 16, 16, 0, 0};
    private static final ThreadLocal<BlockPos.MutableBlockPos> MUTABLE_POS = ThreadLocal.withInitial(BlockPos.MutableBlockPos::new);

    private static int getNeighborOffsetX(int chunkIndex) {
        return NEIGHBOR_OFFSETS[2 * chunkIndex];
    }

    private static int getNeighborOffsetZ(int chunkIndex) {
        return NEIGHBOR_OFFSETS[2 * chunkIndex + 1];
    }

    private static int getNeighborRectMinX(int chunkIndex, int radius) {
        return NEIGHBOR_RECT_PARAMS[8 * chunkIndex] & 16 - radius;
    }

    private static int getNeighborRectMinZ(int chunkIndex, int radius) {
        return NEIGHBOR_RECT_PARAMS[8 * chunkIndex + 1] & 16 - radius;
    }

    private static int getNeighborRectMaxX(int chunkIndex, int radius) {
        return (NEIGHBOR_RECT_PARAMS[8 * chunkIndex + 2] & radius - 16) + 16;
    }

    private static int getNeighborRectMaxZ(int chunkIndex, int radius) {
        return (NEIGHBOR_RECT_PARAMS[8 * chunkIndex + 3] & radius - 16) + 16;
    }

    private static int getNeighborRectBlendCacheMinX(int chunkIndex, int radius) {
        return Math.max(NEIGHBOR_RECT_PARAMS[8 * chunkIndex + 4] + radius, 0);
    }

    private static int getNeighborRectBlendCacheMinZ(int chunkIndex, int radius) {
        return Math.max(NEIGHBOR_RECT_PARAMS[8 * chunkIndex + 5] + radius, 0);
    }

    public static void clearBlendCaches() {
        freeBlendCachesLock.lock();
        try {
            freeBlendCaches.clear();
        }
        finally {
            freeBlendCachesLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ColorBlendCache acquireBlendCache(int blendRadius) {
        ColorBlendCache result = null;
        freeBlendCachesLock.lock();
        try {
            for (ColorBlendCache cache : freeBlendCaches) {
                if (cache.blendRadius != blendRadius) continue;
                freeBlendCaches.remove(cache);
                result = cache;
                break;
            }
        }
        finally {
            freeBlendCachesLock.unlock();
        }
        if (result == null) {
            result = new ColorBlendCache(blendRadius);
        }
        return result;
    }

    private static void releaseBlendCache(ColorBlendCache cache) {
        int blendRadius = BetterBiomeBlendConfig.blendRadius;
        freeBlendCachesLock.lock();
        try {
            if (cache.blendRadius == blendRadius && freeBlendCaches.size() < 64) {
                freeBlendCaches.offer(cache);
            }
        }
        finally {
            freeBlendCachesLock.unlock();
        }
    }

    public static ThreadLocal<ColorChunk> getThreadLocalGrassChunkWrapper(IBlockAccess blockAccess) {
        World world = BiomeColor.getWorldFromBlockAccess(blockAccess);
        if (world instanceof ColorChunkCacheProvider) {
            return ((ColorChunkCacheProvider)world).bbb$getThreadLocalGrassChunk();
        }
        return StaticCompatibilityCache.getThreadLocalGrassChunkWrapper();
    }

    public static ThreadLocal<ColorChunk> getThreadLocalWaterChunkWrapper(IBlockAccess blockAccess) {
        World world = BiomeColor.getWorldFromBlockAccess(blockAccess);
        if (world instanceof ColorChunkCacheProvider) {
            return ((ColorChunkCacheProvider)world).bbb$getThreadLocalWaterChunk();
        }
        return StaticCompatibilityCache.getThreadLocalWaterChunkWrapper();
    }

    public static ThreadLocal<ColorChunk> getThreadLocalFoliageChunkWrapper(IBlockAccess blockAccess) {
        World world = BiomeColor.getWorldFromBlockAccess(blockAccess);
        if (world instanceof ColorChunkCacheProvider) {
            return ((ColorChunkCacheProvider)world).bbb$getThreadLocalFoliageChunk();
        }
        return StaticCompatibilityCache.getThreadLocalFoliageChunkWrapper();
    }

    public static ThreadLocal<ColorChunk> getThreadLocalGenericChunkWrapper(IBlockAccess blockAccess) {
        World world = BiomeColor.getWorldFromBlockAccess(blockAccess);
        if (world instanceof ColorChunkCacheProvider) {
            return ((ColorChunkCacheProvider)world).bbb$getThreadLocalGenericChunk();
        }
        return StaticCompatibilityCache.getThreadLocalGenericChunkWrapper();
    }

    public static ColorChunk getThreadLocalChunk(ThreadLocal<ColorChunk> threadLocal, int chunkX, int chunkZ, int colorType) {
        ColorChunk local = threadLocal.get();
        if (local.key == ColorChunkCache.getChunkKey(chunkX, chunkZ, colorType)) {
            return local;
        }
        return null;
    }

    public static void setThreadLocalChunk(ThreadLocal<ColorChunk> threadLocal, ColorChunk chunk, ColorChunkCache cache) {
        ColorChunk local = threadLocal.get();
        cache.releaseChunk(local);
        threadLocal.set(chunk);
    }

    private static void gatherRawColorsForChunk(IBlockAccess blockAccess, byte[] result, int chunkX, int chunkZ, BiomeColorHelper.ColorResolver colorResolver) {
        BlockPos.MutableBlockPos blockPos = MUTABLE_POS.get();
        int blockX = chunkX << 4;
        int blockZ = chunkZ << 4;
        int dstIndex = 0;
        for (int z = 0; z < 16; ++z) {
            for (int x = 0; x < 16; ++x) {
                blockPos.func_181079_c(blockX + x, 0, blockZ + z);
                int color = colorResolver.func_180283_a(blockAccess.func_180494_b((BlockPos)blockPos), (BlockPos)blockPos);
                result[dstIndex++] = (byte)(color & 0xFF);
                result[dstIndex++] = (byte)(color >> 8 & 0xFF);
                result[dstIndex++] = (byte)(color >> 16 & 0xFF);
            }
        }
    }

    private static void gatherRawColorsToBlendCache(IBlockAccess blockAccess, int chunkX, int chunkZ, int blendRadius, byte[] result, int chunkIndex, BiomeColorHelper.ColorResolver colorResolver) {
        BlockPos.MutableBlockPos blockPos = MUTABLE_POS.get();
        int blockX = chunkX << 4;
        int blockZ = chunkZ << 4;
        int srcMinX = BiomeColor.getNeighborRectMinX(chunkIndex, blendRadius);
        int srcMinZ = BiomeColor.getNeighborRectMinZ(chunkIndex, blendRadius);
        int srcMaxX = BiomeColor.getNeighborRectMaxX(chunkIndex, blendRadius);
        int srcMaxZ = BiomeColor.getNeighborRectMaxZ(chunkIndex, blendRadius);
        int dstMinX = BiomeColor.getNeighborRectBlendCacheMinX(chunkIndex, blendRadius);
        int dstMinZ = BiomeColor.getNeighborRectBlendCacheMinZ(chunkIndex, blendRadius);
        int dstDim = 16 + 2 * blendRadius;
        int dstLine = 3 * (dstMinX + dstMinZ * dstDim);
        for (int z = srcMinZ; z < srcMaxZ; ++z) {
            int dstIndex = dstLine;
            for (int x = srcMinX; x < srcMaxX; ++x) {
                blockPos.func_181079_c(blockX + x, 0, blockZ + z);
                int color = colorResolver.func_180283_a(blockAccess.func_180494_b((BlockPos)blockPos), (BlockPos)blockPos);
                result[dstIndex++] = (byte)(color & 0xFF);
                result[dstIndex++] = (byte)(color >> 8 & 0xFF);
                result[dstIndex++] = (byte)(color >> 16 & 0xFF);
            }
            dstLine += 3 * dstDim;
        }
    }

    private static void gatherRawColorsToBlendCache(IBlockAccess blockAccess, int chunkX, int chunkZ, int blendRadius, byte[] result, BiomeColorHelper.ColorResolver colorResolver) {
        for (int chunkIndex = 0; chunkIndex < 9; ++chunkIndex) {
            int offsetX = BiomeColor.getNeighborOffsetX(chunkIndex);
            int offsetZ = BiomeColor.getNeighborOffsetZ(chunkIndex);
            int rawChunkX = chunkX + offsetX;
            int rawChunkZ = chunkZ + offsetZ;
            BiomeColor.gatherRawColorsToBlendCache(blockAccess, rawChunkX, rawChunkZ, blendRadius, result, chunkIndex, colorResolver);
        }
    }

    private static void blendCachedColorsForChunk(byte[] result, ColorBlendCache blendCache) {
        int z;
        float[] R = blendCache.R;
        float[] G = blendCache.G;
        float[] B = blendCache.B;
        int blendRadius = blendCache.blendRadius;
        int blendDim = 2 * blendRadius + 1;
        int blendCacheDim = 16 + 2 * blendRadius;
        float invBlendCount = 1.0f / (float)(blendDim * blendDim);
        for (int x = 0; x < blendCacheDim; ++x) {
            int idx = 3 * x;
            R[x] = Color.sRGBByteToLinearFloat(0xFF & blendCache.color[idx]);
            G[x] = Color.sRGBByteToLinearFloat(0xFF & blendCache.color[idx + 1]);
            B[x] = Color.sRGBByteToLinearFloat(0xFF & blendCache.color[idx + 2]);
        }
        for (z = 1; z < blendDim; ++z) {
            int rowOffset = blendCacheDim * z;
            int x = 0;
            while (x < blendCacheDim) {
                int idx = 3 * (rowOffset + x);
                int n = x;
                R[n] = R[n] + Color.sRGBByteToLinearFloat(0xFF & blendCache.color[idx]);
                int n2 = x;
                G[n2] = G[n2] + Color.sRGBByteToLinearFloat(0xFF & blendCache.color[idx + 1]);
                int n3 = x++;
                B[n3] = B[n3] + Color.sRGBByteToLinearFloat(0xFF & blendCache.color[idx + 2]);
            }
        }
        for (z = 0; z < 16; ++z) {
            float accR = 0.0f;
            float accG = 0.0f;
            float accB = 0.0f;
            for (int x = 0; x < blendDim; ++x) {
                accR += R[x];
                accG += G[x];
                accB += B[x];
            }
            int rowStart = 48 * z;
            for (int x = 0; x < 16; ++x) {
                int dstIdx = rowStart + 3 * x;
                result[dstIdx] = Color.linearFloatTosRGBByte(accR * invBlendCount);
                result[dstIdx + 1] = Color.linearFloatTosRGBByte(accG * invBlendCount);
                result[dstIdx + 2] = Color.linearFloatTosRGBByte(accB * invBlendCount);
                if (x >= 15) continue;
                accR += R[x + blendDim] - R[x];
                accG += G[x + blendDim] - G[x];
                accB += B[x + blendDim] - B[x];
            }
            if (z >= 15) continue;
            int oldRow = blendCacheDim * z;
            int newRow = blendCacheDim * (z + blendDim);
            int x = 0;
            while (x < blendCacheDim) {
                int oldIdx = 3 * (oldRow + x);
                int newIdx = 3 * (newRow + x);
                int n = x;
                R[n] = R[n] + (Color.sRGBByteToLinearFloat(0xFF & blendCache.color[newIdx]) - Color.sRGBByteToLinearFloat(0xFF & blendCache.color[oldIdx]));
                int n4 = x;
                G[n4] = G[n4] + (Color.sRGBByteToLinearFloat(0xFF & blendCache.color[newIdx + 1]) - Color.sRGBByteToLinearFloat(0xFF & blendCache.color[oldIdx + 1]));
                int n5 = x++;
                B[n5] = B[n5] + (Color.sRGBByteToLinearFloat(0xFF & blendCache.color[newIdx + 2]) - Color.sRGBByteToLinearFloat(0xFF & blendCache.color[oldIdx + 2]));
            }
        }
    }

    public static void generateBlendedColorChunk(IBlockAccess blockAccess, int chunkX, int chunkZ, byte[] result, int colorType, BiomeColorHelper.ColorResolver colorResolver) {
        int blendRadius = BetterBiomeBlendConfig.blendRadius;
        if (blendRadius > 0 && blendRadius <= 14) {
            ColorBlendCache blendCache = BiomeColor.acquireBlendCache(blendRadius);
            BiomeColor.gatherRawColorsToBlendCache(blockAccess, chunkX, chunkZ, blendCache.blendRadius, blendCache.color, colorResolver);
            BiomeColor.blendCachedColorsForChunk(result, blendCache);
            BiomeColor.releaseBlendCache(blendCache);
        } else {
            BiomeColor.gatherRawColorsForChunk(blockAccess, result, chunkX, chunkZ, colorResolver);
        }
    }

    private static World getWorldFromBlockAccess(IBlockAccess blockAccess) {
        ChunkCache chunkCache;
        if (blockAccess instanceof World) {
            return (World)blockAccess;
        }
        if (blockAccess instanceof ChunkCache) {
            return ((ChunkCache)blockAccess).field_72815_e;
        }
        if (OptifineCompatibility.isChunkCacheOF(blockAccess) && (chunkCache = OptifineCompatibility.getChunkCacheFromChunkCacheOF(blockAccess)) != null) {
            return chunkCache.field_72815_e;
        }
        return null;
    }

    public static ColorChunkCache getColorChunkCacheForWorld(World world) {
        if (world instanceof ColorChunkCacheProvider) {
            return ((ColorChunkCacheProvider)world).bbb$getColorChunkCache();
        }
        return StaticCompatibilityCache.getColorChunkCache();
    }

    public static ColorChunkCache getColorChunkCacheForIBlockAccess(IBlockAccess blockAccess) {
        World world = BiomeColor.getWorldFromBlockAccess(blockAccess);
        return BiomeColor.getColorChunkCacheForWorld(world);
    }

    public static ColorChunk getBlendedColorChunk(ColorChunkCache cache, IBlockAccess blockAccess, int colorID, int chunkX, int chunkZ, BiomeColorHelper.ColorResolver colorResolver) {
        ColorChunk chunk = cache.getChunk(chunkX, chunkZ, colorID);
        if (chunk == null) {
            chunk = cache.newChunk(chunkX, chunkZ, colorID);
            BiomeColor.generateBlendedColorChunk(blockAccess, chunkX, chunkZ, chunk.data, colorID, colorResolver);
            cache.putChunk(chunk);
        }
        return chunk;
    }
}

