/*
 * Decompiled with CFR 0.152.
 */
package michaelsebero.betterbiomeblend.client;

import java.util.concurrent.atomic.AtomicInteger;
import michaelsebero.betterbiomeblend.client.Color;

public final class ColorChunk {
    public byte[] data;
    public long key;
    public int invalidationCounter;
    public AtomicInteger refCount = new AtomicInteger();

    public ColorChunk() {
        this.data = new byte[768];
        this.markAsInvalid();
    }

    public int getReferenceCount() {
        return this.refCount.get();
    }

    public int release() {
        return this.refCount.decrementAndGet();
    }

    public void acquire() {
        this.refCount.incrementAndGet();
    }

    public void markAsInvalid() {
        this.key = -2251799780130816L;
    }

    public int getColor(int x, int z) {
        int blockX = x & 0xF;
        int blockZ = z & 0xF;
        int offset = 3 * (blockZ << 4 | blockX);
        byte colorR = this.data[offset];
        byte colorG = this.data[offset + 1];
        byte colorB = this.data[offset + 2];
        return Color.makeRGBAWithFullAlpha(colorR, colorG, colorB);
    }
}

