/*
 * Decompiled with CFR 0.152.
 */
package michaelsebero.betterbiomeblend.config;

import michaelsebero.betterbiomeblend.client.BiomeColor;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Config(modid="betterbiomeblend")
public class BetterBiomeBlendConfig {
    @Config.Name(value="Blend Radius")
    @Config.Comment(value={"Higher values = smoother blending but more performance impact"})
    @Config.RangeInt(min=0, max=14)
    @Config.RequiresWorldRestart
    public static int blendRadius = 14;
    @Config.Name(value="Cache Size")
    @Config.Comment(value={"Number of color chunks to cache. Higher = less recalculation, more memory"})
    @Config.RangeInt(min=512, max=8192)
    @Config.RequiresMcRestart
    public static int cacheSize = 2048;
    @Config.Name(value="Enable Distance-Based Quality")
    @Config.Comment(value={"Reduce blending quality for distant chunks to improve performance"})
    public static boolean enableDistanceBasedQuality = true;
    @Config.Name(value="High Quality Distance")
    @Config.Comment(value={"Distance (in blocks) for full quality blending"})
    @Config.RangeDouble(min=16.0, max=256.0)
    public static double highQualityDistance = 64.0;
    @Config.Name(value="Medium Quality Distance")
    @Config.Comment(value={"Distance (in blocks) for medium quality blending"})
    @Config.RangeDouble(min=32.0, max=512.0)
    public static double mediumQualityDistance = 128.0;
    @Config.Name(value="Low Quality Distance")
    @Config.Comment(value={"Distance (in blocks) for low quality blending"})
    @Config.RangeDouble(min=64.0, max=1024.0)
    public static double lowQualityDistance = 256.0;
    @Config.Name(value="Enable Async Generation")
    @Config.Comment(value={"Generate color chunks asynchronously (experimental)"})
    public static boolean enableAsyncGeneration = false;
    @Config.Name(value="Async Thread Count")
    @Config.Comment(value={"Number of threads for async color generation"})
    @Config.RangeInt(min=1, max=8)
    public static int asyncThreadCount = 2;
    @Config.Name(value="Enable Smart Invalidation")
    @Config.Comment(value={"Only invalidate chunks that are actually affected by biome changes"})
    public static boolean enableSmartInvalidation = true;
    @Config.Name(value="Grass Color Blending")
    @Config.Comment(value={"Enable blending for grass colors"})
    public static boolean blendGrass = true;
    @Config.Name(value="Water Color Blending")
    @Config.Comment(value={"Enable blending for water colors"})
    public static boolean blendWater = true;
    @Config.Name(value="Foliage Color Blending")
    @Config.Comment(value={"Enable blending for foliage colors"})
    public static boolean blendFoliage = true;
    @Config.Name(value="Cache Cleanup Interval")
    @Config.Comment(value={"Ticks between cache cleanup passes (0 = disabled)"})
    @Config.RangeInt(min=0, max=12000)
    public static int cacheCleanupInterval = 1200;
    @Config.Name(value="Max Cache Age")
    @Config.Comment(value={"Maximum age (in ticks) for cached chunks before cleanup"})
    @Config.RangeInt(min=600, max=24000)
    public static int maxCacheAge = 6000;
    @Config.Name(value="Use Bilinear Interpolation")
    @Config.Comment(value={"Use bilinear interpolation for smoother color transitions"})
    public static boolean useBilinearInterpolation = false;
    @Config.Name(value="Enable Debug Overlay")
    @Config.Comment(value={"Show debug information about color chunk cache"})
    public static boolean enableDebugOverlay = false;

    @Mod.EventBusSubscriber(modid="betterbiomeblend")
    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        @SideOnly(value=Side.CLIENT)
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("betterbiomeblend")) {
                ConfigManager.sync((String)"betterbiomeblend", (Config.Type)Config.Type.INSTANCE);
                BiomeColor.clearBlendCaches();
            }
        }
    }
}

