/*
 * Decompiled with CFR 0.152.
 */
package com.henrique.punchy;

import com.henrique.punchy.Punchy;
import com.henrique.punchy.client.BlockActionGuards;
import com.henrique.punchy.client.render.ShubbaDuckTuning;
import com.henrique.punchy.client.render.ToolTuning;
import com.henrique.punchy.client.render.VanillaAxeProxies;
import com.henrique.punchy.client.render.VanillaBlockProxies;
import com.henrique.punchy.client.render.VanillaHoeProxies;
import com.henrique.punchy.client.render.VanillaMaceProxies;
import com.henrique.punchy.client.render.VanillaPickaxeProxies;
import com.henrique.punchy.client.render.VanillaProxyContext;
import com.henrique.punchy.client.render.VanillaShieldProxies;
import com.henrique.punchy.client.render.VanillaShovelProxies;
import com.henrique.punchy.client.render.VanillaSwordProxies;
import com.henrique.punchy.client.render.VanillaTridentProxies;
import com.henrique.punchy.client.renderer.layer.ArmToolTuning;
import com.henrique.punchy.client.renderer.layer.PlayerArmModelLayer;
import com.henrique.punchy.client.renderer.layer.VanillaFirstPersonItemLayer;
import com.henrique.punchy.config.PunchyConfig;
import com.henrique.punchy.config.PunchyTuningConfig;
import com.henrique.punchy.item.AnimatedAxe;
import com.henrique.punchy.item.AnimatedBlockProxy;
import com.henrique.punchy.item.AnimatedHoe;
import com.henrique.punchy.item.AnimatedMace;
import com.henrique.punchy.item.AnimatedPickaxe;
import com.henrique.punchy.item.AnimatedShield;
import com.henrique.punchy.item.AnimatedShovel;
import com.henrique.punchy.item.AnimatedSword;
import com.henrique.punchy.item.AnimatedTool;
import com.henrique.punchy.item.AnimatedTrident;
import com.henrique.punchy.networking.ModMessages;
import com.henrique.punchy.util.AxeStripHelper;
import java.util.List;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1743;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1794;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1819;
import net.minecraft.class_1821;
import net.minecraft.class_1835;
import net.minecraft.class_1839;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_3965;
import net.minecraft.class_746;
import net.minecraft.class_7923;
import net.minecraft.class_9334;
import net.minecraft.class_9362;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animatable.manager.AnimatableManager;
import software.bernie.geckolib.animatable.processing.AnimationController;

public class PunchyClient
implements ClientModInitializer {
    private static PunchyClient INSTANCE;
    private boolean wasAttacking = false;
    public static boolean isMiningAnimationPlaying;
    public static long miningAnimationStartTime;
    public static class_2338 lastMiningTargetPos;
    private static final int BASE_ANIM_TICKS = 40;
    private class_304 offXMinus;
    private class_304 offXPlus;
    private class_304 offYMinus;
    private class_304 offYPlus;
    private class_304 offZMinus;
    private class_304 offZPlus;
    private class_304 rotXMinus;
    private class_304 rotXPlus;
    private class_304 rotYMinus;
    private class_304 rotYPlus;
    private class_304 rotZMinus;
    private class_304 rotZPlus;
    private class_304 scaleMinus;
    private class_304 scalePlus;
    private class_304 inspectKey;
    private class_304 editToggleKey;
    private class_304 resetDefaultsKey;
    private class_304 cycleCategoryKey;
    private class_304 armSideToggleKey;
    private boolean tuningEnabled;
    private boolean editingArm = false;
    private boolean editingLeftArm = false;
    private int tuningCategoryIndex = 0;
    private int tickCounter = 0;
    private int lastCustomHitTick = -1000;
    private int lastMineTriggerTick = -100000;
    private class_1799 lastAnimatedStack = null;
    private class_2960 lastSelectItemId = null;
    private long clickLockUntilTick = -1L;
    private boolean isLooping = false;
    private boolean stopLoopAtBoundary = false;
    private long loopStopAtTick = -1L;
    private LoopContext loopContext = LoopContext.NONE;
    private boolean wasShieldBlocking = false;
    private class_1268 lastShieldBlockingHand = class_1268.field_5808;
    private boolean wasTridentCharging = false;
    private class_1268 lastTridentChargingHand = class_1268.field_5808;
    private boolean wasEating = false;
    private class_1268 lastEatingHand = class_1268.field_5808;
    private boolean wasDrinking = false;
    private class_1268 lastDrinkingHand = class_1268.field_5808;
    private GeoItem lastEatingGeo = null;
    private long lastEatingAnimId = -1L;
    private GeoItem lastDrinkingGeo = null;
    private long lastDrinkingAnimId = -1L;
    private final HandAnim rightAnim = new HandAnim();
    private final HandAnim leftAnim = new HandAnim();

    public void onInitializeClient() {
        INSTANCE = this;
        PunchyConfig cfg = PunchyConfig.load();
        Punchy.ANIM_SPEED = cfg.getSpeedPreset().speed;
        Punchy.SWORD_ANIM_SPEED = cfg.getSwordSpeed().multiplier;
        Punchy.MACE_ANIM_SPEED = cfg.getMaceSpeed().multiplier;
        Punchy.TRIDENT_ANIM_SPEED = cfg.getTridentSpeed().multiplier;
        Punchy.TRIDENT_THROW_SPEED = cfg.getTridentThrowSpeed().multiplier;
        Punchy.applyCombatToggles(cfg);
        ToolTuning.resetDefaults();
        ShubbaDuckTuning.resetDefaults();
        ArmToolTuning.resetDefaults();
        PunchyTuningConfig.loadAndApply();
        ClientLifecycleEvents.CLIENT_STOPPING.register(client -> PunchyTuningConfig.saveCurrent());
        this.tuningEnabled = FabricLoader.getInstance().isDevelopmentEnvironment();
        if (this.tuningEnabled) {
            this.offXMinus = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.punchy.arm.offx.minus", class_3675.class_307.field_1668, 264, class_304.class_11900.field_62556));
            this.offXPlus = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.punchy.arm.offx.plus", class_3675.class_307.field_1668, 265, class_304.class_11900.field_62556));
            this.offYMinus = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.punchy.arm.offy.minus", class_3675.class_307.field_1668, 267, class_304.class_11900.field_62556));
            this.offYPlus = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.punchy.arm.offy.plus", class_3675.class_307.field_1668, 266, class_304.class_11900.field_62556));
            this.offZMinus = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.punchy.arm.offz.minus", class_3675.class_307.field_1668, 262, class_304.class_11900.field_62556));
            this.offZPlus = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.punchy.arm.offz.plus", class_3675.class_307.field_1668, 263, class_304.class_11900.field_62556));
            this.rotXMinus = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.punchy.arm.rotx.minus", class_3675.class_307.field_1671, 326, class_304.class_11900.field_62556));
            this.rotXPlus = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.punchy.arm.rotx.plus", class_3675.class_307.field_1671, 324, class_304.class_11900.field_62556));
            this.rotYMinus = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.punchy.arm.roty.minus", class_3675.class_307.field_1671, 329, class_304.class_11900.field_62556));
            this.rotYPlus = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.punchy.arm.roty.plus", class_3675.class_307.field_1671, 327, class_304.class_11900.field_62556));
            this.rotZMinus = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.punchy.arm.rotz.minus", class_3675.class_307.field_1671, 328, class_304.class_11900.field_62556));
            this.rotZPlus = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.punchy.arm.rotz.plus", class_3675.class_307.field_1671, 322, class_304.class_11900.field_62556));
            this.scaleMinus = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.punchy.arm.scale.minus", class_3675.class_307.field_1668, 333, class_304.class_11900.field_62556));
            this.scalePlus = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.punchy.arm.scale.plus", class_3675.class_307.field_1668, 334, class_304.class_11900.field_62556));
            this.inspectKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.punchy.inspect", class_3675.class_307.field_1668, 73, class_304.class_11900.field_62556));
            this.editToggleKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.punchy.edit.toggle", class_3675.class_307.field_1668, 260, class_304.class_11900.field_62556));
            this.resetDefaultsKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.punchy.edit.reset_defaults", class_3675.class_307.field_1668, 332, class_304.class_11900.field_62556));
            this.cycleCategoryKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.punchy.edit.cycle_category", class_3675.class_307.field_1668, 268, class_304.class_11900.field_62556));
            this.armSideToggleKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.punchy.edit.arm_side", class_3675.class_307.field_1668, 269, class_304.class_11900.field_62556));
        } else {
            this.offZPlus = null;
            this.offZMinus = null;
            this.offYPlus = null;
            this.offYMinus = null;
            this.offXPlus = null;
            this.offXMinus = null;
            this.rotZPlus = null;
            this.rotZMinus = null;
            this.rotYPlus = null;
            this.rotYMinus = null;
            this.rotXPlus = null;
            this.rotXMinus = null;
            this.scalePlus = null;
            this.scaleMinus = null;
            this.inspectKey = null;
            this.armSideToggleKey = null;
            this.cycleCategoryKey = null;
            this.resetDefaultsKey = null;
            this.editToggleKey = null;
        }
        ClientTickEvents.END_CLIENT_TICK.register(this::onClientTick);
        ClientTickEvents.END_CLIENT_TICK.register(this::onClientTick);
        ModMessages.registerS2CPackets();
    }

    private HandAnim handState(class_1268 h) {
        return h == class_1268.field_5810 ? this.leftAnim : this.rightAnim;
    }

    private static boolean isVanillaPickaxeItem(class_1792 it) {
        return it == class_1802.field_8647 || it == class_1802.field_8387 || it == class_1802.field_8403 || it == class_1802.field_61340 || it == class_1802.field_8335 || it == class_1802.field_8377 || it == class_1802.field_22024;
    }

    private static boolean isVanillaHoeItem(class_1792 it) {
        return it == class_1802.field_8167 || it == class_1802.field_8431 || it == class_1802.field_8609 || it == class_1802.field_61342 || it == class_1802.field_8303 || it == class_1802.field_8527 || it == class_1802.field_22026;
    }

    private static boolean isVanillaShovelItem(class_1792 it) {
        return it == class_1802.field_8876 || it == class_1802.field_8776 || it == class_1802.field_8699 || it == class_1802.field_61339 || it == class_1802.field_8322 || it == class_1802.field_8250 || it == class_1802.field_22023;
    }

    private static boolean isVanillaSwordItem(class_1792 it) {
        return it == class_1802.field_8091 || it == class_1802.field_8528 || it == class_1802.field_8371 || it == class_1802.field_61338 || it == class_1802.field_8845 || it == class_1802.field_8802 || it == class_1802.field_22022;
    }

    private static boolean isVanillaMaceItem(class_1792 it) {
        return it == class_1802.field_49814;
    }

    private static boolean isVanillaTridentItem(class_1792 it) {
        return it == class_1802.field_8547;
    }

    private static boolean isOffhandRestrictedItem(class_1792 item) {
        if (item == null) {
            return false;
        }
        return item instanceof AnimatedPickaxe || item instanceof AnimatedAxe || item instanceof AnimatedHoe || item instanceof AnimatedShovel || item instanceof AnimatedSword || item instanceof AnimatedMace || item instanceof AnimatedTrident || item instanceof AnimatedShield || item instanceof class_1743 || item instanceof class_1794 || item instanceof class_1821 || item instanceof class_9362 || item instanceof class_1835 || item instanceof class_1819 || PunchyClient.isVanillaPickaxeItem(item) || PunchyClient.isVanillaHoeItem(item) || PunchyClient.isVanillaShovelItem(item) || PunchyClient.isVanillaSwordItem(item) || PunchyClient.isVanillaMaceItem(item) || PunchyClient.isVanillaTridentItem(item) || item == class_1802.field_8255;
    }

    private static boolean isOffhandRestrictedStack(class_1799 stack) {
        return stack != null && !stack.method_7960() && PunchyClient.isOffhandRestrictedItem(stack.method_7909());
    }

    private static class_1799 pickaxeGeoStackForHand(class_1657 player, class_1268 hand) {
        if (hand == class_1268.field_5810 && !player.method_6047().method_7960()) {
            return null;
        }
        class_1799 s = player.method_5998(hand);
        if (s == null || s.method_7960()) {
            return null;
        }
        class_1792 it = s.method_7909();
        if (it instanceof AnimatedShield) {
            return hand == class_1268.field_5808 ? null : s;
        }
        if (it instanceof AnimatedTool) {
            if (it instanceof AnimatedSword) {
                return null;
            }
            if (it instanceof AnimatedBlockProxy) {
                return null;
            }
            return s;
        }
        if (it instanceof class_1743 && !(it instanceof GeoItem)) {
            return VanillaAxeProxies.forVanilla(it, hand);
        }
        if (it instanceof class_1794 && !(it instanceof GeoItem)) {
            return VanillaHoeProxies.forVanilla(it, hand);
        }
        if (it instanceof class_1821 && !(it instanceof GeoItem)) {
            return VanillaShovelProxies.forVanilla(it, hand);
        }
        if (PunchyClient.isVanillaPickaxeItem(it)) {
            return VanillaPickaxeProxies.forVanilla(it, hand);
        }
        if (it == class_1802.field_8547 && !(it instanceof GeoItem)) {
            return VanillaTridentProxies.proxy(hand);
        }
        if (it == class_1802.field_8255) {
            if (hand == class_1268.field_5808) {
                return null;
            }
            return VanillaShieldProxies.forHand(hand);
        }
        return null;
    }

    private static double resolveAnimSpeed(class_1799 stack) {
        if (stack != null) {
            class_1792 item = stack.method_7909();
            if (item instanceof AnimatedSword) {
                return Punchy.SWORD_ANIM_SPEED;
            }
            if (item instanceof AnimatedMace) {
                return Punchy.MACE_ANIM_SPEED;
            }
            if (item instanceof AnimatedTrident) {
                return Punchy.TRIDENT_ANIM_SPEED;
            }
            if (item instanceof AnimatedBlockProxy) {
                return Punchy.BLOCK_PLACE_SPEED;
            }
        }
        return Punchy.ANIM_SPEED;
    }

    private static double resolveAnimSpeed(LoopContext ctx) {
        if (ctx == LoopContext.AIR_SWORD || ctx == LoopContext.SWORD_SINGLE) {
            return Punchy.SWORD_ANIM_SPEED;
        }
        if (ctx == LoopContext.BLOCK) {
            return Punchy.BLOCK_PLACE_SPEED;
        }
        return Punchy.ANIM_SPEED;
    }

    private static void drainKeys(class_304 ... keys) {
        if (keys == null) {
            return;
        }
        for (class_304 key : keys) {
            if (key == null) continue;
            while (key.method_1436()) {
            }
        }
    }

    private void onClientTick(class_310 client) {
        class_1799 ps;
        boolean anyPickaxe;
        int isSword;
        class_2960 vanillaId;
        Object s;
        if (client.field_1724 == null || client.field_1687 == null) {
            return;
        }
        ++this.tickCounter;
        boolean debugEnabled = this.tuningEnabled && Punchy.DEBUG_POSITION;
        boolean changed = false;
        if (debugEnabled) {
            Object shubba;
            Object block;
            Object shield;
            Object trident;
            Object mace;
            Object sword;
            Object shovel;
            List<Object> ps2;
            String target;
            while (this.editToggleKey.method_1436()) {
                this.editingArm = !this.editingArm;
                target = this.editingArm ? "Arm" : "Item";
                client.field_1724.method_7353(class_2561.method_30163((String)("Editing target: " + target)), true);
            }
            while (this.armSideToggleKey.method_1436()) {
                this.editingLeftArm = !this.editingLeftArm;
                target = this.editingArm ? "Arm" : "Item";
                client.field_1724.method_7353(class_2561.method_30163((String)(target + " side: " + (this.editingLeftArm ? "Left" : "Right"))), true);
            }
            while (this.cycleCategoryKey.method_1436()) {
                this.tuningCategoryIndex = (this.tuningCategoryIndex + 1) % 8;
                String cat = switch (this.tuningCategoryIndex) {
                    case 0 -> "Axe/Pick/Hoe";
                    case 1 -> "Shovel";
                    case 2 -> "Sword";
                    case 3 -> "Mace";
                    case 4 -> "Trident";
                    case 5 -> "Shield";
                    case 6 -> "Blocks";
                    default -> "Shubba Duck";
                };
                String target2 = this.editingArm ? "Arm" : "Item";
                client.field_1724.method_7353(class_2561.method_30163((String)String.format("Tuning category: %s (%s)", cat, target2)), true);
            }
            while (this.resetDefaultsKey.method_1436()) {
                if (this.editingArm) {
                    ArmToolTuning.resetDefaults();
                    client.field_1724.method_7353(class_2561.method_30163((String)"Restored Arm defaults (Axe/Pick)"), true);
                } else {
                    ToolTuning.resetDefaults();
                    ShubbaDuckTuning.resetDefaults();
                    client.field_1724.method_7353(class_2561.method_30163((String)"Restored Item defaults (Axe/Pick)"), true);
                }
                PunchyTuningConfig.saveCurrent();
            }
            float stepT = 0.02f;
            float stepR = 1.0f;
            float stepS = 0.05f;
            if (!this.editingArm) {
                if (this.tuningCategoryIndex == 0) {
                    ToolTuning.Profile a = ToolTuning.get(VanillaFirstPersonItemLayer.ToolKind.AXE, this.editingLeftArm);
                    ToolTuning.Profile k = ToolTuning.get(VanillaFirstPersonItemLayer.ToolKind.PICKAXE, this.editingLeftArm);
                    ToolTuning.Profile h = ToolTuning.get(VanillaFirstPersonItemLayer.ToolKind.HOE, this.editingLeftArm);
                    ps2 = List.of(a, k, h);
                } else if (this.tuningCategoryIndex == 1) {
                    shovel = ToolTuning.get(VanillaFirstPersonItemLayer.ToolKind.SHOVEL, this.editingLeftArm);
                    ps2 = List.of(shovel);
                } else if (this.tuningCategoryIndex == 2) {
                    sword = ToolTuning.get(VanillaFirstPersonItemLayer.ToolKind.SWORD, this.editingLeftArm);
                    ps2 = List.of(sword);
                } else if (this.tuningCategoryIndex == 3) {
                    mace = ToolTuning.get(VanillaFirstPersonItemLayer.ToolKind.MACE, this.editingLeftArm);
                    ps2 = List.of(mace);
                } else if (this.tuningCategoryIndex == 4) {
                    trident = ToolTuning.get(VanillaFirstPersonItemLayer.ToolKind.TRIDENT, this.editingLeftArm);
                    ps2 = List.of(trident);
                } else if (this.tuningCategoryIndex == 5) {
                    shield = ToolTuning.get(VanillaFirstPersonItemLayer.ToolKind.SHIELD, this.editingLeftArm);
                    ps2 = List.of(shield);
                } else if (this.tuningCategoryIndex == 6) {
                    block = ToolTuning.get(VanillaFirstPersonItemLayer.ToolKind.BLOCK, this.editingLeftArm);
                    ps2 = List.of(block);
                } else {
                    shubba = ShubbaDuckTuning.get(this.editingLeftArm);
                    ps2 = List.of(shubba);
                }
                while (this.offXMinus.method_1436()) {
                    ps2.forEach(p -> p.offX -= stepT);
                    changed = true;
                }
                while (this.offXPlus.method_1436()) {
                    ps2.forEach(p -> p.offX += stepT);
                    changed = true;
                }
                while (this.offYMinus.method_1436()) {
                    ps2.forEach(p -> p.offY -= stepT);
                    changed = true;
                }
                while (this.offYPlus.method_1436()) {
                    ps2.forEach(p -> p.offY += stepT);
                    changed = true;
                }
                while (this.offZMinus.method_1436()) {
                    ps2.forEach(p -> p.offZ -= stepT);
                    changed = true;
                }
                while (this.offZPlus.method_1436()) {
                    ps2.forEach(p -> p.offZ += stepT);
                    changed = true;
                }
                while (this.rotXMinus.method_1436()) {
                    ps2.forEach(p -> p.rotX -= stepR);
                    changed = true;
                }
                while (this.rotXPlus.method_1436()) {
                    ps2.forEach(p -> p.rotX += stepR);
                    changed = true;
                }
                while (this.rotYMinus.method_1436()) {
                    ps2.forEach(p -> p.rotY -= stepR);
                    changed = true;
                }
                while (this.rotYPlus.method_1436()) {
                    ps2.forEach(p -> p.rotY += stepR);
                    changed = true;
                }
                while (this.rotZMinus.method_1436()) {
                    ps2.forEach(p -> p.rotZ -= stepR);
                    changed = true;
                }
                while (this.rotZPlus.method_1436()) {
                    ps2.forEach(p -> p.rotZ += stepR);
                    changed = true;
                }
                while (this.scaleMinus.method_1436()) {
                    ps2.forEach(p -> {
                        p.scale = Math.max(0.1f, p.scale - stepS);
                    });
                    changed = true;
                }
                while (this.scalePlus.method_1436()) {
                    ps2.forEach(p -> {
                        p.scale = Math.min(10.0f, p.scale + stepS);
                    });
                    changed = true;
                }
            }
            if (this.editingArm) {
                if (this.tuningCategoryIndex == 0) {
                    ArmToolTuning.Profile axe = ArmToolTuning.get(PlayerArmModelLayer.ToolKind.AXE, this.editingLeftArm);
                    class_1268[] pick = ArmToolTuning.get(PlayerArmModelLayer.ToolKind.PICKAXE, this.editingLeftArm);
                    ArmToolTuning.Profile hoe = ArmToolTuning.get(PlayerArmModelLayer.ToolKind.HOE, this.editingLeftArm);
                    ps2 = List.of(axe, pick, hoe);
                } else if (this.tuningCategoryIndex == 1) {
                    shovel = ArmToolTuning.get(PlayerArmModelLayer.ToolKind.SHOVEL, this.editingLeftArm);
                    ps2 = List.of(shovel);
                } else if (this.tuningCategoryIndex == 2) {
                    sword = ArmToolTuning.get(PlayerArmModelLayer.ToolKind.SWORD, this.editingLeftArm);
                    ps2 = List.of(sword);
                } else if (this.tuningCategoryIndex == 3) {
                    mace = ArmToolTuning.get(PlayerArmModelLayer.ToolKind.MACE, this.editingLeftArm);
                    ps2 = List.of(mace);
                } else if (this.tuningCategoryIndex == 4) {
                    trident = ArmToolTuning.get(PlayerArmModelLayer.ToolKind.TRIDENT, this.editingLeftArm);
                    ps2 = List.of(trident);
                } else if (this.tuningCategoryIndex == 5) {
                    shield = ArmToolTuning.get(PlayerArmModelLayer.ToolKind.SHIELD, this.editingLeftArm);
                    ps2 = List.of(shield);
                } else if (this.tuningCategoryIndex == 6) {
                    block = ArmToolTuning.get(PlayerArmModelLayer.ToolKind.BLOCK, this.editingLeftArm);
                    ps2 = List.of(block);
                } else {
                    shubba = ArmToolTuning.get(PlayerArmModelLayer.ToolKind.SHUBBA_DUCK, this.editingLeftArm);
                    ps2 = List.of(shubba);
                }
                while (this.offXMinus.method_1436()) {
                    ps2.forEach(p -> p.offX -= stepT);
                    changed = true;
                }
                while (this.offXPlus.method_1436()) {
                    ps2.forEach(p -> p.offX += stepT);
                    changed = true;
                }
                while (this.offYMinus.method_1436()) {
                    ps2.forEach(p -> p.offY -= stepT);
                    changed = true;
                }
                while (this.offYPlus.method_1436()) {
                    ps2.forEach(p -> p.offY += stepT);
                    changed = true;
                }
                while (this.offZMinus.method_1436()) {
                    ps2.forEach(p -> p.offZ -= stepT);
                    changed = true;
                }
                while (this.offZPlus.method_1436()) {
                    ps2.forEach(p -> p.offZ += stepT);
                    changed = true;
                }
                while (this.rotXMinus.method_1436()) {
                    ps2.forEach(p -> p.rotX -= stepR);
                    changed = true;
                }
                while (this.rotXPlus.method_1436()) {
                    ps2.forEach(p -> p.rotX += stepR);
                    changed = true;
                }
                while (this.rotYMinus.method_1436()) {
                    ps2.forEach(p -> p.rotY -= stepR);
                    changed = true;
                }
                while (this.rotYPlus.method_1436()) {
                    ps2.forEach(p -> p.rotY += stepR);
                    changed = true;
                }
                while (this.rotZMinus.method_1436()) {
                    ps2.forEach(p -> p.rotZ -= stepR);
                    changed = true;
                }
                while (this.rotZPlus.method_1436()) {
                    ps2.forEach(p -> p.rotZ += stepR);
                    changed = true;
                }
                while (this.scaleMinus.method_1436()) {
                    ps2.forEach(p -> {
                        p.scale = Math.max(0.1f, p.scale - stepS);
                    });
                    changed = true;
                }
                while (this.scalePlus.method_1436()) {
                    ps2.forEach(p -> {
                        p.scale = Math.min(10.0f, p.scale + stepS);
                    });
                    changed = true;
                }
            }
        } else {
            PunchyClient.drainKeys(this.editToggleKey, this.armSideToggleKey, this.cycleCategoryKey, this.resetDefaultsKey, this.offXMinus, this.offXPlus, this.offYMinus, this.offYPlus, this.offZMinus, this.offZPlus, this.rotXMinus, this.rotXPlus, this.rotYMinus, this.rotYPlus, this.rotZMinus, this.rotZPlus, this.scaleMinus, this.scalePlus, this.inspectKey);
        }
        if (changed) {
            PunchyTuningConfig.saveCurrent();
        }
        if (changed && client.field_1724 != null) {
            String cat;
            switch (this.tuningCategoryIndex) {
                case 0: {
                    String string = "Axe/Pick/Hoe";
                    break;
                }
                case 1: {
                    String string = "Shovel";
                    break;
                }
                case 2: {
                    String string = "Sword";
                    break;
                }
                case 3: {
                    String string = "Mace";
                    break;
                }
                case 4: {
                    String string = "Trident";
                    break;
                }
                case 5: {
                    String string = "Shield";
                    break;
                }
                case 6: {
                    String string = "Blocks";
                    break;
                }
                default: {
                    String string = cat = "Shubba Duck";
                }
            }
            if (!this.editingArm) {
                if (this.tuningCategoryIndex == 7) {
                    ToolTuning.Profile p2 = ShubbaDuckTuning.get(this.editingLeftArm);
                    client.field_1724.method_7353(class_2561.method_30163((String)String.format("Item(%s - %s) off=(%.3f, %.3f, %.3f) rot=(%.1f, %.1f, %.1f) scale=%.2f", cat, this.editingLeftArm ? "Left" : "Right", Float.valueOf(p2.offX), Float.valueOf(p2.offY), Float.valueOf(p2.offZ), Float.valueOf(p2.rotX), Float.valueOf(p2.rotY), Float.valueOf(p2.rotZ), Float.valueOf(p2.scale))), true);
                } else {
                    VanillaFirstPersonItemLayer.ToolKind tk = switch (this.tuningCategoryIndex) {
                        case 1 -> VanillaFirstPersonItemLayer.ToolKind.SHOVEL;
                        case 2 -> VanillaFirstPersonItemLayer.ToolKind.SWORD;
                        case 3 -> VanillaFirstPersonItemLayer.ToolKind.MACE;
                        case 4 -> VanillaFirstPersonItemLayer.ToolKind.TRIDENT;
                        case 5 -> VanillaFirstPersonItemLayer.ToolKind.SHIELD;
                        case 6 -> VanillaFirstPersonItemLayer.ToolKind.BLOCK;
                        default -> VanillaFirstPersonItemLayer.ToolKind.AXE;
                    };
                    ToolTuning.Profile p3 = ToolTuning.get(tk, this.editingLeftArm);
                    client.field_1724.method_7353(class_2561.method_30163((String)String.format("Item(%s - %s) off=(%.3f, %.3f, %.3f) rot=(%.1f, %.1f, %.1f) scale=%.2f", cat, this.editingLeftArm ? "Left" : "Right", Float.valueOf(p3.offX), Float.valueOf(p3.offY), Float.valueOf(p3.offZ), Float.valueOf(p3.rotX), Float.valueOf(p3.rotY), Float.valueOf(p3.rotZ), Float.valueOf(p3.scale))), true);
                }
            } else if (this.tuningCategoryIndex == 7) {
                ArmToolTuning.Profile p4 = ArmToolTuning.get(PlayerArmModelLayer.ToolKind.SHUBBA_DUCK, this.editingLeftArm);
                client.field_1724.method_7353(class_2561.method_30163((String)String.format("Arm(%s - %s) off=(%.3f, %.3f, %.3f) rot=(%.1f, %.1f, %.1f) scale=%.2f", cat, this.editingLeftArm ? "Left" : "Right", Float.valueOf(p4.offX), Float.valueOf(p4.offY), Float.valueOf(p4.offZ), Float.valueOf(p4.rotX), Float.valueOf(p4.rotY), Float.valueOf(p4.rotZ), Float.valueOf(p4.scale))), true);
            } else {
                PlayerArmModelLayer.ToolKind tk = switch (this.tuningCategoryIndex) {
                    case 1 -> PlayerArmModelLayer.ToolKind.SHOVEL;
                    case 2 -> PlayerArmModelLayer.ToolKind.SWORD;
                    case 3 -> PlayerArmModelLayer.ToolKind.MACE;
                    case 4 -> PlayerArmModelLayer.ToolKind.TRIDENT;
                    case 5 -> PlayerArmModelLayer.ToolKind.SHIELD;
                    case 6 -> PlayerArmModelLayer.ToolKind.BLOCK;
                    default -> PlayerArmModelLayer.ToolKind.AXE;
                };
                ArmToolTuning.Profile p5 = ArmToolTuning.get(tk, this.editingLeftArm);
                client.field_1724.method_7353(class_2561.method_30163((String)String.format("Arm(%s - %s) off=(%.3f, %.3f, %.3f) rot=(%.1f, %.1f, %.1f) scale=%.2f", cat, this.editingLeftArm ? "Left" : "Right", Float.valueOf(p5.offX), Float.valueOf(p5.offY), Float.valueOf(p5.offZ), Float.valueOf(p5.rotX), Float.valueOf(p5.rotY), Float.valueOf(p5.rotZ), Float.valueOf(p5.scale))), true);
            }
        }
        boolean attacking = client.field_1690.field_1886.method_1434();
        class_746 player = client.field_1724;
        class_1268 currentPickaxeHand = class_1268.field_5808;
        class_1799 currentPickaxe = null;
        boolean mainHandEmpty = player.method_6047().method_7960();
        for (class_1268 hand : class_1268.values()) {
            class_1799 stackInHand;
            if (hand == class_1268.field_5810 && !mainHandEmpty || (stackInHand = player.method_5998(hand)).method_7909() instanceof AnimatedShield && hand == class_1268.field_5808) continue;
            if (stackInHand.method_7909() instanceof AnimatedTool) {
                currentPickaxe = stackInHand;
                currentPickaxeHand = hand;
                break;
            }
            if (stackInHand.method_7909() instanceof class_1743 && !(stackInHand.method_7909() instanceof GeoItem)) {
                currentPickaxe = VanillaAxeProxies.forVanilla(stackInHand.method_7909());
                currentPickaxeHand = hand;
                break;
            }
            class_1792 it = stackInHand.method_7909();
            if (!(it != class_1802.field_8647 && it != class_1802.field_8387 && it != class_1802.field_8403 && it != class_1802.field_61340 && it != class_1802.field_8335 && it != class_1802.field_8377 && it != class_1802.field_22024 || it instanceof GeoItem)) {
                currentPickaxe = VanillaPickaxeProxies.forVanilla(it, hand);
                currentPickaxeHand = hand;
                break;
            }
            if (!(it != class_1802.field_8167 && it != class_1802.field_8431 && it != class_1802.field_8609 && it != class_1802.field_61342 && it != class_1802.field_8303 && it != class_1802.field_8527 && it != class_1802.field_22026 || it instanceof GeoItem)) {
                currentPickaxe = VanillaHoeProxies.forVanilla(it, hand);
                currentPickaxeHand = hand;
                break;
            }
            if (!(it != class_1802.field_8876 && it != class_1802.field_8776 && it != class_1802.field_8699 && it != class_1802.field_61339 && it != class_1802.field_8322 && it != class_1802.field_8250 && it != class_1802.field_22023 || it instanceof GeoItem)) {
                currentPickaxe = VanillaShovelProxies.forVanilla(it, hand);
                currentPickaxeHand = hand;
                break;
            }
            if (!(it != class_1802.field_8091 && it != class_1802.field_8528 && it != class_1802.field_8371 && it != class_1802.field_61338 && it != class_1802.field_8845 && it != class_1802.field_8802 && it != class_1802.field_22022 || it instanceof GeoItem)) {
                currentPickaxe = VanillaSwordProxies.forVanilla(it, hand);
                currentPickaxeHand = hand;
                break;
            }
            if (it == class_1802.field_49814 && !(it instanceof GeoItem)) {
                currentPickaxe = VanillaMaceProxies.proxy(hand);
                currentPickaxeHand = hand;
                break;
            }
            if (it == class_1802.field_8547 && !(it instanceof GeoItem)) {
                currentPickaxe = VanillaTridentProxies.proxy(hand);
                currentPickaxeHand = hand;
                break;
            }
            if (it == class_1802.field_8255 && !(it instanceof GeoItem)) {
                if (hand == class_1268.field_5808) continue;
                currentPickaxe = VanillaShieldProxies.forVanilla(hand);
                currentPickaxeHand = hand;
                break;
            }
            if (it instanceof GeoItem || hand == class_1268.field_5808 && (it == class_1802.field_8255 || stackInHand.method_7909() instanceof AnimatedShield) || hand == class_1268.field_5810 && !PunchyClient.isOffhandRestrictedItem(it)) continue;
            currentPickaxe = VanillaBlockProxies.proxy(hand);
            currentPickaxeHand = hand;
            break;
        }
        class_1799 currentGeo = null;
        class_1268 currentGeoHand = null;
        for (class_1268 hand : class_1268.values()) {
            class_2960 id;
            s = player.method_5998(hand);
            if (hand == class_1268.field_5810 && PunchyClient.isOffhandRestrictedStack((class_1799)s) || hand == class_1268.field_5808 && s != null && (s.method_7909() instanceof AnimatedShield || s.method_7909() == class_1802.field_8255) || s.method_7960() || !(s.method_7909() instanceof GeoItem) || (id = class_7923.field_41178.method_10221((Object)s.method_7909())) == null || !"punchy".equals(id.method_12836())) continue;
            currentGeo = s;
            currentGeoHand = hand;
            break;
        }
        if (this.lastAnimatedStack != null && currentPickaxe != this.lastAnimatedStack) {
            if (this.lastAnimatedStack.method_7909() instanceof GeoItem) {
                long id = GeoItem.getId((class_1799)this.lastAnimatedStack);
                ((GeoItem)this.lastAnimatedStack.method_7909()).stopTriggeredAnim((class_1297)player, id, "Activation", "activate");
                AnimatableInstanceCache cache = ((GeoItem)this.lastAnimatedStack.method_7909()).getAnimatableInstanceCache();
                AnimatableManager manager = cache.getManagerForId(id);
                if (manager != null) {
                    for (AnimationController controller : manager.getAnimationControllers().values()) {
                        if (!controller.getName().equals("Activation")) continue;
                        controller.forceAnimationReset();
                        break;
                    }
                }
            }
            if (currentPickaxe == null) {
                isMiningAnimationPlaying = false;
                miningAnimationStartTime = -1L;
            }
        }
        if (currentGeo != null) {
            int itemChanged;
            class_2960 curId = class_7923.field_41178.method_10221((Object)currentGeo.method_7909());
            int n = itemChanged = this.lastSelectItemId == null || !curId.equals((Object)this.lastSelectItemId) ? 1 : 0;
            if (itemChanged != 0) {
                long selId = GeoItem.getId(currentGeo);
                String selectTrigger = "select";
                if (currentGeoHand == class_1268.field_5810 && currentGeo.method_7909() instanceof AnimatedBlockProxy) {
                    selectTrigger = "select_left";
                }
                class_1268 selectHand = currentGeoHand == null ? class_1268.field_5808 : currentGeoHand;
                VanillaProxyContext.setHand(selectHand);
                AnimatedTool.markNextActionHand(selectHand);
                ((GeoItem)currentGeo.method_7909()).triggerAnim((class_1297)player, selId, "Select", selectTrigger);
            }
            this.lastSelectItemId = curId;
        } else {
            this.lastSelectItemId = this.lastSelectItemId;
        }
        if (currentGeo == null) {
            for (class_1268 hand : class_1268.values()) {
                long selId;
                class_1799 proxy;
                boolean itemChanged;
                class_2960 vanillaId2;
                s = player.method_5998(hand);
                if (hand == class_1268.field_5810 && PunchyClient.isOffhandRestrictedStack((class_1799)s)) continue;
                if (!s.method_7960() && s.method_7909() instanceof class_1743 && !(s.method_7909() instanceof GeoItem)) {
                    boolean itemChanged2;
                    vanillaId = class_7923.field_41178.method_10221((Object)s.method_7909());
                    boolean bl = itemChanged2 = this.lastSelectItemId == null || !vanillaId.equals((Object)this.lastSelectItemId);
                    if (itemChanged2) {
                        VanillaProxyContext.setHand(hand);
                        AnimatedTool.markNextActionHand(hand);
                        class_1799 proxy2 = VanillaAxeProxies.forVanilla(s.method_7909());
                        long selId2 = GeoItem.getId((class_1799)proxy2);
                        ((GeoItem)proxy2.method_7909()).triggerAnim((class_1297)player, selId2, "Select", "select");
                    }
                    this.lastSelectItemId = vanillaId;
                    break;
                }
                if (s.method_7960()) continue;
                class_1792 it = s.method_7909();
                boolean isPickaxe = PunchyClient.isVanillaPickaxeItem(it);
                boolean isHoe = PunchyClient.isVanillaHoeItem(it);
                boolean isShovel = PunchyClient.isVanillaShovelItem(it);
                isSword = PunchyClient.isVanillaSwordItem(it);
                boolean isMace = PunchyClient.isVanillaMaceItem(it);
                if (isPickaxe && !(it instanceof GeoItem)) {
                    vanillaId2 = class_7923.field_41178.method_10221((Object)s.method_7909());
                    boolean bl = itemChanged = this.lastSelectItemId == null || !vanillaId2.equals((Object)this.lastSelectItemId);
                    if (itemChanged) {
                        VanillaProxyContext.setHand(hand);
                        AnimatedTool.markNextActionHand(hand);
                        proxy = VanillaPickaxeProxies.forVanilla(it);
                        selId = GeoItem.getId((class_1799)proxy);
                        ((GeoItem)proxy.method_7909()).triggerAnim((class_1297)player, selId, "Select", "select");
                    }
                    this.lastSelectItemId = vanillaId2;
                    break;
                }
                if (isHoe && !(it instanceof GeoItem)) {
                    vanillaId2 = class_7923.field_41178.method_10221((Object)s.method_7909());
                    boolean bl = itemChanged = this.lastSelectItemId == null || !vanillaId2.equals((Object)this.lastSelectItemId);
                    if (itemChanged) {
                        VanillaProxyContext.setHand(hand);
                        AnimatedTool.markNextActionHand(hand);
                        proxy = VanillaHoeProxies.forVanilla(it);
                        selId = GeoItem.getId((class_1799)proxy);
                        ((GeoItem)proxy.method_7909()).triggerAnim((class_1297)player, selId, "Select", "select");
                    }
                    this.lastSelectItemId = vanillaId2;
                    break;
                }
                if (isShovel && !(it instanceof GeoItem)) {
                    vanillaId2 = class_7923.field_41178.method_10221((Object)s.method_7909());
                    boolean bl = itemChanged = this.lastSelectItemId == null || !vanillaId2.equals((Object)this.lastSelectItemId);
                    if (itemChanged) {
                        VanillaProxyContext.setHand(hand);
                        AnimatedTool.markNextActionHand(hand);
                        proxy = VanillaShovelProxies.forVanilla(it);
                        selId = GeoItem.getId((class_1799)proxy);
                        ((GeoItem)proxy.method_7909()).triggerAnim((class_1297)player, selId, "Select", "select");
                    }
                    this.lastSelectItemId = vanillaId2;
                    break;
                }
                if (isSword != 0 && !(it instanceof GeoItem)) {
                    vanillaId2 = class_7923.field_41178.method_10221((Object)s.method_7909());
                    boolean bl = itemChanged = this.lastSelectItemId == null || !vanillaId2.equals((Object)this.lastSelectItemId);
                    if (itemChanged) {
                        VanillaProxyContext.setHand(hand);
                        AnimatedTool.markNextActionHand(hand);
                        proxy = VanillaSwordProxies.forVanilla(it);
                        selId = GeoItem.getId((class_1799)proxy);
                        ((GeoItem)proxy.method_7909()).triggerAnim((class_1297)player, selId, "Select", "select");
                    }
                    this.lastSelectItemId = vanillaId2;
                    break;
                }
                if (isMace && !(it instanceof GeoItem)) {
                    vanillaId2 = class_7923.field_41178.method_10221((Object)s.method_7909());
                    boolean bl = itemChanged = this.lastSelectItemId == null || !vanillaId2.equals((Object)this.lastSelectItemId);
                    if (itemChanged) {
                        VanillaProxyContext.setHand(hand);
                        AnimatedTool.markNextActionHand(hand);
                        proxy = VanillaMaceProxies.proxy(hand);
                        selId = GeoItem.getId((class_1799)proxy);
                        ((GeoItem)proxy.method_7909()).triggerAnim((class_1297)player, selId, "Select", "select");
                    }
                    this.lastSelectItemId = vanillaId2;
                    break;
                }
                if (it instanceof GeoItem) continue;
                vanillaId2 = class_7923.field_41178.method_10221((Object)s.method_7909());
                boolean bl = itemChanged = this.lastSelectItemId == null || !vanillaId2.equals((Object)this.lastSelectItemId);
                if (itemChanged) {
                    VanillaProxyContext.setHand(hand);
                    AnimatedTool.markNextActionHand(hand);
                    proxy = VanillaBlockProxies.proxy(hand);
                    selId = GeoItem.getId((class_1799)proxy);
                    String selectTrigger = hand == class_1268.field_5810 ? "select_left" : "select";
                    ((GeoItem)proxy.method_7909()).triggerAnim((class_1297)player, selId, "Select", selectTrigger);
                }
                this.lastSelectItemId = vanillaId2;
                break;
            }
        }
        if (currentGeo == null) {
            boolean anyAxe = false;
            for (class_1268 hand : class_1268.values()) {
                class_1799 s2 = player.method_5998(hand);
                if (hand == class_1268.field_5810) {
                    if (!PunchyClient.isOffhandRestrictedStack(s2)) continue;
                    anyAxe = true;
                    break;
                }
                if (s2.method_7960()) continue;
                class_1792 it = s2.method_7909();
                if (it instanceof class_1743) {
                    anyAxe = true;
                    break;
                }
                if (!PunchyClient.isVanillaPickaxeItem(it) && !PunchyClient.isVanillaShovelItem(it) && !PunchyClient.isVanillaHoeItem(it) && !PunchyClient.isVanillaMaceItem(it) && !PunchyClient.isVanillaTridentItem(it)) continue;
                anyAxe = true;
                break;
            }
            if (!anyAxe) {
                for (class_1268 hand2 : class_1268.values()) {
                    class_1792 it2;
                    class_1799 s2 = player.method_5998(hand2);
                    if (hand2 == class_1268.field_5810) {
                        if (!PunchyClient.isOffhandRestrictedStack(s2)) continue;
                        anyAxe = true;
                        break;
                    }
                    if (s2.method_7960() || !PunchyClient.isVanillaSwordItem(it2 = s2.method_7909()) && !PunchyClient.isVanillaMaceItem(it2) && !PunchyClient.isVanillaTridentItem(it2)) continue;
                    anyAxe = true;
                    break;
                }
            }
            if (!anyAxe) {
                this.lastSelectItemId = null;
            }
        }
        if (currentGeo == null && this.lastSelectItemId == null) {
            for (class_1268 hand : class_1268.values()) {
                s = player.method_5998(hand);
                if (hand == class_1268.field_5810 && PunchyClient.isOffhandRestrictedStack((class_1799)s) || s.method_7960()) continue;
                this.lastSelectItemId = vanillaId = class_7923.field_41178.method_10221((Object)s.method_7909());
                break;
            }
        }
        this.lastAnimatedStack = currentPickaxe;
        class_1799 pickRight = PunchyClient.pickaxeGeoStackForHand((class_1657)player, class_1268.field_5808);
        class_1799 pickLeft = mainHandEmpty ? PunchyClient.pickaxeGeoStackForHand((class_1657)player, class_1268.field_5810) : null;
        boolean bl = anyPickaxe = pickRight != null || pickLeft != null;
        if (anyPickaxe) {
            class_1268[] isHoe;
            boolean targetingEntity;
            double speed = Math.max(0.25, Math.min(6.0, Punchy.ANIM_SPEED));
            int durationTicks = Math.max(1, (int)Math.ceil(40.0 / speed));
            boolean bl2 = targetingEntity = client.field_1765 != null && client.field_1765.method_17783() == class_239.class_240.field_1331;
            while (this.inspectKey != null && this.inspectKey.method_1436()) {
                isHoe = class_1268.values();
                int isShovel = isHoe.length;
                for (isSword = 0; isSword < isShovel; ++isSword) {
                    class_1268 h = isHoe[isSword];
                    class_1799 class_17992 = ps = h == class_1268.field_5810 ? pickLeft : pickRight;
                    if (ps == null || !(ps.method_7909() instanceof GeoItem)) continue;
                    long pid = GeoItem.getId((class_1799)ps);
                    VanillaProxyContext.setHand(h);
                    AnimatedTool.markNextActionHand(h);
                    ((GeoItem)ps.method_7909()).triggerAnim((class_1297)player, pid, "Inspect", "look_my_hand");
                }
            }
            if (attacking && !this.wasAttacking) {
                isHoe = class_1268.values();
                int isShovel = isHoe.length;
                for (isSword = 0; isSword < isShovel; ++isSword) {
                    class_1268 h = isHoe[isSword];
                    class_1799 class_17993 = ps = h == class_1268.field_5810 ? pickLeft : pickRight;
                    if (ps == null || !(ps.method_7909() instanceof GeoItem)) continue;
                    HandAnim st = this.handState(h);
                    class_239 selId = client.field_1765;
                    if (selId instanceof class_3965) {
                        class_3965 bhr = (class_3965)selId;
                        st.lastTargetPos = bhr.method_17777();
                    } else {
                        st.lastTargetPos = null;
                    }
                    long pid = GeoItem.getId((class_1799)ps);
                    VanillaProxyContext.setHand(h);
                    AnimatedTool.markNextActionHand(h);
                    String clip = targetingEntity ? "attack" : "activate";
                    ((GeoItem)ps.method_7909()).triggerAnim((class_1297)player, pid, "Activation", clip);
                    st.playing = true;
                    st.looping = false;
                    st.startTick = client.field_1687 != null ? client.field_1687.method_8510() : 0L;
                    st.lockUntil = st.startTick + (long)durationTicks;
                }
            }
            if (attacking) {
                isHoe = class_1268.values();
                int isShovel = isHoe.length;
                for (isSword = 0; isSword < isShovel; ++isSword) {
                    long now;
                    class_1268 h = isHoe[isSword];
                    class_1799 class_17994 = ps = h == class_1268.field_5810 ? pickLeft : pickRight;
                    if (ps == null || !(ps.method_7909() instanceof GeoItem)) continue;
                    HandAnim st = this.handState(h);
                    if (!st.playing) continue;
                    long l = now = client.field_1687 != null ? client.field_1687.method_8510() : 0L;
                    if (now < st.lockUntil) continue;
                    long pid = GeoItem.getId((class_1799)ps);
                    VanillaProxyContext.setHand(h);
                    AnimatedTool.markNextActionHand(h);
                    ((GeoItem)ps.method_7909()).triggerAnim((class_1297)player, pid, "Activation", "mine1");
                    st.looping = true;
                    st.startTick = now;
                    st.lockUntil = now + (long)durationTicks;
                }
            }
            if (!attacking && this.wasAttacking) {
                isHoe = class_1268.values();
                int isShovel = isHoe.length;
                for (isSword = 0; isSword < isShovel; ++isSword) {
                    class_1268 h = isHoe[isSword];
                    class_1799 class_17995 = ps = h == class_1268.field_5810 ? pickLeft : pickRight;
                    if (ps == null || !(ps.method_7909() instanceof GeoItem)) continue;
                    HandAnim st = this.handState(h);
                    if (!st.looping) {
                        st.playing = false;
                        continue;
                    }
                    long pid = GeoItem.getId((class_1799)ps);
                    ((GeoItem)ps.method_7909()).stopTriggeredAnim((class_1297)player, pid, "Activation", "mine1");
                    AnimatableInstanceCache cache = ((GeoItem)ps.method_7909()).getAnimatableInstanceCache();
                    AnimatableManager manager = cache.getManagerForId(pid);
                    if (manager != null) {
                        for (AnimationController controller : manager.getAnimationControllers().values()) {
                            if (!controller.getName().equals("Activation")) continue;
                            controller.forceAnimationReset();
                            break;
                        }
                    }
                    st.looping = false;
                    st.playing = false;
                    st.startTick = -1L;
                    st.lockUntil = -1L;
                    st.loopStopAtTick = -1L;
                    st.lastTargetPos = null;
                }
            }
        }
        if (currentPickaxe != null) {
            boolean targetingAir;
            class_1268 activeHand;
            class_1799 activeStack;
            class_3965 bhr;
            class_239 gid2;
            boolean targetingBlock;
            VanillaProxyContext.setHand(currentPickaxeHand);
            long id = GeoItem.getId((class_1799)currentPickaxe);
            double speed = Math.max(0.25, Math.min(6.0, PunchyClient.resolveAnimSpeed(currentPickaxe)));
            int durationTicks = Math.max(1, (int)Math.ceil(40.0 / speed));
            boolean targetingEntity = client.field_1765 != null && client.field_1765.method_17783() == class_239.class_240.field_1331;
            boolean bl3 = targetingBlock = client.field_1765 != null && client.field_1765.method_17783() == class_239.class_240.field_1332;
            while (this.inspectKey != null && this.inspectKey.method_1436()) {
                class_1792 isShovel;
                if (currentGeo != null && (isShovel = currentGeo.method_7909()) instanceof GeoItem) {
                    GeoItem gi = (GeoItem)isShovel;
                    long gid2 = GeoItem.getId((class_1799)currentGeo);
                    class_1268 geoHand = currentGeoHand == null ? class_1268.field_5808 : currentGeoHand;
                    VanillaProxyContext.setHand(geoHand);
                    AnimatedTool.markNextActionHand(geoHand);
                    gi.triggerAnim((class_1297)player, gid2, "Inspect", "look_my_hand");
                } else if (currentPickaxe != null && currentPickaxe.method_7909() instanceof GeoItem) {
                    VanillaProxyContext.setHand(currentPickaxeHand);
                    AnimatedTool.markNextActionHand(currentPickaxeHand);
                    ((GeoItem)currentPickaxe.method_7909()).triggerAnim((class_1297)player, id, "Inspect", "look_my_hand");
                }
                for (GeoItem h : class_1268.values()) {
                    ps = PunchyClient.pickaxeGeoStackForHand((class_1657)player, (class_1268)h);
                    if (ps == null || !(ps.method_7909() instanceof GeoItem)) continue;
                    long pid = GeoItem.getId((class_1799)ps);
                    VanillaProxyContext.setHand((class_1268)h);
                    AnimatedTool.markNextActionHand((class_1268)h);
                    ((GeoItem)ps.method_7909()).triggerAnim((class_1297)player, pid, "Inspect", "look_my_hand");
                }
            }
            if (client.field_1690.field_1904.method_1434() && currentPickaxe.method_7909() instanceof AnimatedAxe && currentPickaxeHand == class_1268.field_5808 && (gid2 = client.field_1765) instanceof class_3965) {
                bhr = (class_3965)gid2;
                if (client.field_1687 != null && AxeStripHelper.canStrip(client.field_1687.method_8320(bhr.method_17777())) && !isMiningAnimationPlaying && client.field_1687.method_8510() >= this.clickLockUntilTick) {
                    lastMiningTargetPos = bhr.method_17777();
                    AnimatedTool.markNextImpactAsAxeStrip();
                    VanillaProxyContext.setHand(currentPickaxeHand);
                    AnimatedTool.markNextActionHand(currentPickaxeHand);
                    ((GeoItem)currentPickaxe.method_7909()).triggerAnim((class_1297)player, id, "Activation", "activate");
                    miningAnimationStartTime = client.field_1687.method_8510();
                    isMiningAnimationPlaying = true;
                    this.clickLockUntilTick = miningAnimationStartTime + (long)durationTicks;
                    this.isLooping = false;
                }
            }
            if (client.field_1690.field_1904.method_1434() && currentPickaxe.method_7909() instanceof AnimatedHoe && !isMiningAnimationPlaying && client.field_1687.method_8510() >= this.clickLockUntilTick) {
                class_239 gid2 = client.field_1765;
                if (gid2 instanceof class_3965) {
                    bhr = (class_3965)gid2;
                    lastMiningTargetPos = bhr.method_17777();
                }
                AnimatedTool.markNextImpactAsHoeUse();
                VanillaProxyContext.setHand(currentPickaxeHand);
                AnimatedTool.markNextActionHand(currentPickaxeHand);
                ((GeoItem)currentPickaxe.method_7909()).triggerAnim((class_1297)player, id, "Activation", "activate");
                miningAnimationStartTime = client.field_1687.method_8510();
                isMiningAnimationPlaying = true;
                this.clickLockUntilTick = miningAnimationStartTime + (long)durationTicks;
                this.isLooping = false;
            }
            if (client.field_1690.field_1904.method_1434() && currentPickaxe.method_7909() instanceof AnimatedShovel && !isMiningAnimationPlaying && client.field_1687.method_8510() >= this.clickLockUntilTick) {
                class_239 gid2 = client.field_1765;
                if (gid2 instanceof class_3965) {
                    bhr = (class_3965)gid2;
                    lastMiningTargetPos = bhr.method_17777();
                }
                AnimatedTool.markNextImpactAsShovelUse();
                VanillaProxyContext.setHand(currentPickaxeHand);
                AnimatedTool.markNextActionHand(currentPickaxeHand);
                ((GeoItem)currentPickaxe.method_7909()).triggerAnim((class_1297)player, id, "Activation", "activate");
                miningAnimationStartTime = client.field_1687.method_8510();
                isMiningAnimationPlaying = true;
                this.clickLockUntilTick = miningAnimationStartTime + (long)durationTicks;
                this.isLooping = false;
            }
            boolean eatingWasPlaying = this.wasEating;
            boolean drinkingWasPlaying = this.wasDrinking;
            boolean eating = false;
            boolean drinking = false;
            if (player.method_6115()) {
                class_1268 activeHand2 = player.method_6058();
                class_1799 activeStack2 = player.method_6030();
                if (activeStack2 != null && !activeStack2.method_7960()) {
                    boolean isDrink;
                    boolean isFood = activeStack2.method_57353().method_57832(class_9334.field_50075);
                    class_1839 useAction = activeStack2.method_7909().method_7853(activeStack2);
                    boolean bl4 = isDrink = useAction == class_1839.field_8946;
                    if (isFood || isDrink) {
                        Object object;
                        class_1799 animStack = null;
                        class_1268 animHand = activeHand2;
                        if (activeStack2.method_7909() instanceof AnimatedBlockProxy) {
                            animStack = activeStack2;
                        } else if (currentPickaxe != null && currentPickaxe.method_7909() instanceof AnimatedBlockProxy && currentPickaxeHand == activeHand2) {
                            animStack = currentPickaxe;
                        } else if (currentGeo != null && currentGeo.method_7909() instanceof AnimatedBlockProxy && currentGeoHand == activeHand2) {
                            animStack = currentGeo;
                        }
                        if (animStack != null && (object = animStack.method_7909()) instanceof GeoItem) {
                            GeoItem geoBlock = (GeoItem)object;
                            long gid3 = GeoItem.getId((class_1799)animStack);
                            if (isFood) {
                                eating = true;
                                if (!this.wasEating || animHand != this.lastEatingHand) {
                                    VanillaProxyContext.setHand(animHand);
                                    AnimatedTool.markNextActionHand(animHand);
                                    geoBlock.triggerAnim((class_1297)player, gid3, "Consume", "eat");
                                }
                                this.lastEatingHand = animHand;
                                this.lastEatingGeo = geoBlock;
                                this.lastEatingAnimId = gid3;
                            }
                            if (isDrink) {
                                drinking = true;
                                if (!this.wasDrinking || animHand != this.lastDrinkingHand) {
                                    VanillaProxyContext.setHand(animHand);
                                    AnimatedTool.markNextActionHand(animHand);
                                    geoBlock.triggerAnim((class_1297)player, gid3, "Consume", "drink");
                                }
                                this.lastDrinkingHand = animHand;
                                this.lastDrinkingGeo = geoBlock;
                                this.lastDrinkingAnimId = gid3;
                            }
                        }
                    }
                }
            }
            if (!eating && eatingWasPlaying) {
                this.stopConsumeAnimation((class_1657)player, this.lastEatingGeo, this.lastEatingAnimId, "eat");
                this.lastEatingGeo = null;
                this.lastEatingAnimId = -1L;
            }
            if (!drinking && drinkingWasPlaying) {
                this.stopConsumeAnimation((class_1657)player, this.lastDrinkingGeo, this.lastDrinkingAnimId, "drink");
                this.lastDrinkingGeo = null;
                this.lastDrinkingAnimId = -1L;
            }
            this.wasEating = eating;
            this.wasDrinking = drinking;
            boolean shieldUsing = false;
            boolean shieldIsProxy = false;
            class_1268 shieldHand = class_1268.field_5808;
            class_1799 shieldAnimStack = null;
            if (player.method_6115()) {
                class_1268 activeHand3 = player.method_6058();
                activeStack = player.method_6030();
                if (activeStack != null && !activeStack.method_7960()) {
                    class_1792 activeItem = activeStack.method_7909();
                    if (activeItem instanceof AnimatedShield) {
                        shieldUsing = true;
                        shieldHand = activeHand3;
                        shieldAnimStack = activeStack;
                        shieldIsProxy = false;
                    } else if (activeItem == class_1802.field_8255) {
                        shieldUsing = true;
                        shieldHand = activeHand3;
                        shieldAnimStack = VanillaShieldProxies.forHand(activeHand3);
                        shieldIsProxy = true;
                    }
                }
            }
            if (shieldUsing && shieldHand == class_1268.field_5808) {
                player.method_6075();
                shieldUsing = false;
                shieldAnimStack = null;
            }
            if (shieldUsing && shieldAnimStack != null && (activeStack = shieldAnimStack.method_7909()) instanceof GeoItem) {
                GeoItem geoShield = (GeoItem)activeStack;
                if (!this.wasShieldBlocking) {
                    VanillaProxyContext.setHand(shieldHand);
                    AnimatedTool.markNextActionHand(shieldHand);
                    if (shieldIsProxy) {
                        long sid = GeoItem.getId((class_1799)shieldAnimStack);
                        String trigger = AnimatedShield.activationTriggerForHand(shieldHand);
                        geoShield.triggerAnim((class_1297)player, sid, "Activation", trigger);
                    }
                    AnimatedShield.beginBlocking((class_1657)player, shieldHand, shieldAnimStack);
                    this.lastShieldBlockingHand = shieldHand;
                } else {
                    AnimatedShield.tickBlocking((class_1657)player, shieldHand);
                }
                this.wasShieldBlocking = true;
            } else if (!shieldUsing && this.wasShieldBlocking) {
                AnimatedShield.endBlocking((class_1657)player, this.lastShieldBlockingHand);
                this.wasShieldBlocking = false;
            }
            boolean tridentCharging = false;
            if (player.method_6115() && currentPickaxe != null && currentPickaxe.method_7909() instanceof AnimatedTrident && (activeHand = player.method_6058()) == currentPickaxeHand) {
                tridentCharging = true;
                if (!this.wasTridentCharging) {
                    AnimatedTrident.beginCharging((class_1657)player, activeHand, currentPickaxe);
                    this.lastTridentChargingHand = activeHand;
                } else {
                    AnimatedTrident.tickCharging((class_1657)player, activeHand, currentPickaxe);
                }
            }
            if (!tridentCharging && this.wasTridentCharging) {
                AnimatedTrident.releaseThrow((class_1657)player, this.lastTridentChargingHand);
            }
            this.wasTridentCharging = tridentCharging;
            boolean bl5 = targetingAir = client.field_1765 == null || client.field_1765.method_17783() == class_239.class_240.field_1333;
            if (attacking && !this.wasAttacking) {
                long worldTick;
                class_1799 ohStack;
                boolean isTrident = currentPickaxe != null && currentPickaxe.method_7909() instanceof AnimatedTrident;
                boolean isSword2 = currentPickaxe != null && currentPickaxe.method_7909() instanceof AnimatedSword;
                boolean suppressBlocks = false;
                try {
                    long now;
                    long l = now = client.field_1687 != null ? client.field_1687.method_8510() : -1L;
                    if (BlockActionGuards.isPlaceGuardActive(now)) {
                        class_1799 mhStack = player.method_6047();
                        boolean mhIsBlock = mhStack != null && !mhStack.method_7960() && mhStack.method_7909() instanceof class_1747 && !(mhStack.method_7909() instanceof GeoItem);
                        ohStack = player.method_6079();
                        boolean ohIsBlock = ohStack != null && !ohStack.method_7960() && ohStack.method_7909() instanceof class_1747 && !(ohStack.method_7909() instanceof GeoItem);
                        boolean isBlockProxy = currentPickaxe != null && currentPickaxe.method_7909() instanceof AnimatedBlockProxy;
                        suppressBlocks = mhIsBlock || ohIsBlock || isBlockProxy;
                    }
                }
                catch (Throwable now) {
                    // empty catch block
                }
                long l = worldTick = client.field_1687 != null ? client.field_1687.method_8510() : 0L;
                if (!isMiningAnimationPlaying && worldTick >= this.clickLockUntilTick) {
                    if (isSword2 && currentPickaxe != null && !suppressBlocks) {
                        class_239 mhIsBlock = client.field_1765;
                        if (mhIsBlock instanceof class_3965) {
                            class_3965 bhr2 = (class_3965)mhIsBlock;
                            lastMiningTargetPos = bhr2.method_17777();
                        } else {
                            lastMiningTargetPos = null;
                        }
                        VanillaProxyContext.setHand(currentPickaxeHand);
                        AnimatedTool.markNextActionHand(currentPickaxeHand);
                        ((GeoItem)currentPickaxe.method_7909()).triggerAnim((class_1297)player, id, "Activation", "attack");
                        this.resetAttackCooldown((class_1657)player);
                        isMiningAnimationPlaying = true;
                        miningAnimationStartTime = worldTick;
                        this.clickLockUntilTick = miningAnimationStartTime + (long)durationTicks;
                        this.isLooping = false;
                        this.loopContext = LoopContext.SWORD_SINGLE;
                        this.stopLoopAtBoundary = false;
                        this.loopStopAtTick = -1L;
                    } else if (!suppressBlocks && currentPickaxe != null) {
                        if (targetingEntity) {
                            VanillaProxyContext.setHand(currentPickaxeHand);
                            AnimatedTool.markNextActionHand(currentPickaxeHand);
                            clip = currentPickaxe.method_7909() instanceof AnimatedBlockProxy ? "activate" : "attack";
                            ((GeoItem)currentPickaxe.method_7909()).triggerAnim((class_1297)player, id, "Activation", clip);
                            this.resetAttackCooldown((class_1657)player);
                            isMiningAnimationPlaying = false;
                            miningAnimationStartTime = -1L;
                            this.clickLockUntilTick = -1L;
                            this.isLooping = false;
                            this.loopContext = LoopContext.NONE;
                            lastMiningTargetPos = null;
                        } else if (targetingBlock && currentPickaxe != null) {
                            class_1799 mh = player.method_6047();
                            if (mh != null && !mh.method_7960() && mh.method_7909() instanceof class_1747 && !(mh.method_7909() instanceof GeoItem)) {
                                ohStack = client.field_1765;
                                if (ohStack instanceof class_3965) {
                                    class_3965 bhr3 = (class_3965)ohStack;
                                    lastMiningTargetPos = bhr3.method_17777();
                                }
                                class_1799 proxy = VanillaBlockProxies.proxy(class_1268.field_5808);
                                long rid = GeoItem.getId((class_1799)proxy);
                                VanillaProxyContext.setHand(class_1268.field_5808);
                                AnimatedTool.markNextActionHand(class_1268.field_5808);
                                ((GeoItem)proxy.method_7909()).triggerAnim((class_1297)player, rid, "Activation", "activate");
                                this.resetAttackCooldown((class_1657)player);
                                isMiningAnimationPlaying = true;
                                miningAnimationStartTime = client.field_1687.method_8510();
                                this.clickLockUntilTick = miningAnimationStartTime + (long)durationTicks;
                                this.isLooping = false;
                                this.loopContext = LoopContext.BLOCK;
                                this.stopLoopAtBoundary = false;
                                this.loopStopAtTick = -1L;
                            } else if (currentPickaxe.method_7909() instanceof AnimatedBlockProxy) {
                                var35_148 = client.field_1765;
                                if (var35_148 instanceof class_3965) {
                                    class_3965 bhr4 = (class_3965)var35_148;
                                    lastMiningTargetPos = bhr4.method_17777();
                                }
                                VanillaProxyContext.setHand(currentPickaxeHand);
                                AnimatedTool.markNextActionHand(currentPickaxeHand);
                                ((GeoItem)currentPickaxe.method_7909()).triggerAnim((class_1297)player, id, "Activation", "activate");
                                this.resetAttackCooldown((class_1657)player);
                                isMiningAnimationPlaying = true;
                                miningAnimationStartTime = client.field_1687.method_8510();
                                this.clickLockUntilTick = miningAnimationStartTime + (long)durationTicks;
                                this.isLooping = false;
                                this.loopContext = LoopContext.BLOCK;
                                this.stopLoopAtBoundary = false;
                                this.loopStopAtTick = -1L;
                            } else if (currentPickaxe.method_7909() instanceof AnimatedTool) {
                                var35_148 = client.field_1765;
                                if (var35_148 instanceof class_3965) {
                                    class_3965 bhr5 = (class_3965)var35_148;
                                    lastMiningTargetPos = bhr5.method_17777();
                                }
                                VanillaProxyContext.setHand(currentPickaxeHand);
                                AnimatedTool.markNextActionHand(currentPickaxeHand);
                                ((GeoItem)currentPickaxe.method_7909()).triggerAnim((class_1297)player, id, "Activation", "activate");
                                this.resetAttackCooldown((class_1657)player);
                                isMiningAnimationPlaying = true;
                                miningAnimationStartTime = client.field_1687.method_8510();
                                this.clickLockUntilTick = miningAnimationStartTime + (long)durationTicks;
                                this.isLooping = false;
                                this.loopContext = LoopContext.BLOCK;
                                this.stopLoopAtBoundary = false;
                                this.loopStopAtTick = -1L;
                            }
                        } else if (targetingAir && currentPickaxe != null && currentPickaxe.method_7909() instanceof AnimatedTool) {
                            VanillaProxyContext.setHand(currentPickaxeHand);
                            AnimatedTool.markNextActionHand(currentPickaxeHand);
                            clip = currentPickaxe.method_7909() instanceof AnimatedBlockProxy ? "attack" : "activate";
                            ((GeoItem)currentPickaxe.method_7909()).triggerAnim((class_1297)player, id, "Activation", clip);
                            this.resetAttackCooldown((class_1657)player);
                            isMiningAnimationPlaying = true;
                            miningAnimationStartTime = client.field_1687.method_8510();
                            this.clickLockUntilTick = -1L;
                            this.isLooping = false;
                            this.loopContext = LoopContext.AIR_TOOL;
                            this.stopLoopAtBoundary = false;
                            this.loopStopAtTick = -1L;
                            lastMiningTargetPos = null;
                        }
                    }
                }
            } else if (attacking && this.wasAttacking) {
                if (isMiningAnimationPlaying) {
                    boolean isSword3;
                    long elapsed = client.field_1687.method_8510() - miningAnimationStartTime;
                    LoopContext ctx = this.loopContext;
                    boolean isTool = currentPickaxe != null && currentPickaxe.method_7909() instanceof AnimatedTool;
                    boolean bl6 = isSword3 = isTool && currentPickaxe.method_7909() instanceof AnimatedSword;
                    if (ctx == LoopContext.BLOCK && isTool && !isSword3) {
                        if (!this.isLooping && elapsed >= (long)durationTicks) {
                            VanillaProxyContext.setHand(currentPickaxeHand);
                            AnimatedTool.markNextActionHand(currentPickaxeHand);
                            String loopClip = "mine1";
                            if (((AnimatedTool)currentPickaxe.method_7909()).hasMultiMiningVariants() && client.field_1687.field_9229.method_43057() < 0.1f) {
                                loopClip = client.field_1687.field_9229.method_43056() ? "mine2" : "mine3";
                            }
                            ((GeoItem)currentPickaxe.method_7909()).triggerAnim((class_1297)player, id, "Activation", loopClip);
                            this.isLooping = true;
                            miningAnimationStartTime = client.field_1687.method_8510();
                            this.clickLockUntilTick = -1L;
                            this.stopLoopAtBoundary = false;
                            this.loopStopAtTick = -1L;
                        } else if (this.isLooping && elapsed >= (long)(durationTicks - 1)) {
                            VanillaProxyContext.setHand(currentPickaxeHand);
                            AnimatedTool.markNextActionHand(currentPickaxeHand);
                            String loopClip = "mine1";
                            if (((AnimatedTool)currentPickaxe.method_7909()).hasMultiMiningVariants() && client.field_1687.field_9229.method_43057() < 0.1f) {
                                loopClip = client.field_1687.field_9229.method_43056() ? "mine2" : "mine3";
                            }
                            ((GeoItem)currentPickaxe.method_7909()).triggerAnim((class_1297)player, id, "Activation", loopClip);
                            miningAnimationStartTime = client.field_1687.method_8510();
                        }
                    } else {
                        boolean wantsLoop;
                        boolean bl7 = wantsLoop = ctx == LoopContext.BLOCK || ctx == LoopContext.AIR_TOOL || ctx == LoopContext.AIR_SWORD;
                        if (wantsLoop) {
                            if (!this.isLooping && elapsed >= (long)durationTicks) {
                                if (this.triggerLoopCycle(client, currentPickaxe, (class_1657)player, id, ctx, currentPickaxeHand)) {
                                    this.isLooping = true;
                                    miningAnimationStartTime = client.field_1687.method_8510();
                                    this.clickLockUntilTick = -1L;
                                    this.stopLoopAtBoundary = false;
                                    this.loopStopAtTick = -1L;
                                }
                            } else if (this.isLooping && elapsed >= (long)(durationTicks - 1) && this.triggerLoopCycle(client, currentPickaxe, (class_1657)player, id, ctx, currentPickaxeHand)) {
                                miningAnimationStartTime = client.field_1687.method_8510();
                            }
                        } else if (ctx == LoopContext.NONE && targetingBlock && elapsed >= (long)durationTicks && this.triggerLoopCycle(client, currentPickaxe, (class_1657)player, id, LoopContext.BLOCK, currentPickaxeHand)) {
                            this.isLooping = true;
                            miningAnimationStartTime = client.field_1687.method_8510();
                            this.clickLockUntilTick = -1L;
                            this.stopLoopAtBoundary = false;
                            this.loopStopAtTick = -1L;
                            this.loopContext = LoopContext.BLOCK;
                        }
                    }
                }
            } else if (!attacking && this.wasAttacking && this.isLooping) {
                ((GeoItem)currentPickaxe.method_7909()).stopTriggeredAnim((class_1297)player, id, "Activation", "mine1");
                AnimatableInstanceCache cache = ((GeoItem)currentPickaxe.method_7909()).getAnimatableInstanceCache();
                AnimatableManager manager = cache.getManagerForId(id);
                if (manager != null) {
                    for (AnimationController controller : manager.getAnimationControllers().values()) {
                        if (!controller.getName().equals("Activation")) continue;
                        controller.forceAnimationReset();
                        break;
                    }
                }
                this.isLooping = false;
                isMiningAnimationPlaying = false;
                this.stopLoopAtBoundary = false;
                this.loopStopAtTick = -1L;
                this.clickLockUntilTick = -1L;
                lastMiningTargetPos = null;
                this.loopContext = LoopContext.NONE;
                this.resetAttackCooldown((class_1657)player);
            }
        } else if (isMiningAnimationPlaying) {
            isMiningAnimationPlaying = false;
            miningAnimationStartTime = -1L;
            this.loopContext = LoopContext.NONE;
            this.resetAttackCooldown((class_1657)player);
        }
        if (isMiningAnimationPlaying && !this.isLooping) {
            double speed = Math.max(0.25, Math.min(6.0, PunchyClient.resolveAnimSpeed(this.loopContext)));
            int durationTicks = Math.max(1, (int)Math.ceil(40.0 / speed));
            if (client.field_1687.method_8510() - miningAnimationStartTime >= (long)durationTicks) {
                isMiningAnimationPlaying = false;
                this.clickLockUntilTick = -1L;
                lastMiningTargetPos = null;
                this.loopContext = LoopContext.NONE;
                this.resetAttackCooldown((class_1657)player);
            }
        }
        if (this.stopLoopAtBoundary && client.field_1724 != null && client.field_1687 != null && client.field_1687.method_8510() >= this.loopStopAtTick) {
            class_1799 stackInHand = client.field_1724.method_6047();
            if (stackInHand.method_7909() instanceof AnimatedTool) {
                long id = GeoItem.getId((class_1799)stackInHand);
                ((GeoItem)stackInHand.method_7909()).stopTriggeredAnim((class_1297)client.field_1724, id, "Activation", "mine1");
                AnimatableInstanceCache cache = ((GeoItem)stackInHand.method_7909()).getAnimatableInstanceCache();
                AnimatableManager manager = cache.getManagerForId(id);
                if (manager != null) {
                    for (AnimationController controller : manager.getAnimationControllers().values()) {
                        if (!controller.getName().equals("Activation")) continue;
                        controller.forceAnimationReset();
                        break;
                    }
                }
            }
            this.isLooping = false;
            isMiningAnimationPlaying = false;
            this.stopLoopAtBoundary = false;
            this.loopStopAtTick = -1L;
            this.clickLockUntilTick = -1L;
        }
        this.wasAttacking = attacking;
    }

    private void stopConsumeAnimation(class_1657 player, GeoItem geo, long animId, String key) {
        if (player == null || geo == null || animId < 0L) {
            return;
        }
        try {
            geo.stopTriggeredAnim((class_1297)player, animId, "Consume", key);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void resetAttackCooldown(class_1657 player) {
        if (player == null) {
            return;
        }
        player.method_7350();
    }

    public static void releaseImpactLock() {
        PunchyClient inst = INSTANCE;
        if (inst == null) {
            return;
        }
        isMiningAnimationPlaying = false;
        inst.clickLockUntilTick = -1L;
    }

    private boolean triggerLoopCycle(class_310 client, class_1799 stack, class_1657 player, long geoId, LoopContext ctx, class_1268 hand) {
        if (client == null || stack == null || player == null) {
            return false;
        }
        class_1792 class_17922 = stack.method_7909();
        if (!(class_17922 instanceof GeoItem)) {
            return false;
        }
        GeoItem geo = (GeoItem)class_17922;
        switch (ctx.ordinal()) {
            case 1: 
            case 2: {
                if (!(stack.method_7909() instanceof AnimatedTool)) {
                    return false;
                }
                class_1268 actionHand = hand;
                if (actionHand == null) {
                    actionHand = stack == player.method_6079() ? class_1268.field_5810 : class_1268.field_5808;
                }
                VanillaProxyContext.setHand(actionHand);
                AnimatedTool.markNextActionHand(actionHand);
                geo.triggerAnim((class_1297)player, geoId, "Activation", "mine1");
                this.resetAttackCooldown(player);
                return true;
            }
            case 3: {
                class_1268 actionHand = hand;
                if (actionHand == null) {
                    actionHand = stack == player.method_6079() ? class_1268.field_5810 : class_1268.field_5808;
                }
                VanillaProxyContext.setHand(actionHand);
                AnimatedTool.markNextActionHand(actionHand);
                geo.triggerAnim((class_1297)player, geoId, "Activation", "mine1");
                this.resetAttackCooldown(player);
                return true;
            }
        }
        return false;
    }

    static {
        isMiningAnimationPlaying = false;
        miningAnimationStartTime = -1L;
        lastMiningTargetPos = null;
    }

    private static enum LoopContext {
        NONE,
        BLOCK,
        AIR_TOOL,
        AIR_SWORD,
        SWORD_SINGLE;

    }

    private static final class HandAnim {
        boolean playing = false;
        boolean looping = false;
        long startTick = -1L;
        long lockUntil = -1L;
        long loopStopAtTick = -1L;
        class_2338 lastTargetPos = null;

        private HandAnim() {
        }
    }
}

