/*
 * Decompiled with CFR 0.152.
 */
package com.henrique.punchy.client.renderer.layer;

import com.henrique.punchy.client.renderer.layer.PlayerArmModelLayer;

public final class ArmToolTuning {
    private static Profile AXE_R;
    private static Profile AXE_L;
    private static Profile PICKAXE_R;
    private static Profile PICKAXE_L;
    private static Profile HOE_R;
    private static Profile HOE_L;
    private static Profile SWORD_R;
    private static Profile SWORD_L;
    private static Profile SHOVEL_R;
    private static Profile SHOVEL_L;
    private static Profile SHIELD_R;
    private static Profile SHIELD_L;
    private static Profile BLOCK_R;
    private static Profile BLOCK_L;
    private static Profile SHUBBA_R;
    private static Profile SHUBBA_L;
    private static Profile MACE_R;
    private static Profile MACE_L;
    private static Profile TRIDENT_R;
    private static Profile TRIDENT_L;

    private ArmToolTuning() {
    }

    public static void resetDefaults() {
        AXE_R = new Profile(1.15f, -0.72f, 0.6f, 0.06f, -5.5f, 169.0f, 98.0f);
        AXE_L = new Profile(1.15f, -0.72f, 0.6f, 0.06f, -5.5f, 169.0f, 97.0f);
        PICKAXE_R = new Profile(1.15f, -0.72f, 0.6f, 0.06f, -5.5f, 169.0f, 98.0f);
        PICKAXE_L = new Profile(1.15f, -0.72f, 0.6f, 0.06f, -5.5f, 169.0f, 97.0f);
        SHOVEL_R = new Profile(1.15f, -0.72f, 0.6f, 0.06f, -5.5f, 169.0f, 98.0f);
        SHOVEL_L = new Profile(1.15f, -0.72f, 0.6f, 0.06f, -5.5f, 169.0f, 97.0f);
        HOE_R = new Profile(1.15f, -0.72f, 0.6f, 0.06f, -5.5f, 169.0f, 98.0f);
        HOE_L = new Profile(1.15f, -0.72f, 0.6f, 0.06f, -5.5f, 169.0f, 97.0f);
        SWORD_R = new Profile(1.15f, -0.72f, 0.58f, 0.06f, -5.5f, 169.0f, 97.0f);
        SWORD_L = new Profile(1.15f, -0.72f, 0.58f, 0.06f, -5.5f, 169.0f, 97.0f);
        SHIELD_R = new Profile(1.8f, 1.32f, -0.28f, -0.44f, -162.5f, 284.0f, -95.0f);
        SHIELD_L = new Profile(1.35f, 0.28f, 0.04f, -0.06f, -6.5f, 271.0f, 76.0f);
        BLOCK_R = new Profile(1.15f, -0.72f, 0.6f, 0.06f, -7.5f, 173.0f, 99.0f);
        BLOCK_L = new Profile(1.15f, -0.72f, 0.6f, 0.06f, -5.5f, 177.0f, 99.0f);
        SHUBBA_R = new Profile(1.15f, 0.29999983f, 0.14000002f, 0.03999997f, -6.5f, 275.0f, 75.0f);
        SHUBBA_L = new Profile(1.15f, 0.29999983f, 0.14000002f, 0.04000003f, -5.5f, 275.0f, 75.0f);
        MACE_R = new Profile(1.15f, -0.72f, 0.6f, 0.06f, -5.5f, 169.0f, 98.0f);
        MACE_L = new Profile(1.15f, -0.72f, 0.6f, 0.06f, -5.5f, 169.0f, 97.0f);
        TRIDENT_R = new Profile(1.25f, -0.66f, 0.32f, -0.3f, -62.5f, 179.0f, 113.0f);
        TRIDENT_L = new Profile(1.25f, -0.66f, 0.32f, -0.3f, -62.5f, 179.0f, 113.0f);
    }

    public static Profile get(PlayerArmModelLayer.ToolKind kind, boolean left) {
        return switch (kind) {
            default -> throw new MatchException(null, null);
            case PlayerArmModelLayer.ToolKind.AXE -> {
                if (left) {
                    yield AXE_L;
                }
                yield AXE_R;
            }
            case PlayerArmModelLayer.ToolKind.PICKAXE -> {
                if (left) {
                    yield PICKAXE_L;
                }
                yield PICKAXE_R;
            }
            case PlayerArmModelLayer.ToolKind.HOE -> {
                if (left) {
                    yield HOE_L;
                }
                yield HOE_R;
            }
            case PlayerArmModelLayer.ToolKind.SWORD -> {
                if (left) {
                    yield SWORD_L;
                }
                yield SWORD_R;
            }
            case PlayerArmModelLayer.ToolKind.SHOVEL -> {
                if (left) {
                    yield SHOVEL_L;
                }
                yield SHOVEL_R;
            }
            case PlayerArmModelLayer.ToolKind.SHIELD -> {
                if (left) {
                    yield SHIELD_L;
                }
                yield SHIELD_R;
            }
            case PlayerArmModelLayer.ToolKind.BLOCK -> {
                if (left) {
                    yield BLOCK_L;
                }
                yield BLOCK_R;
            }
            case PlayerArmModelLayer.ToolKind.SHUBBA_DUCK -> {
                if (left) {
                    yield SHUBBA_L;
                }
                yield SHUBBA_R;
            }
            case PlayerArmModelLayer.ToolKind.MACE -> {
                if (left) {
                    yield MACE_L;
                }
                yield MACE_R;
            }
            case PlayerArmModelLayer.ToolKind.TRIDENT -> left ? TRIDENT_L : TRIDENT_R;
        };
    }

    public static void apply(PlayerArmModelLayer.ToolKind kind, boolean left, Profile p) {
        if (p == null) {
            return;
        }
        Profile dst = ArmToolTuning.get(kind, left);
        dst.scale = p.scale;
        dst.offX = p.offX;
        dst.offY = p.offY;
        dst.offZ = p.offZ;
        dst.rotX = p.rotX;
        dst.rotY = p.rotY;
        dst.rotZ = p.rotZ;
    }

    public static Profile snapshot(PlayerArmModelLayer.ToolKind kind, boolean left) {
        Profile s = ArmToolTuning.get(kind, left);
        return new Profile(s.scale, s.offX, s.offY, s.offZ, s.rotX, s.rotY, s.rotZ);
    }

    public static final class Profile {
        public float scale;
        public float offX;
        public float offY;
        public float offZ;
        public float rotX;
        public float rotY;
        public float rotZ;

        public Profile(float scale, float offX, float offY, float offZ, float rotX, float rotY, float rotZ) {
            this.scale = scale;
            this.offX = offX;
            this.offY = offY;
            this.offZ = offZ;
            this.rotX = rotX;
            this.rotY = rotY;
            this.rotZ = rotZ;
        }
    }
}

