/*
 * Decompiled with CFR 0.152.
 */
package com.henrique.punchy.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import net.fabricmc.loader.api.FabricLoader;

public final class PunchyConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String FILE_NAME = "punchy.json";
    private SpeedPreset speedPreset = SpeedPreset.PUNCHYA;
    private SwordSpeed swordSpeed = SwordSpeed.X2;
    private MaceSpeed maceSpeed = MaceSpeed.X2;
    private TridentSpeed tridentSpeed = TridentSpeed.X4;
    private TridentThrowSpeed tridentThrowSpeed = TridentThrowSpeed.X1;
    private BlockPlaceSpeed blockPlaceSpeed = BlockPlaceSpeed.X7_0;
    private boolean removeAttackCooldown = true;
    private boolean hideAttackIndicator = true;
    private boolean useImpactTiming = true;
    private boolean debugPosition = false;

    public SpeedPreset getSpeedPreset() {
        return this.speedPreset;
    }

    public void setSpeedPreset(SpeedPreset preset) {
        this.speedPreset = preset;
    }

    public SwordSpeed getSwordSpeed() {
        return this.swordSpeed;
    }

    public void setSwordSpeed(SwordSpeed swordSpeed) {
        this.swordSpeed = swordSpeed;
    }

    public MaceSpeed getMaceSpeed() {
        return this.maceSpeed;
    }

    public void setMaceSpeed(MaceSpeed maceSpeed) {
        this.maceSpeed = maceSpeed;
    }

    public TridentSpeed getTridentSpeed() {
        return this.tridentSpeed;
    }

    public void setTridentSpeed(TridentSpeed tridentSpeed) {
        this.tridentSpeed = tridentSpeed;
    }

    public TridentThrowSpeed getTridentThrowSpeed() {
        return this.tridentThrowSpeed;
    }

    public void setTridentThrowSpeed(TridentThrowSpeed tridentThrowSpeed) {
        this.tridentThrowSpeed = tridentThrowSpeed;
    }

    public BlockPlaceSpeed getBlockPlaceSpeed() {
        return this.blockPlaceSpeed;
    }

    public void setBlockPlaceSpeed(BlockPlaceSpeed blockPlaceSpeed) {
        this.blockPlaceSpeed = blockPlaceSpeed;
    }

    public boolean isRemoveAttackCooldown() {
        return this.removeAttackCooldown;
    }

    public void setRemoveAttackCooldown(boolean removeAttackCooldown) {
        this.removeAttackCooldown = removeAttackCooldown;
    }

    public boolean isHideAttackIndicator() {
        return this.hideAttackIndicator;
    }

    public void setHideAttackIndicator(boolean hideAttackIndicator) {
        this.hideAttackIndicator = hideAttackIndicator;
    }

    public boolean isUseImpactTiming() {
        return this.useImpactTiming;
    }

    public void setUseImpactTiming(boolean useImpactTiming) {
        this.useImpactTiming = useImpactTiming;
    }

    public boolean isDebugPosition() {
        return this.debugPosition;
    }

    public void setDebugPosition(boolean debugPosition) {
        this.debugPosition = debugPosition;
    }

    public static PunchyConfig load() {
        block17: {
            PunchyConfig punchyConfig;
            File cfg = PunchyConfig.getFile();
            if (!cfg.exists()) break block17;
            FileReader r = new FileReader(cfg);
            try {
                JsonObject obj = (JsonObject)GSON.fromJson((Reader)r, JsonObject.class);
                PunchyConfig c = new PunchyConfig();
                if (obj != null && obj.has("speedPreset")) {
                    c.speedPreset = SpeedPreset.fromName(obj.get("speedPreset").getAsString());
                }
                if (obj != null && obj.has("swordSpeed")) {
                    c.swordSpeed = SwordSpeed.fromName(obj.get("swordSpeed").getAsString());
                }
                if (obj != null && obj.has("maceSpeed")) {
                    c.maceSpeed = MaceSpeed.fromName(obj.get("maceSpeed").getAsString());
                }
                if (obj != null && obj.has("tridentSpeed")) {
                    c.tridentSpeed = TridentSpeed.fromName(obj.get("tridentSpeed").getAsString());
                }
                if (obj != null && obj.has("tridentThrowSpeed")) {
                    c.tridentThrowSpeed = TridentThrowSpeed.fromName(obj.get("tridentThrowSpeed").getAsString());
                }
                if (obj != null && obj.has("blockPlaceSpeed")) {
                    c.blockPlaceSpeed = BlockPlaceSpeed.fromName(obj.get("blockPlaceSpeed").getAsString());
                }
                if (obj != null && obj.has("removeAttackCooldown")) {
                    c.removeAttackCooldown = obj.get("removeAttackCooldown").getAsBoolean();
                }
                if (obj != null && obj.has("hideAttackIndicator")) {
                    c.hideAttackIndicator = obj.get("hideAttackIndicator").getAsBoolean();
                }
                if (obj != null && obj.has("useImpactTiming")) {
                    c.useImpactTiming = obj.get("useImpactTiming").getAsBoolean();
                }
                if (obj != null && obj.has("debugPosition")) {
                    c.debugPosition = obj.get("debugPosition").getAsBoolean();
                }
                punchyConfig = c;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        r.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            r.close();
            return punchyConfig;
        }
        return new PunchyConfig();
    }

    public void save() {
        try {
            File cfg = PunchyConfig.getFile();
            if (!cfg.getParentFile().exists()) {
                cfg.getParentFile().mkdirs();
            }
            JsonObject obj = new JsonObject();
            obj.addProperty("speedPreset", this.speedPreset.name());
            obj.addProperty("swordSpeed", this.swordSpeed.name());
            obj.addProperty("maceSpeed", this.maceSpeed.name());
            obj.addProperty("tridentSpeed", this.tridentSpeed.name());
            obj.addProperty("tridentThrowSpeed", this.tridentThrowSpeed.name());
            obj.addProperty("blockPlaceSpeed", this.blockPlaceSpeed.name());
            obj.addProperty("removeAttackCooldown", Boolean.valueOf(this.removeAttackCooldown));
            obj.addProperty("hideAttackIndicator", Boolean.valueOf(this.hideAttackIndicator));
            obj.addProperty("useImpactTiming", Boolean.valueOf(this.useImpactTiming));
            obj.addProperty("debugPosition", Boolean.valueOf(this.debugPosition));
            try (FileWriter w = new FileWriter(cfg);){
                GSON.toJson((JsonElement)obj, (Appendable)w);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static File getFile() {
        File configDir = FabricLoader.getInstance().getConfigDir().toFile();
        return new File(configDir, FILE_NAME);
    }

    public static enum SpeedPreset {
        ORIGINAL(1.0, "DEBUG"),
        REALISTIC(4.0, "Realistic"),
        PUNCHYA(5.0, "Punchya!");

        public final double speed;
        public final String label;

        private SpeedPreset(double speed, String label) {
            this.speed = speed;
            this.label = label;
        }

        public static SpeedPreset fromName(String n) {
            for (SpeedPreset p : SpeedPreset.values()) {
                if (!p.name().equalsIgnoreCase(n)) continue;
                return p;
            }
            return PUNCHYA;
        }
    }

    public static enum SwordSpeed {
        X1(1.0, "1x"),
        X2(2.0, "2x"),
        X3(3.0, "3x"),
        X4(4.0, "4x"),
        X5(5.0, "5x");

        public final double multiplier;
        public final String label;

        private SwordSpeed(double multiplier, String label) {
            this.multiplier = multiplier;
            this.label = label;
        }

        public static SwordSpeed fromName(String n) {
            for (SwordSpeed s : SwordSpeed.values()) {
                if (!s.name().equalsIgnoreCase(n)) continue;
                return s;
            }
            return X2;
        }
    }

    public static enum MaceSpeed {
        X1(1.0, "1x"),
        X2(2.0, "2x"),
        X3(3.0, "3x"),
        X4(4.0, "4x"),
        X5(5.0, "5x");

        public final double multiplier;
        public final String label;

        private MaceSpeed(double multiplier, String label) {
            this.multiplier = multiplier;
            this.label = label;
        }

        public static MaceSpeed fromName(String n) {
            for (MaceSpeed s : MaceSpeed.values()) {
                if (!s.name().equalsIgnoreCase(n)) continue;
                return s;
            }
            return X2;
        }
    }

    public static enum TridentSpeed {
        X1(1.0, "1x"),
        X2(2.0, "2x"),
        X3(3.0, "3x"),
        X4(4.0, "4x"),
        X5(5.0, "5x");

        public final double multiplier;
        public final String label;

        private TridentSpeed(double multiplier, String label) {
            this.multiplier = multiplier;
            this.label = label;
        }

        public static TridentSpeed fromName(String n) {
            for (TridentSpeed s : TridentSpeed.values()) {
                if (!s.name().equalsIgnoreCase(n)) continue;
                return s;
            }
            return X4;
        }
    }

    public static enum TridentThrowSpeed {
        X0_5(0.5, "0.5x"),
        X0_75(0.75, "0.75x"),
        X1(1.0, "1x"),
        X1_5(1.5, "1.5x"),
        X2(2.0, "2x"),
        X3(3.0, "3x");

        public final double multiplier;
        public final String label;

        private TridentThrowSpeed(double multiplier, String label) {
            this.multiplier = multiplier;
            this.label = label;
        }

        public static TridentThrowSpeed fromName(String n) {
            for (TridentThrowSpeed s : TridentThrowSpeed.values()) {
                if (!s.name().equalsIgnoreCase(n)) continue;
                return s;
            }
            return X1;
        }
    }

    public static enum BlockPlaceSpeed {
        X1_0(1.0, "1.0x"),
        X1_5(1.5, "1.5x"),
        X2_0(2.0, "2.0x"),
        X2_5(2.5, "2.5x"),
        X3_0(3.0, "3.0x"),
        X3_5(3.5, "3.5x"),
        X4_0(4.0, "4.0x"),
        X4_5(4.5, "4.5x"),
        X5_0(5.0, "5.0x"),
        X5_5(5.5, "5.5x"),
        X6_0(6.0, "6.0x"),
        X6_5(6.5, "6.5x"),
        X7_0(7.0, "7.0x"),
        X7_5(7.5, "7.5x"),
        X8_0(8.0, "8.0x"),
        X8_5(8.5, "8.5x"),
        X9_0(9.0, "9.0x"),
        X9_5(9.5, "9.5x"),
        X10_0(10.0, "10.0x");

        public final double multiplier;
        public final String label;

        private BlockPlaceSpeed(double multiplier, String label) {
            this.multiplier = multiplier;
            this.label = label;
        }

        public static BlockPlaceSpeed fromName(String n) {
            for (BlockPlaceSpeed s : BlockPlaceSpeed.values()) {
                if (!s.name().equalsIgnoreCase(n)) continue;
                return s;
            }
            return X7_0;
        }
    }
}

