/*
 * Decompiled with CFR 0.152.
 */
package com.henrique.punchy.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.henrique.punchy.client.render.ShubbaDuckTuning;
import com.henrique.punchy.client.render.ToolTuning;
import com.henrique.punchy.client.renderer.layer.ArmToolTuning;
import com.henrique.punchy.client.renderer.layer.PlayerArmModelLayer;
import com.henrique.punchy.client.renderer.layer.VanillaFirstPersonItemLayer;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;

public final class PunchyTuningConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String FILE_NAME = "punchy_tuning.json";
    private static final class_2960 DEFAULTS_ID = class_2960.method_60655((String)"punchy", (String)"default_tuning.json");

    private PunchyTuningConfig() {
    }

    private static File getFile() {
        class_310 client = class_310.method_1551();
        if (client == null) {
            return new File(FILE_NAME);
        }
        File runDir = client.field_1697;
        return new File(new File(runDir, "config"), FILE_NAME);
    }

    public static void loadAndApply() {
        try {
            Data data = null;
            File file = PunchyTuningConfig.getFile();
            if (file.exists()) {
                try (FileReader reader = new FileReader(file);){
                    data = (Data)GSON.fromJson((Reader)reader, Data.class);
                }
            } else {
                data = PunchyTuningConfig.loadDefaultsFromResource();
                if (data != null) {
                    PunchyTuningConfig.applyData(data);
                    PunchyTuningConfig.saveData(data);
                    return;
                }
            }
            if (data != null) {
                PunchyTuningConfig.applyData(data);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static Data loadDefaultsFromResource() {
        try {
            class_310 client = class_310.method_1551();
            if (client == null) {
                return null;
            }
            class_3298 res = client.method_1478().method_14486(DEFAULTS_ID).orElse(null);
            if (res == null) {
                return null;
            }
            try (InputStream in = res.method_14482();){
                Data data;
                try (InputStreamReader reader = new InputStreamReader(in, StandardCharsets.UTF_8);){
                    data = (Data)GSON.fromJson((Reader)reader, Data.class);
                }
                return data;
            }
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static void applyData(Data data) {
        if (data == null) {
            return;
        }
        if (data.item == null) {
            data.item = new HashMap<String, SideSet>();
        }
        if (data.arm == null) {
            data.arm = new HashMap<String, SideSet>();
        }
        for (VanillaFirstPersonItemLayer.ToolKind kind : VanillaFirstPersonItemLayer.ToolKind.values()) {
            SideSet set = data.item.get(kind.name());
            if (set == null) continue;
            if (set.right != null) {
                ToolTuning.apply(kind, false, set.right.toTool());
            }
            if (set.left == null) continue;
            ToolTuning.apply(kind, true, set.left.toTool());
        }
        SideSet shubbaItem = data.item.get("SHUBBA_DUCK");
        if (shubbaItem != null) {
            if (shubbaItem.right != null) {
                ShubbaDuckTuning.apply(false, shubbaItem.right.toTool());
            }
            if (shubbaItem.left != null) {
                ShubbaDuckTuning.apply(true, shubbaItem.left.toTool());
            }
        }
        for (PlayerArmModelLayer.ToolKind kind : PlayerArmModelLayer.ToolKind.values()) {
            SideSet set = data.arm.get(kind.name());
            if (set == null) continue;
            if (set.right != null) {
                ArmToolTuning.apply(kind, false, set.right.toArm());
            }
            if (set.left == null) continue;
            ArmToolTuning.apply(kind, true, set.left.toArm());
        }
    }

    public static void saveCurrent() {
        try {
            Data data = PunchyTuningConfig.captureCurrent();
            PunchyTuningConfig.saveData(data);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static Data captureCurrent() {
        Data d = new Data();
        for (VanillaFirstPersonItemLayer.ToolKind kind : VanillaFirstPersonItemLayer.ToolKind.values()) {
            SideSet ss = new SideSet();
            ss.right = Pose.fromTool(ToolTuning.snapshot(kind, false));
            ss.left = Pose.fromTool(ToolTuning.snapshot(kind, true));
            d.item.put(kind.name(), ss);
        }
        SideSet shubba = new SideSet();
        shubba.right = Pose.fromTool(ShubbaDuckTuning.snapshot(false));
        shubba.left = Pose.fromTool(ShubbaDuckTuning.snapshot(true));
        d.item.put("SHUBBA_DUCK", shubba);
        for (PlayerArmModelLayer.ToolKind kind : PlayerArmModelLayer.ToolKind.values()) {
            SideSet ss = new SideSet();
            ss.right = Pose.fromArm(ArmToolTuning.snapshot(kind, false));
            ss.left = Pose.fromArm(ArmToolTuning.snapshot(kind, true));
            d.arm.put(kind.name(), ss);
        }
        return d;
    }

    private static void saveData(Data data) {
        File file = PunchyTuningConfig.getFile();
        File parent = file.getParentFile();
        if (parent != null && !parent.exists()) {
            parent.mkdirs();
        }
        try (FileWriter writer = new FileWriter(file);){
            GSON.toJson((Object)data, (Appendable)writer);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static final class Data {
        public Map<String, SideSet> item = new HashMap<String, SideSet>();
        public Map<String, SideSet> arm = new HashMap<String, SideSet>();
    }

    public static final class SideSet {
        public Pose right;
        public Pose left;
    }

    public static final class Pose {
        public float scale;
        public float offX;
        public float offY;
        public float offZ;
        public float rotX;
        public float rotY;
        public float rotZ;
        public float pivotX;
        public float pivotY;
        public float pivotZ;

        public Pose() {
        }

        public Pose(float scale, float offX, float offY, float offZ, float rotX, float rotY, float rotZ) {
            this(scale, offX, offY, offZ, rotX, rotY, rotZ, 0.0f, 0.0f, 0.0f);
        }

        public Pose(float scale, float offX, float offY, float offZ, float rotX, float rotY, float rotZ, float pivotX, float pivotY, float pivotZ) {
            this.scale = scale;
            this.offX = offX;
            this.offY = offY;
            this.offZ = offZ;
            this.rotX = rotX;
            this.rotY = rotY;
            this.rotZ = rotZ;
            this.pivotX = pivotX;
            this.pivotY = pivotY;
            this.pivotZ = pivotZ;
        }

        public static Pose fromTool(ToolTuning.Profile p) {
            return new Pose(p.scale, p.offX, p.offY, p.offZ, p.rotX, p.rotY, p.rotZ, p.pivotX, p.pivotY, p.pivotZ);
        }

        public static Pose fromArm(ArmToolTuning.Profile p) {
            return new Pose(p.scale, p.offX, p.offY, p.offZ, p.rotX, p.rotY, p.rotZ);
        }

        public ToolTuning.Profile toTool() {
            return new ToolTuning.Profile(this.scale, this.offX, this.offY, this.offZ, this.rotX, this.rotY, this.rotZ, this.pivotX, this.pivotY, this.pivotZ);
        }

        public ArmToolTuning.Profile toArm() {
            return new ArmToolTuning.Profile(this.scale, this.offX, this.offY, this.offZ, this.rotX, this.rotY, this.rotZ);
        }
    }
}

