/*
 * Decompiled with CFR 0.152.
 */
package com.henrique.punchy.item;

import com.henrique.punchy.Punchy;
import com.henrique.punchy.client.BlockActionGuards;
import com.henrique.punchy.combat.ImpactClientHooks;
import com.henrique.punchy.item.AnimatedAxe;
import com.henrique.punchy.item.AnimatedBlockProxy;
import com.henrique.punchy.item.AnimatedHoe;
import com.henrique.punchy.item.AnimatedMace;
import com.henrique.punchy.item.AnimatedShovel;
import com.henrique.punchy.item.AnimatedSword;
import com.henrique.punchy.item.AnimatedTrident;
import com.henrique.punchy.networking.packet.AxeStripPayload;
import com.henrique.punchy.networking.packet.BlockImpactPayload;
import com.henrique.punchy.networking.packet.HoeTillPayload;
import com.henrique.punchy.networking.packet.ShovelPathPayload;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_7923;
import net.minecraft.class_8710;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animatable.manager.AnimatableManager;
import software.bernie.geckolib.animatable.processing.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.animation.keyframe.event.KeyFrameEvent;
import software.bernie.geckolib.animation.keyframe.event.data.CustomInstructionKeyframeData;
import software.bernie.geckolib.animation.keyframe.event.data.SoundKeyframeData;
import software.bernie.geckolib.util.GeckoLibUtil;

public abstract class AnimatedTool
extends class_1792
implements GeoItem {
    protected final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final ThreadLocal<class_1268> NEXT_ACTION_HAND = ThreadLocal.withInitial(() -> class_1268.field_5808);
    private static final ThreadLocal<Boolean> HOE_USE_FLAG = ThreadLocal.withInitial(() -> Boolean.FALSE);
    private static final ThreadLocal<Boolean> AXE_STRIP_FLAG = ThreadLocal.withInitial(() -> Boolean.FALSE);
    private static final ThreadLocal<Boolean> SHOVEL_PATH_FLAG = ThreadLocal.withInitial(() -> Boolean.FALSE);

    protected AnimatedTool(class_1792.class_1793 settings) {
        super(settings);
        SingletonGeoAnimatable.registerSyncedAnimatable((SingletonGeoAnimatable)this);
    }

    protected abstract String anim(String var1);

    public abstract void createGeoRenderer(Consumer<GeoRenderProvider> var1);

    private String animOrEmpty(String key) {
        String clip = this.anim(key);
        return clip == null ? "" : clip;
    }

    public static void markNextActionHand(class_1268 hand) {
        if (hand != null) {
            NEXT_ACTION_HAND.set(hand);
        }
    }

    protected static class_1268 currentActionHand() {
        class_1268 hand = NEXT_ACTION_HAND.get();
        return hand == null ? class_1268.field_5808 : hand;
    }

    public boolean hasMultiMiningVariants() {
        return false;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        String attack2Clip;
        AnimationController activation = new AnimationController("Activation", 0, state -> PlayState.STOP);
        activation.triggerableAnim("activate", RawAnimation.begin().thenPlay(this.anim("mining")));
        activation.triggerableAnim("mine1", RawAnimation.begin().thenLoop(this.anim("mining")));
        activation.setAnimationSpeedHandler(a -> Punchy.ANIM_SPEED * this.speedScale());
        activation.setCustomInstructionKeyframeHandler(this::onCustomInstruction);
        activation.setSoundKeyframeHandler(this::onSoundKeyframe);
        String attackClip = this.animOrEmpty("attack");
        if (!attackClip.isEmpty()) {
            activation.triggerableAnim("attack", RawAnimation.begin().thenPlay(attackClip));
        }
        if (!(attack2Clip = this.animOrEmpty("attack_2")).isEmpty()) {
            activation.triggerableAnim("attack_2", RawAnimation.begin().thenPlay(attack2Clip));
        } else if (!attackClip.isEmpty()) {
            activation.triggerableAnim("attack_2", RawAnimation.begin().thenPlay(attackClip));
        }
        String attack3Clip = this.animOrEmpty("attack_3");
        if (!attack3Clip.isEmpty()) {
            activation.triggerableAnim("attack_3", RawAnimation.begin().thenPlay(attack3Clip));
        } else if (!attackClip.isEmpty()) {
            activation.triggerableAnim("attack_3", RawAnimation.begin().thenPlay(attackClip));
        }
        String eatClip = this.animOrEmpty("eat");
        String drinkClip = this.animOrEmpty("drink");
        controllers.add(activation);
        if (!eatClip.isEmpty() || !drinkClip.isEmpty()) {
            AnimationController consume = new AnimationController("Consume", 0, state -> PlayState.STOP);
            consume.setAnimationSpeedHandler(a -> 1.0);
            consume.setCustomInstructionKeyframeHandler(this::onCustomInstruction);
            consume.setSoundKeyframeHandler(this::onSoundKeyframe);
            if (!eatClip.isEmpty()) {
                consume.triggerableAnim("eat", RawAnimation.begin().thenPlay(eatClip));
            }
            if (!drinkClip.isEmpty()) {
                consume.triggerableAnim("drink", RawAnimation.begin().thenPlay(drinkClip));
            }
            controllers.add(consume);
        }
        controllers.add(new AnimationController("Inspect", 0, state -> PlayState.STOP).triggerableAnim("look_my_hand", RawAnimation.begin().thenPlay(this.anim("look_my_hand"))).setAnimationSpeedHandler(a -> 1.0).setSoundKeyframeHandler(this::onSoundKeyframe));
        controllers.add(new AnimationController("Select", 0, state -> PlayState.STOP).triggerableAnim("select", RawAnimation.begin().thenPlay(this.anim("select"))).setAnimationSpeedHandler(a -> 4.5).setSoundKeyframeHandler(this::onSoundKeyframe));
    }

    protected void onCustomInstruction(KeyFrameEvent<AnimatedTool, CustomInstructionKeyframeData> event) {
        String norm;
        class_310 client = class_310.method_1551();
        if (client == null || client.field_1724 == null || client.field_1687 == null) {
            return;
        }
        String instr = ((CustomInstructionKeyframeData)event.keyframeData()).getInstructions();
        String string = norm = instr == null ? "" : instr.toLowerCase().replace("[", "").replace("]", "").replace(";", "").trim();
        if ("impact".equals(norm)) {
            boolean resetAttackCooldown = false;
            class_1268 actionHand = AnimatedTool.currentActionHand();
            class_239 hr = client.field_1765;
            if (hr instanceof class_3965) {
                class_3965 bhr = (class_3965)hr;
                try {
                    if (this instanceof AnimatedBlockProxy) {
                        long now;
                        long l = now = client.field_1687 != null ? client.field_1687.method_8510() : -1L;
                        if (BlockActionGuards.isPlaceGuardActive(now)) {
                            return;
                        }
                    }
                }
                catch (Throwable now) {
                    // empty catch block
                }
                class_2338 pos = bhr.method_17777();
                class_2680 state = client.field_1687.method_8320(pos);
                if (!state.method_26215()) {
                    boolean hoeUse = HOE_USE_FLAG.get();
                    boolean axeStrip = AXE_STRIP_FLAG.get();
                    boolean shovelPath = SHOVEL_PATH_FLAG.get();
                    if (this instanceof AnimatedHoe && hoeUse) {
                        ClientPlayNetworking.send((class_8710)new HoeTillPayload(bhr.method_17777()));
                        resetAttackCooldown = true;
                    } else if (this instanceof AnimatedAxe && axeStrip) {
                        ClientPlayNetworking.send((class_8710)new AxeStripPayload(bhr.method_17777()));
                        resetAttackCooldown = true;
                    } else if (this instanceof AnimatedShovel && shovelPath) {
                        ClientPlayNetworking.send((class_8710)new ShovelPathPayload(bhr.method_17777()));
                        resetAttackCooldown = true;
                    } else {
                        class_3414 ev = state.method_26231().method_10596();
                        float vol = Math.max(0.2f, Math.min(1.5f, state.method_26231().method_10597()));
                        float pitch = (float)Math.max(0.25, Math.min(2.0, Punchy.SOUND_RATE));
                        client.field_1724.method_5783(ev, vol, pitch);
                        ClientPlayNetworking.send((class_8710)new BlockImpactPayload(bhr.method_17777()));
                        resetAttackCooldown = true;
                    }
                    HOE_USE_FLAG.set(Boolean.FALSE);
                    AXE_STRIP_FLAG.set(Boolean.FALSE);
                    SHOVEL_PATH_FLAG.set(Boolean.FALSE);
                }
            } else if (hr instanceof class_3966) {
                class_1297 entity;
                class_3966 ehr = (class_3966)hr;
                if ((this instanceof AnimatedSword || this instanceof AnimatedMace || this instanceof AnimatedTrident || this instanceof AnimatedBlockProxy) && (entity = ehr.method_17782()) != null) {
                    ImpactClientHooks.fireAttackImpact(entity, actionHand);
                    resetAttackCooldown = true;
                }
            }
            if (resetAttackCooldown && client.field_1724 != null) {
                try {
                    client.field_1724.method_7350();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            AnimatedTool.markNextActionHand(class_1268.field_5808);
        }
    }

    protected double speedScale() {
        return 1.0;
    }

    protected void onSoundKeyframe(KeyFrameEvent<AnimatedTool, SoundKeyframeData> event) {
        class_2960 id;
        class_310 client = class_310.method_1551();
        if (client == null || client.field_1724 == null) {
            return;
        }
        String soundId = null;
        try {
            SoundKeyframeData data = (SoundKeyframeData)event.keyframeData();
            if (data != null) {
                soundId = data.getSound();
            }
        }
        catch (Throwable ignored) {
            try {
                soundId = (String)AnimatedTool.class.getMethod("getSoundFromEvent", Object.class).invoke(null, event);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (soundId == null || soundId.isEmpty()) {
            return;
        }
        try {
            id = soundId.contains(":") ? class_2960.method_60654((String)soundId) : class_2960.method_60655((String)"punchy", (String)soundId);
        }
        catch (Throwable t) {
            return;
        }
        class_3414 se = (class_3414)class_7923.field_41172.method_63535(id);
        if (se == null) {
            se = class_3414.method_47908((class_2960)id);
        }
        float vol = 1.0f;
        float pitch = (float)Math.max(0.25, Math.min(2.0, Punchy.SOUND_RATE));
        client.field_1724.method_5783(se, vol, pitch);
    }

    public class_1269 method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        return class_1269.field_5811;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public static void markNextImpactAsHoeUse() {
        HOE_USE_FLAG.set(Boolean.TRUE);
    }

    public static void markNextImpactAsAxeStrip() {
        AXE_STRIP_FLAG.set(Boolean.TRUE);
    }

    public static void markNextImpactAsShovelUse() {
        SHOVEL_PATH_FLAG.set(Boolean.TRUE);
    }
}

