/*
 * Decompiled with CFR 0.152.
 */
package com.henrique.punchy.item;

import com.henrique.punchy.Punchy;
import com.henrique.punchy.client.render.VanillaProxyContext;
import com.henrique.punchy.geo.renderer.SharedTridentRenderer;
import com.henrique.punchy.item.AnimatedTool;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import net.minecraft.class_10590;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1814;
import net.minecraft.class_1835;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.class_9334;
import net.minecraft.class_9463;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animatable.manager.AnimatableManager;
import software.bernie.geckolib.animatable.processing.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.animation.keyframe.event.KeyFrameEvent;
import software.bernie.geckolib.animation.keyframe.event.data.CustomInstructionKeyframeData;
import software.bernie.geckolib.animation.keyframe.event.data.SoundKeyframeData;

public class AnimatedTrident
extends AnimatedTool
implements class_9463 {
    private static final class_1835 VANILLA = (class_1835)class_1802.field_8547;
    private static final String THROW_HOLD_TRIGGER = "throw_hold";
    private static final String THROW_END_TRIGGER = "throw_end";
    private static final Map<class_1268, ThrowAnimationState> THROW_STATES = new EnumMap<class_1268, ThrowAnimationState>(class_1268.class);
    private static final Set<class_1657> SWING_SUPPRESSION = Collections.newSetFromMap(new WeakHashMap());

    public AnimatedTrident() {
        super(new class_1792.class_1793().method_7894(class_1814.field_8903).method_7895(250).method_57348(class_1835.method_57395()).method_57349(class_9334.field_50077, (Object)class_1835.method_58420()).method_61649(1).method_57349(class_9334.field_55878, (Object)new class_10590(1)).method_63686(class_5321.method_29179((class_5321)class_7924.field_41197, (class_2960)class_2960.method_60655((String)"punchy", (String)"animated_trident"))));
    }

    @Override
    protected String anim(String key) {
        return switch (key) {
            case "mining" -> "animation.trident_animated.attack";
            case "mining_2" -> "animation.trident_animated.attack";
            case "mining_3" -> "animation.trident_animated.attack";
            case "attack" -> "animation.trident_animated.attack";
            case "throw" -> "animation.trident_animated.throw";
            case THROW_END_TRIGGER -> "animation.trident_animated.throw_end";
            case "look_my_hand" -> "animation.trident_animated.look_my_hand";
            case "select" -> "animation.trident_animated.select";
            default -> "";
        };
    }

    @Override
    public void createGeoRenderer(Consumer<GeoRenderProvider> consumer) {
        consumer.accept(new GeoRenderProvider(this){
            private SharedTridentRenderer<AnimatedTrident> renderer;

            public SharedTridentRenderer<AnimatedTrident> getGeoItemRenderer() {
                if (this.renderer == null) {
                    this.renderer = new SharedTridentRenderer();
                }
                return this.renderer;
            }
        });
    }

    public class_2960 getTextureId() {
        return class_2960.method_60655((String)"minecraft", (String)"textures/item/trident.png");
    }

    @Override
    protected double speedScale() {
        double global = Punchy.ANIM_SPEED;
        double trident = Punchy.TRIDENT_ANIM_SPEED;
        if (global <= 0.0) {
            return trident;
        }
        return trident / global;
    }

    @Override
    public boolean hasMultiMiningVariants() {
        return false;
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8952;
    }

    public int method_7881(class_1799 stack, class_1309 user) {
        return VANILLA.method_7881(stack, user);
    }

    public boolean method_7840(class_1799 stack, class_1937 world, class_1309 user, int remainingUseTicks) {
        if (user instanceof class_1657) {
            class_1657 player = (class_1657)user;
            AnimatedTrident.suppressNextSwing(player);
        }
        return VANILLA.method_7840(stack, world, user, remainingUseTicks);
    }

    @Override
    public class_1269 method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1269 result = VANILLA.method_7836(world, user, hand);
        if (result.method_23665()) {
            AnimatedTool.markNextActionHand(hand);
        }
        return result;
    }

    public class_1676 method_58648(class_1937 world, class_2374 pos, class_1799 stack, class_2350 direction) {
        return VANILLA.method_58648(world, pos, stack, direction);
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        String throwEndClip;
        String attack2Clip;
        AnimationController activation = new AnimationController("Activation", 0, state -> PlayState.STOP);
        activation.triggerableAnim("activate", RawAnimation.begin().thenPlay(this.anim("mining")));
        activation.triggerableAnim("mine1", RawAnimation.begin().thenLoop(this.anim("mining")));
        activation.setAnimationSpeedHandler(trident -> {
            ThrowAnimationState throwState = AnimatedTrident.currentThrowStateFor(trident);
            return throwState != null && throwState.charging ? AnimatedTrident.throwSpeed() : AnimatedTrident.attackSpeed();
        });
        activation.setCustomInstructionKeyframeHandler(event -> AnimatedTrident.access$301(this, event));
        activation.setSoundKeyframeHandler(event -> AnimatedTrident.access$201(this, event));
        String attackClip = this.anim("attack");
        if (attackClip != null && !attackClip.isEmpty()) {
            activation.triggerableAnim("attack", RawAnimation.begin().thenPlay(attackClip));
        }
        if ((attack2Clip = this.anim("attack_2")) != null && !attack2Clip.isEmpty()) {
            activation.triggerableAnim("attack_2", RawAnimation.begin().thenPlay(attack2Clip));
        } else if (attackClip != null && !attackClip.isEmpty()) {
            activation.triggerableAnim("attack_2", RawAnimation.begin().thenPlay(attackClip));
        }
        String attack3Clip = this.anim("attack_3");
        if (attack3Clip != null && !attack3Clip.isEmpty()) {
            activation.triggerableAnim("attack_3", RawAnimation.begin().thenPlay(attack3Clip));
        } else if (attackClip != null && !attackClip.isEmpty()) {
            activation.triggerableAnim("attack_3", RawAnimation.begin().thenPlay(attackClip));
        }
        String throwClip = this.anim("throw");
        if (throwClip != null && !throwClip.isEmpty()) {
            activation.triggerableAnim(THROW_HOLD_TRIGGER, RawAnimation.begin().thenPlayAndHold(throwClip));
        }
        if ((throwEndClip = this.anim(THROW_END_TRIGGER)) != null && !throwEndClip.isEmpty()) {
            activation.triggerableAnim(THROW_END_TRIGGER, RawAnimation.begin().thenPlay(throwEndClip));
        }
        controllers.add(activation);
        controllers.add(new AnimationController("Inspect", 0, state -> PlayState.STOP).triggerableAnim("look_my_hand", RawAnimation.begin().thenPlay(this.anim("look_my_hand"))).setAnimationSpeedHandler(ctrl -> 1.0).setSoundKeyframeHandler(event -> AnimatedTrident.access$101(this, event)));
        controllers.add(new AnimationController("Select", 0, state -> PlayState.STOP).triggerableAnim("select", RawAnimation.begin().thenPlay(this.anim("select"))).setAnimationSpeedHandler(ctrl -> 4.5).setSoundKeyframeHandler(event -> AnimatedTrident.access$001(this, event)));
    }

    public static void beginCharging(class_1657 player, class_1268 hand, class_1799 proxyStack) {
        class_1792 class_17922;
        if (proxyStack == null || proxyStack.method_7960() || !((class_17922 = proxyStack.method_7909()) instanceof AnimatedTrident)) {
            return;
        }
        AnimatedTrident trident = (AnimatedTrident)class_17922;
        class_1268 effectiveHand = hand == null ? class_1268.field_5808 : hand;
        long id = GeoItem.getId((class_1799)proxyStack);
        ThrowAnimationState state = new ThrowAnimationState(trident, id, effectiveHand);
        state.charging = true;
        THROW_STATES.put(effectiveHand, state);
        AnimatedTool.markNextActionHand(effectiveHand);
        VanillaProxyContext.setHand(effectiveHand);
        AnimationController<?> controller = AnimatedTrident.getActivationController(state);
        if (controller != null) {
            controller.forceAnimationReset();
            controller.setAnimationState(AnimationController.State.RUNNING);
            controller.setAnimationSpeed(AnimatedTrident.throwSpeed());
        }
        ((GeoItem)proxyStack.method_7909()).triggerAnim((class_1297)player, id, "Activation", THROW_HOLD_TRIGGER);
    }

    public static void tickCharging(class_1657 player, class_1268 hand, class_1799 proxyStack) {
        ThrowAnimationState state = THROW_STATES.get(hand);
        if (state == null) {
            return;
        }
        state.charging = true;
        VanillaProxyContext.setHand(hand);
        AnimationController<?> controller = AnimatedTrident.getActivationController(state);
        if (controller != null) {
            controller.setAnimationSpeed(AnimatedTrident.throwSpeed());
        }
    }

    public static void releaseThrow(class_1657 player, class_1268 hand) {
        ThrowAnimationState state = THROW_STATES.remove(hand);
        if (state == null) {
            return;
        }
        state.charging = false;
        AnimatedTool.markNextActionHand(hand);
        VanillaProxyContext.setHand(hand);
        AnimationController<?> controller = AnimatedTrident.getActivationController(state);
        if (controller != null) {
            controller.forceAnimationReset();
            controller.setAnimationState(AnimationController.State.RUNNING);
            controller.setAnimationSpeed(AnimatedTrident.attackSpeed());
        }
        AnimatedTrident geo = state.trident;
        geo.stopTriggeredAnim((class_1297)player, state.animationId, "Activation", THROW_HOLD_TRIGGER);
        geo.triggerAnim((class_1297)player, state.animationId, "Activation", THROW_END_TRIGGER);
        AnimatedTrident.suppressNextSwing(player);
    }

    public static void suppressNextSwing(class_1657 player) {
        if (player != null) {
            SWING_SUPPRESSION.add(player);
        }
    }

    public static boolean consumeSwingSuppression(class_1657 player) {
        return player != null && SWING_SUPPRESSION.remove(player);
    }

    private static AnimationController<?> getActivationController(ThrowAnimationState state) {
        if (state == null) {
            return null;
        }
        AnimatableInstanceCache cache = state.trident.getAnimatableInstanceCache();
        if (cache == null) {
            return null;
        }
        AnimatableManager manager = cache.getManagerForId(state.animationId);
        if (manager == null) {
            return null;
        }
        return (AnimationController)manager.getAnimationControllers().get("Activation");
    }

    private static ThrowAnimationState currentThrowStateFor(AnimatedTrident trident) {
        for (ThrowAnimationState state : THROW_STATES.values()) {
            if (state == null || state.trident != trident) continue;
            return state;
        }
        return null;
    }

    private static double attackSpeed() {
        return Math.max(0.001, Punchy.TRIDENT_ANIM_SPEED);
    }

    private static double throwSpeed() {
        return Math.max(0.001, Punchy.TRIDENT_THROW_SPEED);
    }

    static /* synthetic */ void access$001(AnimatedTrident x0, KeyFrameEvent x1) {
        super.onSoundKeyframe((KeyFrameEvent<AnimatedTool, SoundKeyframeData>)x1);
    }

    static /* synthetic */ void access$101(AnimatedTrident x0, KeyFrameEvent x1) {
        super.onSoundKeyframe((KeyFrameEvent<AnimatedTool, SoundKeyframeData>)x1);
    }

    static /* synthetic */ void access$201(AnimatedTrident x0, KeyFrameEvent x1) {
        super.onSoundKeyframe((KeyFrameEvent<AnimatedTool, SoundKeyframeData>)x1);
    }

    static /* synthetic */ void access$301(AnimatedTrident x0, KeyFrameEvent x1) {
        super.onCustomInstruction((KeyFrameEvent<AnimatedTool, CustomInstructionKeyframeData>)x1);
    }

    private static final class ThrowAnimationState {
        final AnimatedTrident trident;
        final long animationId;
        final class_1268 hand;
        boolean charging;

        ThrowAnimationState(AnimatedTrident trident, long animationId, class_1268 hand) {
            this.trident = trident;
            this.animationId = animationId;
            this.hand = hand;
            this.charging = false;
        }
    }
}

