/*
 * Decompiled with CFR 0.152.
 */
package com.henrique.punchy.server;

import com.henrique.punchy.Punchy;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public final class TapMiningManager {
    private static final Map<UUID, Map<class_2338, Double>> PROGRESS = new HashMap<UUID, Map<class_2338, Double>>();
    private static final Map<UUID, Map<class_2338, Integer>> BREAKER_IDS = new HashMap<UUID, Map<class_2338, Integer>>();
    private static final int CLICK_TICKS = 5;

    private TapMiningManager() {
    }

    public static void onClick(class_3222 player, class_3218 world, class_2338 pos) {
        if (player == null || world == null || pos == null) {
            return;
        }
        class_2680 state = world.method_8320(pos);
        if (state.method_26215()) {
            return;
        }
        double deltaPerTick = state.method_26165((class_1657)player, (class_1922)world, pos);
        if (deltaPerTick <= 0.0) {
            return;
        }
        double add = deltaPerTick * 5.0 * Punchy.MINING_SPEED_MULTIPLIER;
        Map map = PROGRESS.computeIfAbsent(player.method_5667(), k -> new HashMap());
        double prev = map.getOrDefault(pos, 0.0);
        double now = Math.min(1.0, prev + add);
        if (now >= 1.0) {
            map.remove(pos);
            int id = TapMiningManager.getBreakerId(player, pos);
            world.method_8517(id, pos, -1);
            TapMiningManager.clearBreakerId(player, pos);
            world.method_8651(pos, true, (class_1297)player);
            player.method_6047().method_71012(1, (class_1309)player, player.method_6058());
        } else {
            map.put(pos, now);
            int stage = Math.min(9, Math.max(0, (int)Math.floor(now * 10.0)));
            int id = TapMiningManager.getBreakerId(player, pos);
            world.method_8517(id, pos, stage);
        }
    }

    public static void tickWorld(class_3218 world) {
        for (class_3222 player : world.method_18456()) {
            Map<class_2338, Double> map = PROGRESS.get(player.method_5667());
            if (map == null || map.isEmpty()) continue;
            map.entrySet().removeIf(e -> {
                class_2338 pos = (class_2338)e.getKey();
                double prog = (Double)e.getValue();
                class_2680 state = world.method_8320(pos);
                if (state.method_26215()) {
                    int id = TapMiningManager.getBreakerId(player, pos);
                    world.method_8517(id, pos, -1);
                    TapMiningManager.clearBreakerId(player, pos);
                    return true;
                }
                if (prog >= 1.0) {
                    int id = TapMiningManager.getBreakerId(player, pos);
                    world.method_8517(id, pos, -1);
                    TapMiningManager.clearBreakerId(player, pos);
                    world.method_8651(pos, true, (class_1297)player);
                    player.method_6047().method_71012(1, (class_1309)player, player.method_6058());
                    return true;
                }
                int stage = Math.min(9, Math.max(0, (int)Math.floor(prog * 10.0)));
                int id = TapMiningManager.getBreakerId(player, pos);
                world.method_8517(id, pos, stage);
                return false;
            });
        }
    }

    private static int getBreakerId(class_3222 player, class_2338 pos) {
        Map ids = BREAKER_IDS.computeIfAbsent(player.method_5667(), k -> new HashMap());
        Integer id = (Integer)ids.get(pos);
        if (id != null) {
            return id;
        }
        int newId = 0x40000000 ^ player.method_5667().hashCode() ^ pos.hashCode();
        if (newId == player.method_5628()) {
            newId ^= 0x1FFFFF;
        }
        ids.put(pos, newId);
        return newId;
    }

    private static void clearBreakerId(class_3222 player, class_2338 pos) {
        Map<class_2338, Integer> ids = BREAKER_IDS.get(player.method_5667());
        if (ids != null) {
            ids.remove(pos);
        }
    }
}

