/*
 * Decompiled with CFR 0.152.
 */
package com.yori3o.yo_hooks.mixin;

import com.yori3o.yo_hooks.config.ServerConfig;
import com.yori3o.yo_hooks.entity.HookEntity;
import com.yori3o.yo_hooks.utils.PlayerWithHookData;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Player.class})
public class PlayerMixin
implements PlayerWithHookData {
    private HookEntity hookEntity;
    private Boolean isResetFallDistance = false;
    private static ServerConfig sc = new ServerConfig();
    private static final double SPRING_CONSTANT = ((ServerConfig.Values)PlayerMixin.sc.get()).hooksStiffness;
    private static final double DAMPING_CONSTANT = ((ServerConfig.Values)PlayerMixin.sc.get()).dampingForce;
    private static final double PUSH_FACTOR = ((ServerConfig.Values)PlayerMixin.sc.get()).forceModifier;
    private static final double RADIAL_CONTROL = ((ServerConfig.Values)PlayerMixin.sc.get()).radialControl;

    @Override
    public HookEntity getHook() {
        return this.hookEntity;
    }

    @Override
    public Boolean isResetFallDistance() {
        return this.isResetFallDistance;
    }

    @Override
    public void setHook(HookEntity value) {
        this.hookEntity = value;
    }

    @Inject(method={"travel(Lnet/minecraft/world/phys/Vec3;)V"}, at={@At(value="HEAD")})
    private void onTravel(Vec3 travelVector, CallbackInfo ci) {
        float maxChainLength;
        double equilibriumLength;
        Vec3 playerEyePos;
        Vec3 hookPos;
        Vec3 vecToHook;
        double dist;
        Player player = (Player)this;
        if (this.hookEntity != null && this.hookEntity.isInBlock() && !player.level().isClientSide() && (dist = (vecToHook = (hookPos = this.hookEntity.position()).subtract(playerEyePos = player.getEyePosition())).length()) > (equilibriumLength = (double)(maxChainLength = this.hookEntity.getLength())) * 0.95) {
            Vec3 unitVector = vecToHook.normalize();
            Vec3 playerVelocity = player.getDeltaMovement();
            double stretch = dist - equilibriumLength;
            double springForceMagnitude = SPRING_CONSTANT * stretch;
            if (stretch < 0.0) {
                springForceMagnitude = 0.0;
            }
            Vec3 springForce = unitVector.scale(springForceMagnitude);
            double velocityProjection = playerVelocity.dot(unitVector);
            double dampingMagnitude = -DAMPING_CONSTANT * velocityProjection;
            Vec3 dampingForce = unitVector.scale(dampingMagnitude);
            Vec3 totalForce = springForce.add(dampingForce);
            double radialSpeed = playerVelocity.dot(unitVector);
            Vec3 radialVelocity = unitVector.scale(radialSpeed);
            Vec3 antiRadialImpulse = radialVelocity.scale(-RADIAL_CONTROL);
            Vec3 pushForce = totalForce.scale(PUSH_FACTOR);
            Vec3 finalPush = pushForce.add(antiRadialImpulse);
            if (unitVector.y > -0.33) {
                player.push(finalPush.x, finalPush.y, finalPush.z);
                player.hurtMarked = true;
            }
            if (unitVector.y > -0.15) {
                this.isResetFallDistance = true;
                if (velocityProjection < 0.0) {
                    player.resetFallDistance();
                }
            } else {
                this.isResetFallDistance = false;
            }
        }
    }
}

