/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher;

import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="starcatcher", value={Dist.CLIENT})
public class Tooltips {
    public static float hue;

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void renderFrame(TickEvent.LevelTickEvent event) {
        if (event.level.f_46443_) {
            hue += 0.002f;
        }
    }

    @SubscribeEvent
    public static void modifyItemTooltip(ItemTooltipEvent event) {
        String path;
        List tooltipComponents = event.getToolTip();
        ItemStack stack = event.getItemStack();
        ResourceLocation rl = BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_());
        String namespace = rl.m_135827_();
        String baseTooltip = "tooltip." + namespace + "." + (path = rl.m_135815_());
        if (I18n.m_118936_((String)(baseTooltip + ".name"))) {
            tooltipComponents.remove(0);
            tooltipComponents.add(0, Tooltips.decodeTranslationKey(baseTooltip + ".name"));
        }
        if (I18n.m_118936_((String)(baseTooltip + ".0"))) {
            if (Screen.m_96638_()) {
                tooltipComponents.add(Component.m_237115_((String)"tooltip.libtooltips.generic.shift_down"));
                tooltipComponents.add(Component.m_237115_((String)"tooltip.libtooltips.generic.empty"));
                for (int i = 0; i < 100 && I18n.m_118936_((String)(baseTooltip + "." + i)); ++i) {
                    tooltipComponents.add(Tooltips.decodeTranslationKey(baseTooltip + "." + i));
                }
            } else {
                tooltipComponents.add(Component.m_237115_((String)"tooltip.libtooltips.generic.shift_up"));
            }
        }
    }

    public static Component decodeTranslationKey(String s) {
        return Tooltips.decodeString(I18n.m_118938_((String)s, (Object[])new Object[0]));
    }

    public static Component decodeString(String s) {
        MutableComponent component = Component.m_237119_();
        for (int i = 0; i < 100; ++i) {
            float max;
            float min;
            if (s.indexOf("<rgb>") < s.indexOf("<gradient-") && s.contains("<rgb>") && s.contains("</rgb>")) {
                component.m_7220_((Component)Component.m_237113_((String)s.substring(0, s.indexOf("<rgb>"))));
                component.m_7220_(Tooltips.RGBEachLetter(s.substring(s.indexOf("<rgb>") + 5, s.indexOf("</rgb>"))));
                s = s.substring(s.indexOf("</rgb>") + 6);
                continue;
            }
            if (s.indexOf("<gradient-") < s.indexOf("<rgb>") && s.contains("<gradient-") && s.contains("</gradient-")) {
                min = Float.parseFloat("0." + s.substring(s.indexOf("<gradient") + 10, s.indexOf("<gradient") + 12));
                max = Float.parseFloat("0." + s.substring(s.indexOf("</gradient") + 11, s.indexOf("</gradient") + 13));
                component.m_7220_((Component)Component.m_237113_((String)s.substring(0, s.indexOf("<gradient"))));
                component.m_7220_(Tooltips.gradient(s.substring(s.indexOf("<gradient") + 13, s.indexOf("</gradient")), min, max));
                s = s.substring(s.indexOf("</gradient-") + 14);
                continue;
            }
            if (s.contains("<rgb>") && s.contains("</rgb>")) {
                component.m_7220_((Component)Component.m_237113_((String)s.substring(0, s.indexOf("<rgb>"))));
                component.m_7220_(Tooltips.RGBEachLetter(s.substring(s.indexOf("<rgb>") + 5, s.indexOf("</rgb>"))));
                s = s.substring(s.indexOf("</rgb>") + 6);
                continue;
            }
            if (s.contains("<gradient-") && s.contains("</gradient-")) {
                min = Float.parseFloat("0." + s.substring(s.indexOf("<gradient") + 10, s.indexOf("<gradient") + 12));
                max = Float.parseFloat("0." + s.substring(s.indexOf("</gradient") + 11, s.indexOf("</gradient") + 13));
                component.m_7220_((Component)Component.m_237113_((String)s.substring(0, s.indexOf("<gradient"))));
                component.m_7220_(Tooltips.gradient(s.substring(s.indexOf("<gradient") + 13, s.indexOf("</gradient")), min, max));
                s = s.substring(s.indexOf("</gradient-") + 14);
                continue;
            }
            component.m_130946_(s);
            break;
        }
        return component;
    }

    public static Component gradient(String text, float min, float max) {
        MutableComponent c = Component.m_237119_();
        for (int i = 0; i < text.length(); ++i) {
            String s = text.substring(i, i + 1);
            float pingPongedHue = Tooltips.mapHuePingPong((float)i * 0.01f + hue, min, max);
            int color = Tooltips.hueToRGBInt(pingPongedHue);
            MutableComponent l = Component.m_237113_((String)s).m_130948_(Style.f_131099_.m_178520_(color));
            c.m_7220_((Component)l);
        }
        return c;
    }

    public static float mapHuePingPong(float h, float min, float max) {
        float t = Math.abs(2.0f * (h % 1.0f) - 1.0f);
        return min + t * (max - min);
    }

    public static Component RGBEachLetter(String text) {
        return Tooltips.RGBEachLetter(text, 0.01f);
    }

    public static Component RGBEachLetter(String text, float speed) {
        MutableComponent c = Component.m_237119_();
        for (int i = 0; i < text.length(); ++i) {
            String s = text.substring(i, i + 1);
            int color = Tooltips.hueToRGBInt((float)i * speed + hue);
            MutableComponent l = Component.m_237113_((String)s).m_130948_(Style.f_131099_.m_178520_(color));
            c.m_7220_((Component)l);
        }
        return c;
    }

    public static int hueToRGBInt(float hue) {
        int r = 0;
        int g = 0;
        int b = 0;
        float h = (hue - (float)Math.floor(hue)) * 6.0f;
        float f = h - (float)Math.floor(h);
        float q = 1.0f - f;
        float t = 1.0f - (1.0f - f);
        switch ((int)h) {
            case 0: {
                r = 255;
                g = (int)(t * 255.0f + 0.5f);
                break;
            }
            case 1: {
                r = (int)(q * 255.0f + 0.5f);
                g = 255;
                break;
            }
            case 2: {
                g = 255;
                b = (int)(t * 255.0f + 0.5f);
                break;
            }
            case 3: {
                g = (int)(q * 255.0f + 0.5f);
                b = 255;
                break;
            }
            case 4: {
                r = (int)(t * 255.0f + 0.5f);
                g = 0;
                b = 255;
                break;
            }
            case 5: {
                r = 255;
                g = 0;
                b = (int)(q * 255.0f + 0.5f);
            }
        }
        return 0xFF000000 | r << 16 | g << 8 | b;
    }
}

