/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import gollorum.signpost.Signpost;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public record PlayerHandle(UUID id) {
    public static final PlayerHandle Invalid = new PlayerHandle((Entity)((LivingEntity)null));
    public static final Codec<PlayerHandle> WRAPPED_CODEC = RecordCodecBuilder.create(i -> i.group((App)UUIDUtil.CODEC.fieldOf("Id").forGetter(PlayerHandle::id)).apply((Applicative)i, PlayerHandle::new));
    public static final Codec<PlayerHandle> DIRECT_CODEC = UUIDUtil.CODEC.xmap(PlayerHandle::new, PlayerHandle::id);
    public static final StreamCodec<ByteBuf, PlayerHandle> STREAM_CODEC = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, PlayerHandle::id, PlayerHandle::new);

    public PlayerHandle(Entity player) {
        this(player == null ? Util.NIL_UUID : player.getUUID());
    }

    public static PlayerHandle from(Entity player) {
        return new PlayerHandle(player);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlayerHandle that = (PlayerHandle)o;
        return Objects.equals(this.id, that.id);
    }

    @Override
    public int hashCode() {
        return this.id.hashCode();
    }

    public ServerPlayer asEntity() {
        return Signpost.getServerInstance().getPlayerList().getPlayer(this.id);
    }
}

