/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost;

import gollorum.signpost.Signpost;
import gollorum.signpost.WaystoneLibrary;
import gollorum.signpost.compat.Compat;
import gollorum.signpost.compat.ExternalWaystoneLibrary;
import gollorum.signpost.config.Config;
import gollorum.signpost.minecraft.block.tiles.PostTile;
import gollorum.signpost.minecraft.loot.LootEntries;
import gollorum.signpost.minecraft.rendering.PostRenderer;
import gollorum.signpost.minecraft.worldgen.JigsawDeserializers;
import gollorum.signpost.networking.ForgePacketHandler;
import gollorum.signpost.networking.PacketHandler;
import gollorum.signpost.registry.BlockRegistry;
import gollorum.signpost.registry.CreativeModeTabRegistry;
import gollorum.signpost.registry.DataComponentsRegistry;
import gollorum.signpost.registry.ItemRegistry;
import gollorum.signpost.registry.LootItemConditionRegistry;
import gollorum.signpost.registry.MiscRegistry;
import gollorum.signpost.registry.RecipeRegistry;
import gollorum.signpost.registry.TileEntityRegistry;
import gollorum.signpost.registry.WaystoneDiscoveryEventListener;
import gollorum.signpost.utils.Delay;
import gollorum.signpost.utils.IDelay;
import gollorum.signpost.worldgen.Villages;
import java.lang.invoke.MethodHandles;
import java.util.function.Consumer;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElementType;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryType;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.eventbus.api.bus.BusGroup;
import net.minecraftforge.eventbus.api.listener.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.RegisterEvent;

@Mod(value="signpost")
public class SignpostForge {
    private final Consumer<MinecraftServer> serverSetter = Signpost.init(Config.INSTANCE, (IDelay)Delay.INSTANCE);

    public SignpostForge(FMLJavaModLoadingContext context) {
        BusGroup forgeBus = BusGroup.DEFAULT;
        BusGroup modBus = context.getModBusGroup();
        ModBusEvents.register(modBus);
        forgeBus.register(MethodHandles.lookup(), (Object)new ForgeEvents());
        BlockRegistry.register(modBus);
        ItemRegistry.register(modBus);
        DataComponentsRegistry.register(modBus);
        RecipeRegistry.register(modBus);
        TileEntityRegistry.register(modBus);
        CreativeModeTabRegistry.register(modBus);
        WaystoneDiscoveryEventListener.register(forgeBus);
        forgeBus.register(MethodHandles.lookup(), (Object)Delay.INSTANCE);
        Config.INSTANCE.register((ModLoadingContext)context);
        LootItemConditionRegistry.register(modBus);
        MiscRegistry.register(modBus);
        Compat.register();
    }

    private static class ModBusEvents {
        private ModBusEvents() {
        }

        public static void register(BusGroup busGroup) {
            FMLCommonSetupEvent.getBus((BusGroup)busGroup).addListener(ModBusEvents::setup);
            EntityRenderersEvent.RegisterRenderers.BUS.addListener(ModBusEvents::registerEntityRenderers);
            RegisterEvent.getBus((BusGroup)busGroup).addListener(ModBusEvents::registerStuff);
        }

        public static void setup(FMLCommonSetupEvent event) {
            ForgePacketHandler.initialize();
            ExternalWaystoneLibrary.initialize();
        }

        public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
            event.registerBlockEntityRenderer(PostTile.getBlockEntityType(), PostRenderer::new);
        }

        public static void registerStuff(RegisterEvent event) {
            JigsawDeserializers.register((ResourceLocation loc, StructurePoolElementType<?> elem) -> event.register(Registries.STRUCTURE_POOL_ELEMENT, loc, () -> elem));
            LootEntries.register((ResourceLocation loc, LootPoolEntryType elem) -> event.register(Registries.LOOT_POOL_ENTRY_TYPE, loc, () -> elem));
        }
    }

    private class ForgeEvents {
        private ForgeEvents() {
        }

        @SubscribeEvent
        public void serverAboutToStart(ServerAboutToStartEvent e) {
            SignpostForge.this.serverSetter.accept(e.getServer());
            Villages.instance.initialize((RegistryAccess)e.getServer().registryAccess());
            new WaystoneDiscoveryEventListener().initialize();
        }

        @SubscribeEvent
        public void joinServer(PlayerEvent.PlayerLoggedInEvent e) {
            if (!e.getEntity().level().isClientSide() && Signpost.getServerInstance().isDedicatedServer()) {
                PacketHandler.getInstance().sendToPlayer((ServerPlayer)e.getEntity(), JoinServerEvent.Package.INSTANCE);
            }
        }

        @SubscribeEvent
        public void onWorldLoad(LevelEvent.Load event) {
            LevelAccessor levelAccessor = event.getLevel();
            if (levelAccessor instanceof ServerLevel) {
                ServerLevel world = (ServerLevel)levelAccessor;
                if (((ServerLevel)event.getLevel()).dimension().equals((Object)Level.OVERWORLD)) {
                    WaystoneLibrary.initializeServer(world);
                }
            }
        }

        @SubscribeEvent
        public void onServerStopped(ServerStoppedEvent event) {
            SignpostForge.this.serverSetter.accept(null);
        }
    }

    public static final class JoinServerEvent
    implements PacketHandler.Event<Package> {
        @Override
        public StreamCodec<RegistryFriendlyByteBuf, Package> codec() {
            return Package.CODEC;
        }

        @Override
        public Class<Package> getMessageClass() {
            return Package.class;
        }

        @Override
        public void handle(Package message, PacketHandler.Context context) {
            WaystoneLibrary.initializeClient();
        }

        public static final class Package {
            public static final Package INSTANCE = new Package();
            public static final StreamCodec<RegistryFriendlyByteBuf, Package> CODEC = StreamCodec.unit((Object)INSTANCE);
        }
    }
}

