/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.blockpartdata.types;

import gollorum.signpost.PlayerHandle;
import gollorum.signpost.Signpost;
import gollorum.signpost.blockpartdata.types.SignBlockPart;
import gollorum.signpost.blockpartdata.types.WaystoneBlockPart;
import gollorum.signpost.interactions.Interactable;
import gollorum.signpost.interactions.InteractionInfo;
import gollorum.signpost.minecraft.block.PostBlock;
import gollorum.signpost.minecraft.block.WaystoneBlock;
import gollorum.signpost.minecraft.gui.PaintPostGui;
import gollorum.signpost.minecraft.gui.RequestWaystoneGui;
import gollorum.signpost.minecraft.gui.SignGui;
import gollorum.signpost.minecraft.items.Brush;
import gollorum.signpost.minecraft.utils.CoordinatesUtil;
import gollorum.signpost.minecraft.utils.SideUtils;
import gollorum.signpost.minecraft.utils.Texture;
import gollorum.signpost.networking.PacketHandler;
import gollorum.signpost.security.WithOwner;
import gollorum.signpost.utils.BlockPart;
import gollorum.signpost.utils.BlockPartInstance;
import gollorum.signpost.utils.BlockPartMetadata;
import gollorum.signpost.utils.WorldLocation;
import gollorum.signpost.utils.math.geometry.AABB;
import gollorum.signpost.utils.math.geometry.Intersectable;
import gollorum.signpost.utils.math.geometry.Ray;
import gollorum.signpost.utils.math.geometry.Vector3;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BrushItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class PostBlockPart
implements BlockPart<PostBlockPart> {
    private static final int maxSignCount = 10;
    private static final AABB BOUNDS = new AABB(new Vector3(-2.0f, -8.0f, -2.0f), new Vector3(2.0f, 8.0f, 2.0f)).map(CoordinatesUtil::voxelToLocal);
    public static final BlockPartMetadata<PostBlockPart> METADATA = new BlockPartMetadata<PostBlockPart>("Post", version -> Texture.codec(version).fieldOf("texture").xmap(PostBlockPart::new, PostBlockPart::getTexture), Texture.STREAM_CODEC.mapStream(it -> it).map(PostBlockPart::new, PostBlockPart::getTexture), PostBlockPart.class);
    private Texture texture;

    public PostBlockPart(Texture texture) {
        this.setTexture(texture);
    }

    public void setTexture(Texture texture) {
        this.texture = texture;
    }

    public Texture getTexture() {
        return this.texture;
    }

    @Override
    public Intersectable<Ray, Float> getIntersection() {
        return BOUNDS;
    }

    @Override
    public Interactable.InteractionResult interact(InteractionInfo info) {
        ItemStack heldItem = info.player.getItemInHand(info.hand);
        PlayerHandle playerHandle = PlayerHandle.from((Entity)info.player);
        if (PostBlockPart.isValidSign(heldItem, (HolderLookup.Provider)info.player.registryAccess())) {
            return this.attachSign(info, heldItem);
        }
        if (PostBlockPart.isWaystone(heldItem)) {
            return this.attachWaystone(info, heldItem, playerHandle);
        }
        if (PostBlockPart.isBrush(heldItem)) {
            return this.paint(info);
        }
        return Interactable.InteractionResult.Ignored;
    }

    private Interactable.InteractionResult attachWaystone(InteractionInfo info, ItemStack heldItem, PlayerHandle playerHandle) {
        if (info.tile.getParts().stream().noneMatch(p -> p.blockPart() instanceof WaystoneBlockPart)) {
            if (!info.isRemote) {
                info.tile.addPart(new BlockPartInstance(new WaystoneBlockPart(playerHandle), Vector3.ZERO), new ItemStack((ItemLike)heldItem.getItem()), PlayerHandle.from((Entity)info.player));
                info.tile.setChanged();
                SideUtils.makePlayerPay(info.player, new ItemStack((ItemLike)WaystoneBlock.getInstance()));
                if (info.player instanceof ServerPlayer) {
                    PacketHandler.getInstance().sendToPlayer((ServerPlayer)info.player, new RequestWaystoneGui.Package(WorldLocation.from(info.tile.getBlockPos(), info.player.level()), Optional.empty()));
                } else {
                    Signpost.LOGGER.error("Tried to ask sender to open the waystone GUI, but it was a " + info.player.getClass().getName());
                }
            }
            return Interactable.InteractionResult.Accepted;
        }
        return Interactable.InteractionResult.Ignored;
    }

    private Interactable.InteractionResult attachSign(InteractionInfo info, ItemStack heldItem) {
        if (info.isRemote && info.tile.getParts().stream().filter(i -> i.blockPart() instanceof SignBlockPart).count() < 10L) {
            SignGui.display(info.tile, PostBlock.ModelType.from(info.player.getItemInHand(info.hand).getItem(), (HolderLookup.Provider)info.player.registryAccess()).get(), info.traceResult.hitPos, Optional.of(new ItemStack((ItemLike)heldItem.getItem(), 1)));
        }
        return Interactable.InteractionResult.Accepted;
    }

    private Interactable.InteractionResult paint(InteractionInfo info) {
        if (info.isRemote) {
            PaintPostGui.display(info.tile, this, info.traceResult.id);
        }
        return Interactable.InteractionResult.Accepted;
    }

    private static boolean isValidSign(ItemStack itemStack, HolderLookup.Provider registryAccess) {
        if (itemStack == null || itemStack.getCount() < 1) {
            return false;
        }
        Item item = itemStack.getItem();
        return PostBlock.ModelType.from(item, registryAccess).isPresent();
    }

    private static boolean isWaystone(ItemStack itemStack) {
        if (itemStack == null || itemStack.getCount() < 1) {
            return false;
        }
        Item item = itemStack.getItem();
        return item.equals(WaystoneBlock.getInstance().asItem());
    }

    private static boolean isBrush(ItemStack itemStack) {
        if (itemStack == null || itemStack.getCount() < 1) {
            return false;
        }
        Item item = itemStack.getItem();
        return item instanceof Brush || item instanceof BrushItem;
    }

    @Override
    public BlockPartMetadata<PostBlockPart> getMeta() {
        return METADATA;
    }

    @Override
    public boolean hasThePermissionToEdit(WithOwner owner, Player player) {
        return true;
    }

    @Override
    public Collection<ItemStack> getDrops() {
        return Collections.emptySet();
    }

    @Override
    public Collection<Texture> getAllTextures() {
        return Collections.singleton(this.getTexture());
    }
}

