/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.blockpartdata.types;

import gollorum.signpost.PlayerHandle;
import gollorum.signpost.Signpost;
import gollorum.signpost.WaystoneHandle;
import gollorum.signpost.WaystoneLibrary;
import gollorum.signpost.events.WaystoneUpdatedEvent;
import gollorum.signpost.interactions.Interactable;
import gollorum.signpost.interactions.InteractionInfo;
import gollorum.signpost.minecraft.block.WaystoneBlock;
import gollorum.signpost.minecraft.block.tiles.PostTile;
import gollorum.signpost.minecraft.gui.utils.TextureResource;
import gollorum.signpost.minecraft.utils.CoordinatesUtil;
import gollorum.signpost.minecraft.utils.Texture;
import gollorum.signpost.security.WithOwner;
import gollorum.signpost.utils.BlockPart;
import gollorum.signpost.utils.BlockPartMetadata;
import gollorum.signpost.utils.EventDispatcher;
import gollorum.signpost.utils.IDelay;
import gollorum.signpost.utils.WaystoneData;
import gollorum.signpost.utils.WorldLocation;
import gollorum.signpost.utils.math.geometry.AABB;
import gollorum.signpost.utils.math.geometry.Intersectable;
import gollorum.signpost.utils.math.geometry.Ray;
import gollorum.signpost.utils.math.geometry.Vector3;
import gollorum.signpost.utils.serialization.OptionalSerializerV1;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class WaystoneBlockPart
implements BlockPart<WaystoneBlockPart>,
WithOwner.OfWaystone {
    private Optional<PlayerHandle> owner;
    private Optional<WaystoneHandle.Vanilla> handle = Optional.empty();
    private Optional<String> name = Optional.empty();
    private static final AABB BOUNDS = new AABB(new Vector3(-3.0f, -8.0f, -3.0f), new Vector3(3.0f, -2.0f, 3.0f)).map(CoordinatesUtil::voxelToLocal);
    public static final BlockPartMetadata<WaystoneBlockPart> METADATA = new BlockPartMetadata<WaystoneBlockPart>("Waystone", version -> (version < 2 ? OptionalSerializerV1.of(PlayerHandle.WRAPPED_CODEC).fieldOf("owner") : PlayerHandle.DIRECT_CODEC.optionalFieldOf("owner")).xmap(WaystoneBlockPart::new, w -> w.owner), ByteBufCodecs.optional(PlayerHandle.STREAM_CODEC).map(WaystoneBlockPart::new, w -> w.owner).mapStream(it -> it), WaystoneBlockPart.class);
    private EventDispatcher.Listener<WaystoneUpdatedEvent> updateListener;

    public Optional<WaystoneHandle.Vanilla> getHandle() {
        return this.handle;
    }

    public Optional<String> getName() {
        return this.name;
    }

    public WaystoneBlockPart(Optional<PlayerHandle> owner) {
        this.owner = owner;
    }

    public WaystoneBlockPart(PlayerHandle owner) {
        this.owner = Optional.of(owner);
    }

    public void initialize(Level level, BlockPos position) {
        if (this.updateListener != null) {
            return;
        }
        WorldLocation location = WorldLocation.from(position, level);
        this.updateListener = event -> {
            if (location.equals(event.location.block())) {
                this.name = Optional.of(event.name);
                this.handle = Optional.of(event.handle);
            }
            return false;
        };
        IDelay.forFrames(10, level.isClientSide(), () -> {
            WaystoneLibrary.getInstance().requestWaystoneAt(location, data -> {
                this.handle = data.map(WaystoneData::handle);
                this.name = data.map(WaystoneData::name);
            }, level.isClientSide());
            WaystoneLibrary.getInstance().updateEventDispatcher.addListener(this.updateListener);
        });
    }

    @Override
    public void attachTo(PostTile tile) {
        this.initialize(tile.getLevel(), tile.getBlockPos());
    }

    @Override
    public Intersectable<Ray, Float> getIntersection() {
        return BOUNDS;
    }

    @Override
    public Interactable.InteractionResult interact(InteractionInfo info) {
        WaystoneBlock.onRightClick(info.player.level(), info.tile.getBlockPos(), info.player);
        return Interactable.InteractionResult.Accepted;
    }

    @Override
    public BlockPartMetadata<WaystoneBlockPart> getMeta() {
        return METADATA;
    }

    @Override
    public boolean hasThePermissionToEdit(WithOwner tile, Player player) {
        return true;
    }

    @Override
    public Collection<ItemStack> getDrops() {
        return Collections.singleton(new ItemStack((ItemLike)WaystoneBlock.getInstance().asItem()));
    }

    @Override
    public void removeFrom(PostTile tile) {
        if (tile.hasLevel() && !tile.getLevel().isClientSide()) {
            Optional<WorldLocation> location = WorldLocation.from(tile);
            if (location.isPresent()) {
                WaystoneLibrary.getInstance().removeAt(location.get(), PlayerHandle.Invalid);
            } else {
                Signpost.LOGGER.error("Waystone tile at {} was removed but world was null. This means that the waystone has not been cleaned up correctly.", (Object)tile.getBlockPos());
            }
        }
        WaystoneLibrary.getInstance().updateEventDispatcher.removeListener(this.updateListener);
    }

    @Override
    public Optional<PlayerHandle> getWaystoneOwner() {
        return this.owner;
    }

    @Override
    public void setWaystoneOwner(Optional<PlayerHandle> owner) {
        this.owner = owner;
    }

    @Override
    public Collection<Texture> getAllTextures() {
        return Collections.singleton(TextureResource.waystoneTextureLocation);
    }
}

