/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.blockpartdata.types.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import gollorum.signpost.blockpartdata.Overlay;
import gollorum.signpost.blockpartdata.types.BlockPartRenderer;
import gollorum.signpost.blockpartdata.types.SignBlockPart;
import gollorum.signpost.minecraft.config.IConfig;
import gollorum.signpost.minecraft.models.modelGeneration.QuadModel;
import gollorum.signpost.minecraft.rendering.RenderingUtil;
import gollorum.signpost.minecraft.rendering.TexturedModel;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.resources.model.MaterialSet;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import org.joml.AxisAngle4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public abstract class SignRenderer<T extends SignBlockPart<T>>
extends BlockPartRenderer<T> {
    protected abstract QuadModel makeMainModel(T var1);

    protected abstract QuadModel makeSecondaryModel(T var1);

    protected abstract QuadModel makeBakedOverlayModel(T var1, Overlay var2);

    @Override
    public void render(T sign, Level level, BlockPos pos, PoseStack blockToView, SubmitNodeCollector nodeCollector, MaterialSet materials, int combinedLights, int combinedOverlay, Function<ResourceLocation, RenderType> renderTypeFactory, ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        if (((SignBlockPart)sign).isMarkedForGeneration() && !IConfig.IServer.getInstance().worldGen().debugMode()) {
            return;
        }
        RenderingUtil.wrapInMatrixEntry(blockToView, () -> {
            Quaternionf rotation = new Quaternionf(new AxisAngle4f(sign.getAngle().get().radians(), (Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f)));
            blockToView.mulPose((Quaternionfc)rotation);
            RenderingUtil.wrapInMatrixEntry(blockToView, () -> {
                blockToView.mulPose((Quaternionfc)new Quaternionf(new AxisAngle4f((float)Math.PI, (Vector3fc)(sign.isFlipped() ? new Vector3f(0.0f, 0.0f, 1.0f) : new Vector3f(1.0f, 0.0f, 0.0f)))));
                this.renderText(sign, blockToView, Minecraft.getInstance().font, nodeCollector, combinedLights);
            });
            RenderingUtil.render(blockToView, new TexturedModel(this.makeMainModel(sign), sign.getMainTexture().toMaterial(), sign.getMainTexture().tint().map(t -> t.getColorAt((BlockAndTintGetter)level, pos)).orElse(-1)), nodeCollector, materials, combinedLights, combinedOverlay, renderTypeFactory, crumblingOverlay);
            RenderingUtil.render(blockToView, new TexturedModel(this.makeSecondaryModel(sign), sign.getSecondaryTexture().toMaterial(), sign.getSecondaryTexture().tint().map(t -> t.getColorAt((BlockAndTintGetter)level, pos)).orElse(-1)), nodeCollector, materials, combinedLights, combinedOverlay, renderTypeFactory, crumblingOverlay);
            sign.getOverlay().ifPresent(o -> RenderingUtil.render(blockToView, new TexturedModel(this.makeBakedOverlayModel(sign, (Overlay)o), o.materialFor(sign.getClass()), o.tint.map(t -> t.getColorAt((BlockAndTintGetter)level, pos)).orElse(-1)), nodeCollector, materials, combinedLights, combinedOverlay, renderTypeFactory, crumblingOverlay));
        });
    }

    protected abstract void renderText(T var1, PoseStack var2, Font var3, SubmitNodeCollector var4, int var5);
}

