/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.compat;

import com.google.common.collect.Lists;
import com.mojang.serialization.MapCodec;
import gollorum.signpost.Signpost;
import gollorum.signpost.WaystoneHandle;
import gollorum.signpost.compat.ExternalWaystone;
import gollorum.signpost.compat.ExternalWaystoneLibrary;
import gollorum.signpost.minecraft.utils.TileEntityUtils;
import gollorum.signpost.networking.PacketHandler;
import gollorum.signpost.utils.EventDispatcher;
import gollorum.signpost.utils.WaystoneLocationData;
import gollorum.signpost.utils.WorldLocation;
import gollorum.signpost.utils.math.geometry.Vector3;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.blay09.mods.waystones.api.Waystone;
import net.blay09.mods.waystones.api.WaystoneVisibility;
import net.blay09.mods.waystones.api.WaystonesAPI;
import net.blay09.mods.waystones.block.WaystoneBlock;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.blay09.mods.waystones.core.WaystoneImpl;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public final class WaystonesAdapter
implements ExternalWaystoneLibrary.Adapter {
    private static WaystonesAdapter instance;
    private final EventDispatcher.Impl.WithPublicDispatch<Collection<ExternalWaystone>> onReply = new EventDispatcher.Impl.WithPublicDispatch();
    private static final String notActivatedKey = "gui.waystones.inventory.no_waystones_activated";

    private WaystonesAdapter() {
    }

    public static void register() {
        instance = new WaystonesAdapter();
        ExternalWaystoneLibrary.onInitialize().addListener(ex -> ex.registerAdapter(instance));
    }

    public static Map<ResourceLocation, PacketHandler.Event<?>> getEvents() {
        HashMap map = new HashMap();
        map.put(ResourceLocation.fromNamespaceAndPath((String)"signpost", (String)"waystones_adapter_request"), RequestEvent.INSTANCE);
        map.put(ResourceLocation.fromNamespaceAndPath((String)"signpost", (String)"waystones_adapter_reply"), new ReplyEvent());
        return map;
    }

    @Override
    public String typeTag() {
        return "waystones";
    }

    @Override
    public void requestKnownWaystones(Consumer<Collection<ExternalWaystone>> consumer) {
        this.onReply.addListener(consumer);
        PacketHandler.getInstance().sendToServer(RequestEvent.INSTANCE);
    }

    @Override
    public Optional<ExternalWaystone> getData(WaystoneHandle handle) {
        return handle instanceof Handle ? this.getData((Handle)handle).map(w -> w) : Optional.empty();
    }

    private Optional<WaystoneWaystone> getData(Handle handle) {
        return WaystonesAPI.getWaystone((MinecraftServer)Signpost.getServerInstance(), (UUID)handle.id).map(WaystoneWaystone::new);
    }

    @Override
    public Optional<Component> cannotTeleportToBecause(Player player, WaystoneHandle handle) {
        if (!(handle instanceof Handle)) {
            return Optional.empty();
        }
        return this.getData((Handle)handle).flatMap(waystone -> waystone.wrapped.getVisibility() == WaystoneVisibility.GLOBAL || PlayerWaystoneManager.isWaystoneActivated((Player)player, (Waystone)waystone.wrapped) ? Optional.empty() : Optional.of(Component.translatable((String)notActivatedKey)));
    }

    @Override
    public MapCodec<? extends WaystoneHandle> getCodec() {
        return Handle.CODEC;
    }

    @Override
    public StreamCodec<ByteBuf, ? extends WaystoneHandle> getStreamCodec() {
        return Handle.STREAM_CODEC;
    }

    public static final class RequestEvent
    implements PacketHandler.Event.ForServer<RequestEvent> {
        public static final RequestEvent INSTANCE = new RequestEvent();

        @Override
        public StreamCodec<RegistryFriendlyByteBuf, RequestEvent> codec() {
            return StreamCodec.unit((Object)INSTANCE);
        }

        @Override
        public Class<RequestEvent> getMessageClass() {
            return RequestEvent.class;
        }

        @Override
        public void handle(RequestEvent message, PacketHandler.Context.Server context) {
            PacketHandler.getInstance().sendToPlayer(context.sender(), new ReplyEvent.Packet(PlayerWaystoneManager.getActivatedWaystones((Player)context.sender()).stream().map(WaystoneWaystone::new).collect(Collectors.toList())));
        }
    }

    public static final class ReplyEvent
    implements PacketHandler.Event<Packet> {
        @Override
        public StreamCodec<RegistryFriendlyByteBuf, Packet> codec() {
            return Packet.STREAM_CODEC;
        }

        @Override
        public Class<Packet> getMessageClass() {
            return Packet.class;
        }

        @Override
        public void handle(Packet message, PacketHandler.Context context) {
            WaystonesAdapter.instance.onReply.dispatch(new ArrayList<WaystoneWaystone>(message.waystones), true);
        }

        public record Packet(Collection<WaystoneWaystone> waystones) {
            public static final StreamCodec<RegistryFriendlyByteBuf, Packet> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.collection(ArrayList::new, (StreamCodec)WaystoneImpl.STREAM_CODEC.map(WaystoneWaystone::new, WaystoneWaystone::wrapped)), Packet::waystones, Packet::new);
        }
    }

    public record Handle(UUID id) implements ExternalWaystone.Handle
    {
        public static final MapCodec<Handle> CODEC = UUIDUtil.CODEC.xmap(Handle::new, Handle::id).fieldOf("id");
        public static final StreamCodec<ByteBuf, Handle> STREAM_CODEC = UUIDUtil.STREAM_CODEC.map(Handle::new, Handle::id);

        @Override
        public String typeTag() {
            return instance.typeTag();
        }

        @Override
        public String modMark() {
            return "(Waystones)";
        }

        @Override
        public String noTeleportLangKey() {
            return "signpost.no_teleport_waystones_mod";
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Handle that = (Handle)o;
            return Objects.equals(this.id, that.id);
        }

        @Override
        public int hashCode() {
            return this.id.hashCode();
        }
    }

    public record WaystoneWaystone(Waystone wrapped) implements ExternalWaystone
    {
        @Override
        public String name() {
            return this.wrapped.getName().getString();
        }

        @Override
        public WaystoneLocationData loc() {
            WorldLocation blockPos = WorldLocation.from(this.wrapped.getPos(), this.wrapped.getDimension().location());
            return new WaystoneLocationData(blockPos, Vector3.fromBlockPos(blockPos.blockPos().relative(this.spawnInDirection(blockPos))));
        }

        private Direction spawnInDirection(WorldLocation blockPos) {
            BlockState state;
            Level world = TileEntityUtils.toWorld(blockPos.world(), false).orElse(null);
            BlockState blockState = state = world != null ? world.getBlockState(blockPos.blockPos()) : null;
            if (state == null || !state.hasProperty((Property)WaystoneBlock.FACING)) {
                return Direction.NORTH;
            }
            Direction direction = (Direction)state.getValue((Property)WaystoneBlock.FACING);
            ArrayList directionCandidates = Lists.newArrayList((Object[])new Direction[]{direction, Direction.EAST, Direction.WEST, Direction.SOUTH, Direction.NORTH});
            for (Direction candidate : directionCandidates) {
                BlockPos offsetPos = blockPos.blockPos().relative(candidate);
                BlockPos offsetPosUp = offsetPos.above();
                if (world.getBlockState(offsetPos).isSuffocating((BlockGetter)world, offsetPos) || world.getBlockState(offsetPosUp).isSuffocating((BlockGetter)world, offsetPosUp)) continue;
                return candidate;
            }
            return direction;
        }

        @Override
        public ExternalWaystone.Handle handle() {
            return new Handle(this.wrapped.getWaystoneUid());
        }
    }
}

