/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.config;

import gollorum.signpost.minecraft.config.ITeleportConfig;
import net.minecraftforge.common.ForgeConfigSpec;

public class TeleportConfig
implements ITeleportConfig {
    public final ForgeConfigSpec.BooleanValue enableTeleport;
    public final ForgeConfigSpec.IntValue maximumDistance;
    public final ForgeConfigSpec.BooleanValue enforceDiscovery;
    public final ForgeConfigSpec.BooleanValue enableAcrossDimensions;
    public final ForgeConfigSpec.BooleanValue allowVehicle;
    public final ForgeConfigSpec.BooleanValue allowLead;
    public final ForgeConfigSpec.ConfigValue<String> costItem;
    public final ForgeConfigSpec.ConfigValue<Integer> constantPayment;
    public final ForgeConfigSpec.ConfigValue<Integer> distancePerPayment;

    @Override
    public int distancePerPayment() {
        return (Integer)this.distancePerPayment.get();
    }

    @Override
    public int constantPayment() {
        return (Integer)this.constantPayment.get();
    }

    @Override
    public String costItem() {
        return (String)this.costItem.get();
    }

    @Override
    public boolean allowLead() {
        return (Boolean)this.allowLead.get();
    }

    @Override
    public boolean allowVehicle() {
        return (Boolean)this.allowVehicle.get();
    }

    @Override
    public boolean enableAcrossDimensions() {
        return (Boolean)this.enableAcrossDimensions.get();
    }

    @Override
    public boolean enforceDiscovery() {
        return (Boolean)this.enforceDiscovery.get();
    }

    @Override
    public int maximumDistance() {
        return (Integer)this.maximumDistance.get();
    }

    @Override
    public boolean enableTeleport() {
        return (Boolean)this.enableTeleport.get();
    }

    public TeleportConfig(ForgeConfigSpec.Builder builder) {
        this.enableTeleport = builder.define("enable", true);
        this.maximumDistance = builder.comment("-1 = infinite").defineInRange("max_distance", -1, -1, Integer.MAX_VALUE);
        this.enforceDiscovery = builder.define("enforce_discovery", true);
        this.enableAcrossDimensions = builder.define("enable_across_dimensions", true);
        this.allowVehicle = builder.define("teleport_vehicle", true);
        this.allowLead = builder.define("teleport_leaded_mobs", true);
        builder.push("cost");
        this.costItem = builder.comment(new String[]{"If \"item\" is a valid item (e.g. minecraft:ender_pearl), players will have to pay an amount of", "constant_payment + distance / distance_per_payment", "of this item when using a sign post to teleport.", "A negative distance_per_payment will set the second part of the sum to 0."}).define("item", (Object)"");
        this.constantPayment = builder.define("constant_payment", (Object)1);
        this.distancePerPayment = builder.define("distance_per_payment", (Object)-1);
        builder.pop();
    }
}

