/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.data;

import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import gollorum.signpost.Signpost;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import org.jetbrains.annotations.NotNull;

public abstract class StructurePoolElementProvider
implements DataProvider {
    private final PackOutput.PathProvider pathProvider;

    public StructurePoolElementProvider(PackOutput output) {
        this.pathProvider = output.createPathProvider(PackOutput.Target.DATA_PACK, "structures");
    }

    protected abstract void buildElements(BiConsumer<StructurePoolElement, ResourceLocation> var1);

    @NotNull
    public CompletableFuture<?> run(CachedOutput output) {
        HashSet set = Sets.newHashSet();
        ArrayList list = new ArrayList();
        this.buildElements((elem, id) -> {
            if (!set.add(id)) {
                throw new IllegalStateException("Duplicate recipe " + String.valueOf(id));
            }
            Codec codec = (Codec)elem.getType().codec();
            DataResult serializationResult = codec.encodeStart((DynamicOps)JsonOps.INSTANCE, elem);
            Optional option = serializationResult.resultOrPartial(str -> Signpost.LOGGER.error("Failed to serialize structure pool element: " + str));
            option.ifPresent(t -> list.add(DataProvider.saveStable((CachedOutput)output, (JsonElement)t, (Path)this.pathProvider.json(id))));
        });
        return CompletableFuture.allOf((CompletableFuture[])list.toArray(CompletableFuture[]::new));
    }
}

