/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.events;

import gollorum.signpost.WaystoneHandle;
import gollorum.signpost.events.WaystoneAddedEvent;
import gollorum.signpost.events.WaystoneAddedOrRenamedEvent;
import gollorum.signpost.events.WaystoneMovedEvent;
import gollorum.signpost.events.WaystoneRemovedEvent;
import gollorum.signpost.events.WaystoneRenamedEvent;
import gollorum.signpost.utils.WaystoneLocationData;
import gollorum.signpost.utils.WorldLocation;
import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public abstract class WaystoneUpdatedEvent {
    public final WaystoneLocationData location;
    public final String name;
    public final WaystoneHandle.Vanilla handle;

    public static WaystoneUpdatedEvent fromUpdated(WaystoneLocationData location, String name, Optional<String> oldName, boolean isLocked, WaystoneHandle.Vanilla handle) {
        return oldName.map(n -> new WaystoneRenamedEvent(location, name, (String)n, isLocked, handle)).orElse(new WaystoneAddedEvent(location, name, isLocked, handle));
    }

    public static WaystoneUpdatedEvent fromUpdated(WaystoneLocationData location, String name, boolean isLocked, WaystoneHandle.Vanilla handle) {
        return new WaystoneAddedEvent(location, name, isLocked, handle);
    }

    public WaystoneUpdatedEvent(WaystoneLocationData location, String name, WaystoneHandle.Vanilla handle) {
        this.location = location.withoutExplicitLevel();
        this.name = name;
        this.handle = handle;
    }

    public abstract Type getType();

    public static class Serializer
    implements StreamCodec<FriendlyByteBuf, WaystoneUpdatedEvent> {
        public static final Serializer INSTANCE = new Serializer();

        private Serializer() {
        }

        public void encode(FriendlyByteBuf buffer, WaystoneUpdatedEvent event) {
            buffer.writeEnum((Enum)event.getType());
            WaystoneLocationData.STREAM_CODEC.encode((Object)buffer, (Object)event.location);
            ByteBufCodecs.STRING_UTF8.encode((Object)buffer, (Object)event.name);
            WaystoneHandle.Vanilla.STREAM_CODEC.encode((Object)buffer, (Object)event.handle);
            if (event instanceof WaystoneRenamedEvent) {
                ByteBufCodecs.STRING_UTF8.encode((Object)buffer, (Object)((WaystoneRenamedEvent)event).oldName);
            } else if (event instanceof WaystoneMovedEvent) {
                WorldLocation.STREAM_CODEC.encode((Object)buffer, (Object)((WaystoneMovedEvent)event).newLocation);
            }
            if (event instanceof WaystoneAddedOrRenamedEvent) {
                buffer.writeBoolean(((WaystoneAddedOrRenamedEvent)event).isLocked);
            }
        }

        public WaystoneUpdatedEvent decode(FriendlyByteBuf buffer) {
            Type type = (Type)buffer.readEnum(Type.class);
            WaystoneLocationData location = (WaystoneLocationData)WaystoneLocationData.STREAM_CODEC.decode((Object)buffer);
            String name = (String)ByteBufCodecs.STRING_UTF8.decode((Object)buffer);
            WaystoneHandle.Vanilla handle = (WaystoneHandle.Vanilla)WaystoneHandle.Vanilla.STREAM_CODEC.decode((Object)buffer);
            return switch (type.ordinal()) {
                case 0 -> new WaystoneAddedEvent(location, name, buffer.readBoolean(), handle);
                case 1 -> new WaystoneRemovedEvent(location, name, handle);
                case 2 -> new WaystoneRenamedEvent(location, name, (String)ByteBufCodecs.STRING_UTF8.decode((Object)buffer), buffer.readBoolean(), handle);
                case 3 -> new WaystoneMovedEvent(location, (WorldLocation)WorldLocation.STREAM_CODEC.decode((Object)buffer), name, handle);
                default -> throw new RuntimeException("Type " + String.valueOf((Object)type) + " is not supported");
            };
        }
    }

    public static enum Type {
        Added,
        Removed,
        Renamed,
        Moved;

    }
}

