/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import gollorum.signpost.minecraft.block.WaystoneBlock;
import gollorum.signpost.minecraft.block.tiles.WaystoneTile;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class ModelWaystone
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty Waterlogged = BlockStateProperties.WATERLOGGED;
    public static final EnumProperty<Direction> Facing = BlockStateProperties.HORIZONTAL_FACING;
    private static final String REGISTRY_NAME = "waystone_model";
    public static final List<Variant> variants = new ArrayList<Variant>();
    public static Variant simple_0 = new Variant("simple_0", "0", Shapes.box((double)0.25, (double)0.0, (double)0.25, (double)0.75, (double)0.5, (double)0.75), 1.0f);
    public static Variant simple_1 = new Variant("simple_1", "0", Shapes.box((double)0.25, (double)0.0, (double)0.25, (double)0.75, (double)0.5, (double)0.75), 1.0f);
    public static Variant simple_2 = new Variant("simple_2", "0", Shapes.box((double)0.3125, (double)0.0, (double)0.3125, (double)0.6875, (double)0.75, (double)0.6875), 0.0f);
    public static Variant detailed_0 = new Variant("detailed_0", "1", Shapes.box((double)0.25, (double)0.0, (double)0.25, (double)0.75, (double)0.5, (double)0.75), 2.0f);
    public static Variant detailed_1 = new Variant("detailed_1", "1", Shapes.box((double)0.25, (double)0.0, (double)0.25, (double)0.75, (double)0.75, (double)0.75), 0.0f);
    public static Variant aer = new Variant("aer", "2", Shapes.box((double)0.05f, (double)0.0, (double)0.05f, (double)0.95f, (double)0.6f, (double)0.95f), 0.0f);
    public static Variant dwarf = new Variant("dwarf", "2", Shapes.box((double)0.05f, (double)0.0, (double)0.05f, (double)0.95f, (double)0.4375, (double)0.95f), 2.0f);
    public static Variant ygnar = new Variant("ygnar", "2", Shapes.box((double)0.125, (double)0.0, (double)0.125, (double)0.875, (double)1.0, (double)0.875), 0.0f);
    public static final Variant generationMarker = simple_0;
    public final Variant variant;

    public ModelWaystone(Variant variant) {
        this(variant, BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).strength(1.5f, 6.0f).noOcclusion().isViewBlocking((x, y, z) -> false).requiresCorrectToolForDrops().setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"signpost", (String)variant.registryName))));
    }

    public ModelWaystone(Variant variant, BlockBehaviour.Properties properties) {
        super(properties);
        this.variant = variant;
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)Waterlogged, (Comparable)Boolean.valueOf(false))).setValue(Facing, (Comparable)Direction.NORTH));
    }

    protected InteractionResult useItemOn(ItemStack item, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        return this.use(world, pos, player);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        return this.use(level, pos, player);
    }

    public InteractionResult use(Level world, BlockPos pos, Player player) {
        WaystoneBlock.onRightClick(world, pos, player);
        return InteractionResult.CONSUME;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{Waterlogged}).add(new Property[]{Facing});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue(Facing, (Comparable)context.getHorizontalDirection());
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        if (!state.hasProperty(Facing)) {
            return state;
        }
        return (BlockState)state.setValue(Facing, (Comparable)rot.rotate((Direction)state.getValue(Facing)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        if (!state.hasProperty(Facing)) {
            return state;
        }
        return (BlockState)state.setValue(Facing, (Comparable)((Direction)state.getValue(Facing)).getOpposite());
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new WaystoneTile(pos, state);
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(world, pos, state, placer, stack);
        WaystoneBlock.registerOwnerAndRequestGui(world, pos, placer, stack);
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)Waterlogged) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public boolean propagatesSkylightDown(BlockState state) {
        return (Boolean)state.getValue((Property)Waterlogged) == false;
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return this.variant.shape;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public void destroy(LevelAccessor world, BlockPos pos, BlockState state) {
        super.destroy(world, pos, state);
        if (!world.isClientSide() && world instanceof Level) {
            WaystoneTile.onRemoved((ServerLevel)world, pos);
        }
    }

    protected ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state, boolean includeData) {
        ItemStack itemStack = super.getCloneItemStack(level, pos, state, includeData);
        if (includeData) {
            WaystoneBlock.fillClonedItemStack(itemStack, level, pos);
        }
        return itemStack;
    }

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return RecordCodecBuilder.mapCodec(builder -> builder.group((App)ModelWaystone.propertiesCodec(), (App)Codec.STRING.fieldOf("variant").forGetter(block -> ((ModelWaystone)block).variant.name)).apply((Applicative)builder, (properties, variantName) -> variants.stream().filter(v -> Objects.equals(v.name, variantName)).findAny().orElseThrow().createBlock(v -> new ModelWaystone((Variant)v, (BlockBehaviour.Properties)properties))));
    }

    static {
        variants.add(simple_0);
        variants.add(simple_1);
        variants.add(simple_2);
        variants.add(detailed_0);
        variants.add(detailed_1);
        variants.add(aer);
        variants.add(dwarf);
        variants.add(ygnar);
    }

    public static class Variant {
        public final String name;
        public final String registryName;
        public final String langPrefix;
        private ModelWaystone block = null;
        public final VoxelShape shape;
        public final float modelYOffset;

        public Variant(String name, String langPrefix, VoxelShape shape, float modelYOffset) {
            this.name = name;
            this.registryName = "waystone_model_" + name;
            this.langPrefix = langPrefix;
            this.shape = shape;
            this.modelYOffset = modelYOffset;
        }

        public ModelWaystone createBlock(Function<Variant, ModelWaystone> factory) {
            assert (this.block == null);
            this.block = factory.apply(this);
            return this.block;
        }

        public ModelWaystone getBlock() {
            assert (this.block != null);
            return this.block;
        }

        public boolean equals(Object o) {
            return this == o || o instanceof Variant && this.name.equals(((Variant)o).name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }
}

