/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.block;

import com.mojang.serialization.MapCodec;
import gollorum.signpost.PlayerHandle;
import gollorum.signpost.Signpost;
import gollorum.signpost.WaystoneHandle;
import gollorum.signpost.WaystoneLibrary;
import gollorum.signpost.minecraft.block.tiles.WaystoneTile;
import gollorum.signpost.minecraft.data.WaystoneHandleData;
import gollorum.signpost.minecraft.gui.RequestWaystoneGui;
import gollorum.signpost.minecraft.utils.TextComponents;
import gollorum.signpost.minecraft.utils.TileEntityUtils;
import gollorum.signpost.networking.PacketHandler;
import gollorum.signpost.security.WithOwner;
import gollorum.signpost.utils.IDelay;
import gollorum.signpost.utils.WaystoneData;
import gollorum.signpost.utils.WaystoneLocationData;
import gollorum.signpost.utils.WorldLocation;
import gollorum.signpost.utils.math.geometry.Vector3;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;

public class WaystoneBlock
extends BaseEntityBlock {
    public static final EnumProperty<Direction> FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final String REGISTRY_NAME = "waystone";
    private static WaystoneBlock instance = null;

    public static WaystoneBlock createInstance() {
        assert (instance == null);
        instance = new WaystoneBlock();
        return instance;
    }

    public static WaystoneBlock getInstance() {
        assert (instance != null);
        return instance;
    }

    private WaystoneBlock() {
        this(BlockBehaviour.Properties.of().setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"signpost", (String)REGISTRY_NAME))).mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.5f, 6.0f));
    }

    private WaystoneBlock(BlockBehaviour.Properties properties) {
        super(properties);
        instance = this;
    }

    public static void openGuiIfHasPermission(ServerPlayer player, WorldLocation worldLocation) {
        assert (Signpost.getServerType().isServer);
        Optional<WaystoneData> data = WaystoneLibrary.getInstance().getHandleByLocation(worldLocation).flatMap(WaystoneLibrary.getInstance()::getData);
        boolean wantsToOpenGui = data.isEmpty() || WaystoneLibrary.getInstance().isDiscovered(PlayerHandle.from((Entity)player), ((WaystoneData)data.get()).handle());
        boolean mayOpenGui = data.map(d -> d.hasThePermissionToEdit((Player)player)).orElse(true);
        if (wantsToOpenGui && mayOpenGui) {
            PacketHandler.getInstance().sendToPlayer(player, new RequestWaystoneGui.Package(worldLocation, data));
        } else {
            WaystoneBlock.discover(player, (WaystoneData)data.get());
        }
    }

    protected InteractionResult useItemOn(ItemStack p_316304_, BlockState p_316362_, Level level, BlockPos pos, Player player, InteractionHand p_316595_, BlockHitResult p_316140_) {
        WaystoneBlock.onRightClick(level, pos, player);
        return InteractionResult.CONSUME;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        WaystoneBlock.onRightClick(level, pos, player);
        return InteractionResult.CONSUME;
    }

    public static void onRightClick(Level world, BlockPos pos, Player player) {
        if (!world.isClientSide() && player instanceof ServerPlayer) {
            WaystoneBlock.openGuiIfHasPermission((ServerPlayer)player, WorldLocation.from(pos, world));
        }
    }

    private static void discover(ServerPlayer player, WaystoneData data) {
        if (WaystoneLibrary.getInstance().addDiscovered(new PlayerHandle(player.getUUID()), data.handle())) {
            player.sendSystemMessage((Component)Component.translatable((String)"signpost.discovered", (Object[])new Object[]{TextComponents.waystone(player, data.name())}));
        }
    }

    public static void discover(PlayerHandle player, WaystoneData data) {
        ServerPlayer playerEntity;
        assert (Signpost.getServerType().isServer);
        if (WaystoneLibrary.getInstance().addDiscovered(player, data.handle()) && (playerEntity = player.asEntity()) != null) {
            playerEntity.sendSystemMessage((Component)Component.translatable((String)"signpost.discovered", (Object[])new Object[]{TextComponents.waystone(playerEntity, data.name())}));
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)context.getHorizontalDirection());
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new WaystoneTile(pos, state);
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(world, pos, state, placer, stack);
        WaystoneBlock.registerOwnerAndRequestGui(world, pos, placer, stack);
    }

    public static void registerOwnerAndRequestGui(Level world, BlockPos pos, LivingEntity placer, ItemStack currentStack) {
        ItemStack stack = currentStack.copy();
        IDelay.forFrames(6, world.isClientSide(), () -> TileEntityUtils.delayUntilTileEntityExists((LevelAccessor)world, pos, WaystoneTile.getBlockEntityType(), t -> {
            boolean hasName = WaystoneBlock.registerOwnerAndSeeIfHasName(t, world, pos, placer, stack);
            if (!hasName && placer instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)placer;
                PacketHandler.getInstance().sendToPlayer(sp, new RequestWaystoneGui.Package(WorldLocation.from(pos, world), Optional.empty()));
            }
        }, 100, Optional.empty()));
    }

    public static boolean registerOwnerAndSeeIfHasName(BlockEntity tileEntity, Level world, BlockPos pos, LivingEntity placer, ItemStack stack) {
        if (tileEntity instanceof WithOwner.OfWaystone) {
            WithOwner.OfWaystone waystoneTile = (WithOwner.OfWaystone)tileEntity;
            waystoneTile.setWaystoneOwner(Optional.of(PlayerHandle.from((Entity)placer)));
        }
        if (placer instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)placer;
            WorldLocation worldLocation = WorldLocation.from(pos, world);
            boolean wasRegistered = WaystoneBlock.getCustomName(stack).map(name -> {
                WaystoneLocationData locationData = new WaystoneLocationData(worldLocation, Vector3.fromVec3d(placer.position()));
                WaystoneHandleData handleTag = (WaystoneHandleData)stack.get(WaystoneHandleData.TYPE);
                Optional<WaystoneHandle.Vanilla> handle = handleTag != null ? Optional.of(handleTag.handle()) : Optional.empty();
                return WaystoneLibrary.getInstance().tryAddNew((String)name, locationData, sp, handle);
            }).orElse(false);
            return wasRegistered;
        }
        return false;
    }

    private static Optional<String> getCustomName(ItemStack stack) {
        Component component = stack.getCustomName();
        if (component != null) {
            return Optional.of(component.getString());
        }
        return Optional.empty();
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public void destroy(LevelAccessor world, BlockPos pos, BlockState state) {
        super.destroy(world, pos, state);
        if (!world.isClientSide() && world instanceof Level) {
            WaystoneTile.onRemoved((ServerLevel)world, pos);
        }
    }

    protected ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state, boolean includeData) {
        ItemStack itemStack = super.getCloneItemStack(level, pos, state, includeData);
        if (includeData) {
            itemStack = WaystoneBlock.fillClonedItemStack(itemStack, level, pos);
        }
        return itemStack;
    }

    public static ItemStack fillClonedItemStack(ItemStack stack, LevelReader level, BlockPos pos) {
        BlockEntity untypedEntity = level.getBlockEntity(pos);
        if (untypedEntity instanceof WaystoneTile) {
            WaystoneTile tile = (WaystoneTile)untypedEntity;
            tile.getHandle().ifPresent(h -> stack.set(WaystoneHandleData.TYPE, (Object)new WaystoneHandleData((WaystoneHandle.Vanilla)h)));
            tile.getName().ifPresent(n -> stack.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)n)));
        }
        return stack;
    }

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return WaystoneBlock.simpleCodec(WaystoneBlock::new);
    }
}

