/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.block;

import com.mojang.serialization.MapCodec;
import gollorum.signpost.Signpost;
import gollorum.signpost.WaystoneLibrary;
import gollorum.signpost.minecraft.block.ModelWaystone;
import gollorum.signpost.minecraft.block.WaystoneBlock;
import gollorum.signpost.minecraft.block.tiles.WaystoneGeneratorEntity;
import gollorum.signpost.minecraft.config.IConfig;
import gollorum.signpost.minecraft.worldgen.VillageGenUtils;
import gollorum.signpost.utils.WaystoneLocationData;
import gollorum.signpost.utils.WorldLocation;
import gollorum.signpost.utils.math.geometry.Vector3;
import gollorum.signpost.worldgen.VillageNamesProvider;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;

public class WaystoneGeneratorBlock
extends BaseEntityBlock {
    public static final EnumProperty<Direction> Facing = BlockStateProperties.HORIZONTAL_FACING;
    public static final String REGISTRY_NAME = "waystone_generator";
    private static WaystoneGeneratorBlock instance = null;

    public static WaystoneGeneratorBlock getInstance() {
        if (instance == null) {
            instance = new WaystoneGeneratorBlock();
        }
        return instance;
    }

    private WaystoneGeneratorBlock() {
        super(BlockBehaviour.Properties.of().setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"signpost", (String)REGISTRY_NAME))).mapColor(MapColor.WOOD));
    }

    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new WaystoneGeneratorEntity(pos, state);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{Facing});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue(Facing, (Comparable)context.getHorizontalDirection());
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    protected InteractionResult useItemOn(ItemStack item, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        return this.use(state, world, pos);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        return this.use(state, level, pos);
    }

    public InteractionResult use(BlockState state, Level level, BlockPos pos) {
        if (level instanceof ServerLevel) {
            ServerLevel l = (ServerLevel)level;
            WaystoneGeneratorBlock.generate(state, pos, l, true);
        }
        return InteractionResult.CONSUME;
    }

    public static void generate(BlockState state, BlockPos pos, ServerLevel level, boolean manuallyPlaced) {
        if (!level.getBlockState(pos).is((Block)instance)) {
            return;
        }
        if (!WaystoneGeneratorBlock.tryPlace(state, pos, level, manuallyPlaced)) {
            level.setBlock(pos, Blocks.AIR.defaultBlockState(), 18);
        }
    }

    private static boolean tryPlace(BlockState state, BlockPos pos, ServerLevel serverLevel, boolean manuallyPlaced) {
        BlockPos villageLocation = VillageGenUtils.getVillageLocationFor(serverLevel, pos, manuallyPlaced ? 0 : 512);
        List<ModelWaystone> allowedWaystones = WaystoneGeneratorBlock.getAllowedWaystones();
        if (allowedWaystones.isEmpty()) {
            Signpost.LOGGER.warn("Tried to generate a waystone, but the list of allowed waystones was empty.");
            return false;
        }
        Direction facing = (Direction)state.getValue(Facing);
        ModelWaystone waystone = WaystoneGeneratorBlock.getWaystoneType(new Random(serverLevel.getSeed() ^ pos.asLong()), allowedWaystones);
        Optional<String> optionalName = VillageNamesProvider.requestFor(pos, villageLocation, serverLevel, new Random(serverLevel.getSeed() ^ villageLocation.asLong()));
        if (optionalName.isEmpty()) {
            Signpost.LOGGER.warn("No name could be generated for waystone at " + String.valueOf(pos) + ".");
            return false;
        }
        String name = optionalName.get();
        boolean isWater = serverLevel.isWaterAt(pos.above());
        serverLevel.setBlock(pos, (BlockState)((BlockState)waystone.defaultBlockState().setValue(WaystoneBlock.FACING, (Comparable)facing)).setValue((Property)ModelWaystone.Waterlogged, (Comparable)Boolean.valueOf(isWater)), 18);
        WaystoneLibrary lib = WaystoneLibrary.getInstance();
        lib.update(name, WaystoneGeneratorBlock.locationDataFor(pos, serverLevel, facing), null, false);
        lib.data.villageWaystones.register(lib, name, villageLocation, serverLevel, pos);
        return true;
    }

    private static List<ModelWaystone> getAllowedWaystones() {
        return ModelWaystone.variants.stream().filter(v -> IConfig.IServer.getInstance().worldGen().allowedVillageWaystones().contains(v.name)).map(ModelWaystone.Variant::getBlock).collect(Collectors.toList());
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        if (!state.hasProperty(Facing)) {
            return state;
        }
        return (BlockState)state.setValue(Facing, (Comparable)rot.rotate((Direction)state.getValue(Facing)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        if (!state.hasProperty(Facing)) {
            return state;
        }
        return (BlockState)state.setValue(Facing, (Comparable)((Direction)state.getValue(Facing)).getOpposite());
    }

    private static WaystoneLocationData locationDataFor(BlockPos pos, ServerLevel world, Direction facing) {
        return new WaystoneLocationData(WorldLocation.from(pos, (Level)world.getLevel()), WaystoneGeneratorBlock.spawnPosFor(world, pos, facing));
    }

    private static Vector3 spawnPosFor(ServerLevel world, BlockPos waystonePos, Direction facing) {
        int offset;
        BlockPos spawnBlockPos = waystonePos.relative(facing, -2);
        int maxOffset = 10;
        for (offset = 0; WaystoneGeneratorBlock.isFree(world.getBlockState(spawnBlockPos), world, spawnBlockPos) && offset <= maxOffset; ++offset) {
            spawnBlockPos = spawnBlockPos.below();
        }
        for (offset = 0; !WaystoneGeneratorBlock.isFree(world.getBlockState(spawnBlockPos), world, spawnBlockPos) && offset <= maxOffset; ++offset) {
            spawnBlockPos = spawnBlockPos.above();
        }
        return Vector3.fromBlockPos(spawnBlockPos).add(0.5f, 0.0f, 0.5f);
    }

    private static boolean isFree(BlockState state, ServerLevel world, BlockPos waystonePos) {
        return state.getCollisionShape((BlockGetter)world, waystonePos).isEmpty();
    }

    private static ModelWaystone getWaystoneType(Random random, List<ModelWaystone> allowedWaystones) {
        return allowedWaystones.get(random.nextInt(allowedWaystones.size()));
    }

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return MapCodec.unit((Object)((Object)instance));
    }
}

