/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.block.tiles;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.types.Type;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import gollorum.signpost.PlayerHandle;
import gollorum.signpost.Signpost;
import gollorum.signpost.WaystoneHandle;
import gollorum.signpost.blockpartdata.types.LargeSignBlockPart;
import gollorum.signpost.blockpartdata.types.PostBlockPart;
import gollorum.signpost.blockpartdata.types.SignBlockPart;
import gollorum.signpost.blockpartdata.types.SmallShortSignBlockPart;
import gollorum.signpost.blockpartdata.types.SmallWideSignBlockPart;
import gollorum.signpost.blockpartdata.types.WaystoneBlockPart;
import gollorum.signpost.minecraft.block.PostBlock;
import gollorum.signpost.minecraft.config.IConfig;
import gollorum.signpost.minecraft.data.PostData;
import gollorum.signpost.minecraft.data.WaystoneHandleData;
import gollorum.signpost.minecraft.items.Wrench;
import gollorum.signpost.minecraft.utils.SideUtils;
import gollorum.signpost.minecraft.utils.TileEntityUtils;
import gollorum.signpost.minecraft.worldgen.VillageSignpost;
import gollorum.signpost.networking.PacketHandler;
import gollorum.signpost.platform.Services;
import gollorum.signpost.security.WithOwner;
import gollorum.signpost.utils.BlockPart;
import gollorum.signpost.utils.BlockPartInstance;
import gollorum.signpost.utils.BlockPartMetadata;
import gollorum.signpost.utils.IDelay;
import gollorum.signpost.utils.WaystoneContainer;
import gollorum.signpost.utils.WorldLocation;
import gollorum.signpost.utils.math.geometry.Ray;
import gollorum.signpost.utils.math.geometry.Vector3;
import gollorum.signpost.utils.serialization.BlockPosSerializer;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.Tuple;
import net.minecraft.util.datafix.fixes.References;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class PostTile
extends BlockEntity
implements WithOwner.OfSignpost,
WithOwner.OfWaystone,
WaystoneContainer {
    public static final String REGISTRY_NAME = "post";
    private static BlockEntityType<PostTile> type = null;
    private Map<UUID, BlockPartInstance> parts = new ConcurrentHashMap<UUID, BlockPartInstance>();
    public static final Map<String, BlockPartMetadata<?>> partsMetadata = new ConcurrentHashMap();
    public final PostBlock.ModelType modelType;
    private Optional<PlayerHandle> owner = Optional.empty();
    private final List<Runnable> toDoOnceLevelIsSet = new ArrayList<Runnable>();

    public static BlockEntityType<PostTile> createType() {
        assert (type == null);
        Type type = Util.fetchChoiceType((DSL.TypeReference)References.BLOCK_ENTITY, (String)REGISTRY_NAME);
        PostTile.type = Services.BLOCK_ENTITY_TYPE_FACTORY.create((pos, state) -> new PostTile(PostBlock.ModelType.Oak, (BlockPos)pos, (BlockState)state), PostBlock.getAllBlocks(), type);
        return PostTile.type;
    }

    public static BlockEntityType<PostTile> getBlockEntityType() {
        assert (type != null);
        return type;
    }

    public Map<UUID, BlockPartInstance> parts() {
        return this.parts;
    }

    public PostTile(PostBlock.ModelType modelType, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.modelType = modelType;
    }

    public UUID addPart(BlockPartInstance part, ItemStack cost, PlayerHandle player) {
        return this.addPart(UUID.randomUUID(), part, cost, player);
    }

    public UUID addPart(BlockPartInstance part, ItemStack cost, PlayerHandle player, boolean shouldNotify) {
        return this.addPart(UUID.randomUUID(), part, cost, player, shouldNotify);
    }

    public UUID addPart(UUID identifier, BlockPartInstance part, ItemStack cost, PlayerHandle player) {
        return this.addPart(identifier, part, cost, player, true);
    }

    public UUID addPart(UUID identifier, BlockPartInstance part, ItemStack cost, PlayerHandle player, boolean shouldNotify) {
        this.parts.put(identifier, part);
        Runnable toDo = () -> {
            part.blockPart().attachTo(this);
            if (shouldNotify && this.hasLevel() && !this.getLevel().isClientSide()) {
                this.sendToTracing(() -> new PartAddedEvent.Packet(new TilePartInfo(this, identifier), part, cost, player));
            }
        };
        if (this.hasLevel()) {
            toDo.run();
        } else {
            this.toDoOnceLevelIsSet.add(toDo);
        }
        return identifier;
    }

    public BlockPartInstance removePart(UUID id) {
        BlockPartInstance oldPart = this.parts.remove(id);
        if (oldPart == null) {
            Signpost.LOGGER.error("Failed to remove post block part with id " + String.valueOf(id));
            return oldPart;
        }
        if (this.getLevel() != null && !this.getLevel().isClientSide()) {
            this.sendToTracing(() -> new PartRemovedEvent.Packet(new TilePartInfo(this, id), false));
        }
        oldPart.blockPart().removeFrom(this);
        this.setChanged();
        return oldPart;
    }

    public void onDestroy() {
        for (BlockPartInstance part : this.parts.values()) {
            part.blockPart().removeFrom(this);
        }
    }

    public Collection<BlockPartInstance> getParts() {
        return this.parts.values();
    }

    public VoxelShape getBounds() {
        return this.parts.values().stream().map(t -> t.blockPart().getIntersection().getBounds().offset(t.offset()).asMinecraftBB()).map(Shapes::create).reduce((b1, b2) -> Shapes.join((VoxelShape)b1, (VoxelShape)b2, (BooleanOp)BooleanOp.OR)).orElse(Shapes.empty());
    }

    public Optional<TraceResult> trace(Entity player) {
        Vec3 head = player.position();
        head = head.add(0.0, (double)player.getEyeHeight(), 0.0);
        if (player.isCrouching()) {
            head = head.subtract(0.0, 0.08, 0.0);
        }
        Vec3 look = player.getLookAngle();
        Ray ray = new Ray(Vector3.fromVec3d(head).subtract(Vector3.fromBlockPos(this.getBlockPos())), Vector3.fromVec3d(look));
        Optional<Tuple> closestTrace = Optional.empty();
        for (Map.Entry<UUID, BlockPartInstance> t : this.parts.entrySet()) {
            Optional<Float> now = t.getValue().blockPart().intersectWith(ray, t.getValue().offset());
            if (!now.isPresent() || closestTrace.isPresent() && !(((Float)((Tuple)closestTrace.get()).getB()).floatValue() > now.get().floatValue())) continue;
            closestTrace = Optional.of(new Tuple((Object)t.getKey(), (Object)now.get()));
        }
        return closestTrace.map(trace -> new TraceResult(this.parts.get(trace.getA()), (UUID)trace.getA(), ray.atDistance(((Float)trace.getB()).floatValue()), ray));
    }

    protected void saveAdditional(ValueOutput output) {
        super.saveAdditional(output);
        this.writeSelf(output);
    }

    private void writeSelf(ValueOutput output) {
        output.store(PostData.CODEC, (Object)new PostData(this.parts));
        output.store(Codec.optionalField((String)"Owner", PlayerHandle.DIRECT_CODEC, (boolean)true), this.owner);
    }

    protected void loadAdditional(ValueInput input) {
        this.readSelf(input);
    }

    private void readSelf(ValueInput input) {
        this.parts = input.read(PostData.CODEC).map(d -> new ConcurrentHashMap<UUID, BlockPartInstance>(d.parts())).orElseGet(ConcurrentHashMap::new);
        this.owner = input.read(Codec.optionalField((String)"Owner", PlayerHandle.DIRECT_CODEC, (boolean)true)).flatMap(it -> it);
        if (this.parts.isEmpty()) {
            this.parts.put(UUID.randomUUID(), new BlockPartInstance(new PostBlockPart(this.modelType.postTexture), Vector3.ZERO));
        }
        Runnable init = () -> {
            for (BlockPartInstance part : this.parts.values()) {
                part.blockPart().attachTo(this);
            }
        };
        if (this.hasLevel()) {
            init.run();
        } else {
            this.toDoOnceLevelIsSet.add(init);
        }
    }

    protected void collectImplicitComponents(DataComponentMap.Builder components) {
        super.collectImplicitComponents(components);
        components.set(PostData.TYPE, (Object)new PostData(this.parts));
        this.getWaystonePart().ifPresent(waystone -> {
            waystone.getHandle().ifPresent(h -> components.set(WaystoneHandleData.TYPE, (Object)new WaystoneHandleData((WaystoneHandle.Vanilla)h)));
            waystone.getName().ifPresent(n -> components.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)n)));
        });
    }

    public void readData(PostData data) {
        this.parts.clear();
        for (Map.Entry<UUID, BlockPartInstance> entry : data.parts().entrySet()) {
            this.addPart(entry.getKey(), entry.getValue(), ItemStack.EMPTY, PlayerHandle.Invalid);
        }
    }

    public void setLevel(Level level) {
        super.setLevel(level);
        if (!IConfig.IServer.getInstance().worldGen().debugMode() && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            IDelay.forFrames(1, false, () -> {
                boolean hasChanged = false;
                for (Map.Entry e : this.parts.entrySet().stream().sorted((e1, e2) -> Float.compare(((BlockPartInstance)e2.getValue()).offset().y(), ((BlockPartInstance)e1.getValue()).offset().y())).toList()) {
                    SignBlockPart sign;
                    BlockPart patt0$temp = ((BlockPartInstance)e.getValue()).blockPart();
                    if (!(patt0$temp instanceof SignBlockPart) || !(sign = (SignBlockPart)patt0$temp).isMarkedForGeneration() || !VillageSignpost.populate(this, sign, (UUID)e.getKey(), ((BlockPartInstance)e.getValue()).offset().y(), serverLevel)) continue;
                    hasChanged = true;
                }
                if (hasChanged) {
                    level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
                }
            });
        }
        this.toDoOnceLevelIsSet.forEach(Runnable::run);
        this.toDoOnceLevelIsSet.clear();
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        TagValueOutput output = TagValueOutput.createWithContext((ProblemReporter)ProblemReporter.DISCARDING, (HolderLookup.Provider)provider);
        this.writeSelf((ValueOutput)output);
        return output.buildResult();
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void notifyMutation(UUID part, BlockPartInstance data, String partMetaIdentifier) {
        this.sendToTracing(() -> new PartMutatedEvent.Packet(new TilePartInfo(this, part), data.blockPart(), partMetaIdentifier, Optional.empty()));
        this.setChanged();
    }

    public <T> void sendToTracing(Supplier<T> t) {
        PacketHandler.getInstance().sendToTracing(this, t);
    }

    public void setSignpostOwner(Optional<PlayerHandle> owner) {
        this.owner = owner;
    }

    @Override
    public Optional<PlayerHandle> getSignpostOwner() {
        return this.owner;
    }

    public Optional<WaystoneBlockPart> getWaystonePart() {
        return this.getParts().stream().filter(p -> p.blockPart() instanceof WaystoneBlockPart).findFirst().map(p -> (WaystoneBlockPart)p.blockPart());
    }

    @Override
    public Optional<PlayerHandle> getWaystoneOwner() {
        return this.getWaystonePart().flatMap(WaystoneBlockPart::getWaystoneOwner);
    }

    @Override
    public void setWaystoneOwner(Optional<PlayerHandle> owner) {
        this.getWaystonePart().ifPresent(part -> part.setWaystoneOwner(owner));
    }

    public static boolean isAngleTool(Item item) {
        return item instanceof Wrench;
    }

    public Optional<BlockPartInstance> getPart(UUID id) {
        return this.parts.containsKey(id) ? Optional.of(this.parts.get(id)) : Optional.empty();
    }

    static {
        partsMetadata.put(PostBlockPart.METADATA.identifier(), PostBlockPart.METADATA);
        partsMetadata.put(SmallWideSignBlockPart.METADATA.identifier(), SmallWideSignBlockPart.METADATA);
        partsMetadata.put(SmallShortSignBlockPart.METADATA.identifier(), SmallShortSignBlockPart.METADATA);
        partsMetadata.put(LargeSignBlockPart.METADATA.identifier(), LargeSignBlockPart.METADATA);
        partsMetadata.put(WaystoneBlockPart.METADATA.identifier(), WaystoneBlockPart.METADATA);
    }

    public static class PartMutatedEvent
    implements PacketHandler.Event<Packet> {
        @Override
        public StreamCodec<RegistryFriendlyByteBuf, Packet> codec() {
            return Packet.STREAM_CODEC;
        }

        @Override
        public Class<Packet> getMessageClass() {
            return Packet.class;
        }

        @Override
        public void handle(@NotNull Packet message, PacketHandler.Context context) {
            boolean isServer = context instanceof PacketHandler.Context.Server;
            TileEntityUtils.findWorld(message.info.dimensionKey, !isServer).ifPresent(level -> TileEntityUtils.delayUntilTileEntityExistsAt(WorldLocation.from(message.info.pos, level), PostTile.class, tile -> {
                BlockPartInstance oldPart = tile.parts.get(message.info.identifier);
                Vector3 offset = message.offset.orElse(oldPart != null ? oldPart.offset() : Vector3.ZERO);
                if (oldPart != null) {
                    oldPart.blockPart().removeFrom((PostTile)tile);
                } else {
                    Signpost.LOGGER.error("Tried to mutate a post part that wasn't present: " + String.valueOf(message.info.identifier));
                }
                tile.parts.put(message.info.identifier, new BlockPartInstance(message.blockPart, offset));
                message.blockPart().attachTo((PostTile)tile);
                tile.setChanged();
                if (isServer) {
                    tile.sendToTracing(() -> message);
                }
            }, 100, !isServer, Optional.of(() -> Signpost.LOGGER.error("Failed to process PartMutatedEvent, tile was not present"))));
        }

        public record Packet(TilePartInfo info, BlockPart blockPart, String partMetaIdentifier, Optional<Vector3> offset) {
            public static final StreamCodec<RegistryFriendlyByteBuf, Packet> STREAM_CODEC = StreamCodec.composite(TilePartInfo.STREAM_CODEC, Packet::info, BlockPart.STREAM_CODEC, Packet::blockPart, (StreamCodec)ByteBufCodecs.STRING_UTF8, Packet::partMetaIdentifier, (StreamCodec)ByteBufCodecs.optional(Vector3.STREAM_CODEC), Packet::offset, Packet::new);

            public Packet(TilePartInfo info, BlockPart blockPart, String partMetaIdentifier) {
                this(info, blockPart, partMetaIdentifier, Optional.empty());
            }

            public Packet(TilePartInfo info, BlockPart blockPart, String partMetaIdentifier, Vector3 offset) {
                this(info, blockPart, partMetaIdentifier, Optional.of(offset));
            }
        }
    }

    public static class TilePartInfo {
        public final ResourceLocation dimensionKey;
        public final BlockPos pos;
        public final UUID identifier;
        public static final Codec<TilePartInfo> CODEC = RecordCodecBuilder.create(i -> i.group((App)ResourceLocation.CODEC.fieldOf("Dimension").forGetter(t -> t.dimensionKey), (App)BlockPosSerializer.CODEC.fieldOf("Pos").forGetter(t -> t.pos), (App)UUIDUtil.CODEC.fieldOf("Id").forGetter(t -> t.identifier)).apply((Applicative)i, TilePartInfo::new));
        public static final StreamCodec<ByteBuf, TilePartInfo> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, t -> t.dimensionKey, (StreamCodec)BlockPos.STREAM_CODEC, t -> t.pos, (StreamCodec)UUIDUtil.STREAM_CODEC, t -> t.identifier, TilePartInfo::new);

        public TilePartInfo(BlockEntity tile, UUID identifier) {
            this.dimensionKey = tile.getLevel().dimension().location();
            this.pos = tile.getBlockPos();
            this.identifier = identifier;
        }

        public TilePartInfo(ResourceLocation dimensionKey, BlockPos pos, UUID identifier) {
            this.dimensionKey = dimensionKey;
            this.pos = pos;
            this.identifier = identifier;
        }
    }

    public static class TraceResult {
        public final BlockPartInstance part;
        public final UUID id;
        public final Vector3 hitPos;
        public final Ray ray;

        public TraceResult(BlockPartInstance part, UUID id, Vector3 hitPos, Ray ray) {
            this.part = part;
            this.id = id;
            this.hitPos = hitPos;
            this.ray = ray;
        }
    }

    public static class PartRemovedEvent
    implements PacketHandler.Event<Packet> {
        @Override
        public StreamCodec<RegistryFriendlyByteBuf, Packet> codec() {
            return Packet.STREAM_CODEC;
        }

        @Override
        public Class<Packet> getMessageClass() {
            return Packet.class;
        }

        @Override
        public void handle(Packet message, PacketHandler.Context context) {
            boolean isClient = context instanceof PacketHandler.Context.Client;
            TileEntityUtils.findWorld(message.info.dimensionKey, isClient).ifPresent(level -> TileEntityUtils.delayUntilTileEntityExistsAt(WorldLocation.from(message.info.pos, level), PostTile.class, tile -> {
                BlockPartInstance oldPart = tile.removePart(message.info.identifier);
                if (oldPart != null && context instanceof PacketHandler.Context.Server) {
                    ServerPlayer sender;
                    PacketHandler.Context.Server $b$0 = (PacketHandler.Context.Server)context;
                    try {
                        ServerPlayer patt1$temp;
                        sender = patt1$temp = $b$0.sender();
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                    if (!sender.isCreative() && message.shouldDropItem) {
                        for (ItemStack item : oldPart.blockPart().getDrops()) {
                            Level patt2$temp;
                            if (sender.getInventory().add(item) || !((patt2$temp = tile.getLevel()) instanceof ServerLevel)) continue;
                            ServerLevel serverWorld = (ServerLevel)patt2$temp;
                            BlockPos pos = message.info.pos;
                            ItemEntity itementity = new ItemEntity((Level)serverWorld, (double)pos.getX() + (double)serverWorld.getRandom().nextFloat() * 0.5 + 0.25, (double)pos.getY() + (double)serverWorld.getRandom().nextFloat() * 0.5 + 0.25, (double)pos.getZ() + (double)serverWorld.getRandom().nextFloat() * 0.5 + 0.25, item);
                            itementity.setDefaultPickUpDelay();
                            serverWorld.addFreshEntity((Entity)itementity);
                        }
                    }
                }
            }, 100, isClient, Optional.of(() -> Signpost.LOGGER.error("Failed to process PartRemovedEvent, tile was not present"))));
        }

        public record Packet(TilePartInfo info, boolean shouldDropItem) {
            public static final StreamCodec<RegistryFriendlyByteBuf, Packet> STREAM_CODEC = StreamCodec.composite(TilePartInfo.STREAM_CODEC, Packet::info, (StreamCodec)ByteBufCodecs.BOOL, Packet::shouldDropItem, Packet::new);
        }
    }

    public static class PartAddedEvent
    implements PacketHandler.Event<Packet> {
        @Override
        public StreamCodec<RegistryFriendlyByteBuf, Packet> codec() {
            return Packet.STREAM_CODEC;
        }

        @Override
        public Class<Packet> getMessageClass() {
            return Packet.class;
        }

        @Override
        public void handle(Packet message, PacketHandler.Context context) {
            boolean isClientSide = context instanceof PacketHandler.Context.Client;
            TileEntityUtils.findTileEntity(message.info.dimensionKey, isClientSide, message.info.pos, PostTile.getBlockEntityType()).ifPresent(tile -> {
                tile.addPart(message.info.identifier, message.part, message.cost, message.player);
                if (message.cost.getCount() > 0 && (!isClientSide || SideUtils.getClientPlayer().map(player -> player.getUUID().equals(message.player.id())).orElse(false).booleanValue())) {
                    ServerPlayer serverPlayer;
                    if (context instanceof PacketHandler.Context.Server) {
                        PacketHandler.Context.Server $b$0 = (PacketHandler.Context.Server)context;
                        try {
                            ServerPlayer patt1$temp;
                            ServerPlayer sender;
                            serverPlayer = sender = (patt1$temp = $b$0.sender());
                        }
                        catch (Throwable throwable) {
                            throw new MatchException(throwable.toString(), throwable);
                        }
                    } else {
                        serverPlayer = null;
                    }
                    SideUtils.makePlayerPayIfEditor(isClientSide, serverPlayer, message.player, message.cost);
                }
                tile.setChanged();
            });
        }

        public record Packet(TilePartInfo info, BlockPartInstance part, ItemStack cost, PlayerHandle player) {
            public static final StreamCodec<RegistryFriendlyByteBuf, Packet> STREAM_CODEC = StreamCodec.composite(TilePartInfo.STREAM_CODEC, Packet::info, BlockPartInstance.STREAM_CODEC, Packet::part, (StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC, Packet::cost, PlayerHandle.STREAM_CODEC, Packet::player, Packet::new);
        }
    }

    public static class UpdateAllPartsEvent
    implements PacketHandler.Event<Packet> {
        @Override
        public StreamCodec<RegistryFriendlyByteBuf, Packet> codec() {
            return Packet.STREAM_CODEC;
        }

        @Override
        public Class<Packet> getMessageClass() {
            return Packet.class;
        }

        @Override
        public void handle(Packet message, PacketHandler.Context context) {
            if (context instanceof PacketHandler.Context.Client) {
                TileEntityUtils.delayUntilTileEntityExistsAt(message.location, PostTile.getBlockEntityType(), tile -> tile.loadWithComponents(TagValueInput.create((ProblemReporter)ProblemReporter.DISCARDING, (HolderLookup.Provider)context.getHolderLookupProvider(), (CompoundTag)message.tag)), 20, true, Optional.empty());
            }
        }

        public record Packet(CompoundTag tag, WorldLocation location) {
            public static final StreamCodec<RegistryFriendlyByteBuf, Packet> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.compoundTagCodec(NbtAccounter::unlimitedHeap), Packet::tag, WorldLocation.STREAM_CODEC, Packet::location, Packet::new);

            public static Packet from(CompoundTag tag, WorldLocation location) {
                return new Packet(tag, location.withoutExplicitLevel());
            }
        }
    }
}

