/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.data;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import gollorum.signpost.utils.BlockPartInstance;
import gollorum.signpost.utils.BlockPartMetadata;
import gollorum.signpost.utils.serialization.OptionalKeyDispatchCodec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.component.DataComponentType;

public record PostData(Map<UUID, BlockPartInstance> parts) {
    public static final Codec<PostData> CODEC_V1 = Codec.dispatchedMap(BlockPartMetadata.CODEC, key -> Codec.list(BlockPartInstance.codecV1(key))).xmap(map -> {
        HashMap<UUID, BlockPartInstance> newMap = new HashMap<UUID, BlockPartInstance>();
        for (Map.Entry entry : map.entrySet()) {
            for (Pair pair : (List)entry.getValue()) {
                newMap.put(((Optional)pair.getSecond()).orElse(UUID.randomUUID()), (BlockPartInstance)pair.getFirst());
            }
        }
        return new PostData(newMap);
    }, postData -> {
        HashMap<BlockPartMetadata, List> newMap = new HashMap<BlockPartMetadata, List>();
        for (Map.Entry<UUID, BlockPartInstance> entry : postData.parts.entrySet()) {
            BlockPartMetadata meta = entry.getValue().blockPart().getMeta();
            newMap.computeIfAbsent(meta, k -> new ArrayList()).add(Pair.of((Object)entry.getValue(), Optional.of(entry.getKey())));
        }
        return newMap;
    });
    public static final Codec<PostData> CODEC_V2 = Codec.unboundedMap((Codec)UUIDUtil.STRING_CODEC, BlockPartInstance.CODEC_V2).xmap(PostData::new, PostData::parts);
    public static final MapCodec<PostData> CODEC = new OptionalKeyDispatchCodec<Integer, PostData>("DataVersion", 1, data -> 2, (Codec<Integer>)Codec.INT, (Function<Integer, MapCodec<PostData>>)((Function<Integer, MapCodec>)version -> (version == 1 ? CODEC_V1 : CODEC_V2).fieldOf("Parts")));
    public static final DataComponentType<PostData> TYPE = new DataComponentType.Builder().persistent(CODEC.codec()).build();
}

