/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.gui;

import gollorum.signpost.Teleport;
import gollorum.signpost.blockpartdata.types.SignBlockPart;
import gollorum.signpost.minecraft.block.tiles.PostTile;
import gollorum.signpost.minecraft.gui.SignGui;
import gollorum.signpost.minecraft.gui.utils.Colors;
import gollorum.signpost.minecraft.gui.utils.Point;
import gollorum.signpost.minecraft.gui.utils.Rect;
import gollorum.signpost.minecraft.gui.utils.TextureResource;
import gollorum.signpost.minecraft.gui.utils.TextureSize;
import gollorum.signpost.minecraft.gui.widgets.GuiItemRenderer;
import gollorum.signpost.minecraft.gui.widgets.ImageView;
import gollorum.signpost.minecraft.gui.widgets.SignpostImageButton;
import gollorum.signpost.minecraft.gui.widgets.TextDisplay;
import gollorum.signpost.networking.PacketHandler;
import gollorum.signpost.utils.Either;
import gollorum.signpost.utils.math.geometry.Vector3;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;

public class ConfirmTeleportGui
extends Screen {
    private static final TextureSize buttonsSize = new TextureSize(98, 20);
    private static final int costCenterSpace = 10;
    private final Either<String, Teleport.RequestGui.Package.Info> data;
    private final Optional<SignInfo> signInfo;

    public ConfirmTeleportGui(Either<String, Teleport.RequestGui.Package.Info> data, Optional<SignInfo> signInfo) {
        super((Component)Component.translatable((String)"gui.signpost.confirm_teleport_gui_title"));
        this.data = data;
        this.signInfo = signInfo;
    }

    public static void display(Either<String, Teleport.RequestGui.Package.Info> data, Optional<SignInfo> signInfo) {
        Minecraft.getInstance().setScreen((Screen)new ConfirmTeleportGui(data, signInfo));
    }

    protected void init() {
        super.init();
        AtomicInteger editButtonTop = new AtomicInteger();
        this.data.consume(langKey -> {
            this.addRenderableOnly(new TextDisplay((Component)Component.translatable((String)langKey), new Point(this.width / 2, this.height / 2 - 20), Rect.XAlignment.Center, Rect.YAlignment.Bottom, this.font));
            editButtonTop.set(this.height / 2 + 20);
        }, d -> {
            boolean isTooFarAway;
            boolean bl = isTooFarAway = d.maxDistance() > 0 && d.distance() > d.maxDistance();
            if (d.cannotTeleportBecause().isEmpty() && !isTooFarAway) {
                this.addRenderableOnly(new TextDisplay((Component)Component.translatable((String)"gui.signpost.confirm_teleport", (Object[])new Object[]{Colors.wrap(d.waystoneName(), Colors.highlight)}), new Point(this.width / 2, this.height / 2 - 20), Rect.XAlignment.Center, Rect.YAlignment.Bottom, this.font));
                if (!d.cost().isEmpty()) {
                    this.addRenderableOnly(new TextDisplay((Component)Component.translatable((String)"gui.signpost.cost"), new Point(this.width / 2 - 5, this.height / 2), Rect.XAlignment.Right, Rect.YAlignment.Center, this.font));
                    Rect itemRect = new Rect(new Point(this.width / 2 + 5, this.height / 2), TextureResource.itemBackground.size, Rect.XAlignment.Left, Rect.YAlignment.Center);
                    this.addRenderableOnly(new ImageView(TextureResource.itemBackground, itemRect));
                    this.addRenderableOnly((Renderable)new GuiItemRenderer(new Rect(itemRect.center(), 16, 16, Rect.XAlignment.Center, Rect.YAlignment.Center), d.cost()));
                }
                Rect confirmRect = new Rect(new Point(this.width / 2 + 20, this.height / 2 + 20), buttonsSize, Rect.XAlignment.Left, Rect.YAlignment.Top);
                Rect cancelRect = new Rect(new Point(this.width / 2 - 20, this.height / 2 + 20), buttonsSize, Rect.XAlignment.Right, Rect.YAlignment.Top);
                this.addRenderableWidget((GuiEventListener)new Button.Builder((Component)Component.translatable((String)"gui.proceed"), b -> this.confirm()).bounds(confirmRect.point.x, confirmRect.point.y, confirmRect.width, confirmRect.height).build());
                this.addRenderableWidget((GuiEventListener)new Button.Builder((Component)Component.translatable((String)"gui.cancel"), b -> this.cancel()).bounds(cancelRect.point.x, cancelRect.point.y, cancelRect.width, cancelRect.height).build());
                editButtonTop.set(cancelRect.max().y + 20);
            } else {
                d.cannotTeleportBecause().ifPresent(reason -> this.addRenderableOnly(new TextDisplay((Component)reason, new Point(this.width / 2, this.height / 2 - 20), Rect.XAlignment.Center, Rect.YAlignment.Bottom, this.font)));
                if (isTooFarAway) {
                    this.addRenderableOnly(new TextDisplay((Component)Component.translatable((String)"signpost.too_far_away", (Object[])new Object[]{Colors.wrap(Integer.toString(d.distance()), Colors.highlight), Colors.wrap(Integer.toString(d.maxDistance()), Colors.highlight)}), new Point(this.width / 2, this.height / 2 - (d.cannotTeleportBecause().isEmpty() ? 20 : 40)), Rect.XAlignment.Center, Rect.YAlignment.Bottom, this.font));
                }
                editButtonTop.set(this.height / 2 + 20);
            }
        });
        this.signInfo.ifPresent(info -> {
            Rect editRect = new Rect(new Point(this.width / 2, editButtonTop.get()), TextureResource.edit.size, Rect.XAlignment.Center, Rect.YAlignment.Top);
            if (info.sign.hasThePermissionToEdit(info.tile, (Player)this.minecraft.player)) {
                this.addRenderableWidget((GuiEventListener)new SignpostImageButton(TextureResource.edit, editRect, b -> SignGui.display(info.tile, info.sign, info.offset, info.tilePartInfo)));
            }
        });
    }

    private void confirm() {
        this.minecraft.setScreen(null);
        this.data.consume(langKey -> this.minecraft.player.displayClientMessage((Component)Component.translatable((String)langKey), true), data -> PacketHandler.getInstance().sendToServer(new Teleport.Request.Package(data.waystoneName(), data.handle())));
    }

    private void cancel() {
        this.minecraft.setScreen(null);
    }

    public static class SignInfo {
        public final PostTile tile;
        public final SignBlockPart sign;
        public final PostTile.TilePartInfo tilePartInfo;
        public final Vector3 offset;

        public SignInfo(PostTile tile, SignBlockPart sign, PostTile.TilePartInfo tilePartInfo, Vector3 offset) {
            this.tile = tile;
            this.sign = sign;
            this.tilePartInfo = tilePartInfo;
            this.offset = offset;
        }
    }
}

