/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.gui;

import com.google.common.collect.Streams;
import gollorum.signpost.minecraft.block.PostBlock;
import gollorum.signpost.minecraft.block.tiles.PostTile;
import gollorum.signpost.minecraft.data.PostData;
import gollorum.signpost.minecraft.gui.utils.IFluidTextureProvider;
import gollorum.signpost.minecraft.gui.utils.Point;
import gollorum.signpost.minecraft.gui.utils.Rect;
import gollorum.signpost.minecraft.gui.utils.TextureResource;
import gollorum.signpost.minecraft.gui.widgets.GuiBlockPartRenderer;
import gollorum.signpost.minecraft.gui.widgets.ItemButton;
import gollorum.signpost.minecraft.gui.widgets.SpriteSelectionButton;
import gollorum.signpost.minecraft.utils.Texture;
import gollorum.signpost.minecraft.utils.tints.BlockColorTint;
import gollorum.signpost.minecraft.utils.tints.FluidTint;
import gollorum.signpost.mixin.BucketAccessor;
import gollorum.signpost.networking.PacketHandler;
import gollorum.signpost.utils.BlockPart;
import gollorum.signpost.utils.BlockPartInstance;
import gollorum.signpost.utils.Either;
import gollorum.signpost.utils.Tint;
import gollorum.signpost.utils.Tuple;
import gollorum.signpost.utils.math.Angle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public abstract class PaintBlockPartGui<T extends BlockPart<T>>
extends Screen {
    private final PostTile tile;
    private final int maxBlocksPerRow = 9;
    private List<SpriteSelectionButton> textureButtons = new ArrayList<SpriteSelectionButton>();
    protected final T part;
    protected final T displayPart;
    protected Tuple<Either<TextureAtlasSprite, Material>, Optional<Tint>> oldSprite;
    private final UUID identifier;
    private static final Direction[] faces = new Direction[]{null, Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST, Direction.UP, Direction.DOWN};

    public PaintBlockPartGui(PostTile tile, T part, T displayPart, UUID identifier, Texture oldTexture) {
        super((Component)Component.literal((String)"Paint Post"));
        this.tile = tile;
        this.part = part;
        this.displayPart = displayPart;
        this.oldSprite = Tuple.of(Either.right(oldTexture.toMaterial()), oldTexture.tint());
        this.identifier = identifier;
    }

    protected Either<TextureAtlasSprite, Material> spriteFrom(ResourceLocation loc) {
        return Either.right(new Material(TextureResource.blockAtlas, loc));
    }

    protected void init() {
        super.init();
        List<Tuple> blocksToRender = Streams.stream((Iterable)this.minecraft.player.getInventory()).filter(i -> !i.isEmpty() && (i.getItem() instanceof BlockItem || i.getItem() instanceof BucketItem)).map(i -> {
            ItemStack ret = i.copy();
            ret.setCount(1);
            return ret;
        }).distinct().map(is -> Tuple.of(this.allSpritesFor((ItemStack)is), is)).filter(p -> !((List)p._1()).isEmpty()).toList();
        int rows = (blocksToRender.size() + 8) / 9;
        for (int y = 0; y < rows; ++y) {
            int rowWidth = y == rows - 1 ? (blocksToRender.size() - 1) % 9 + 1 : 9;
            int top = this.height * 3 / 4 + y * 20;
            int left = this.width / 2 - rowWidth * 20 / 2;
            for (int x = 0; x < rowWidth; ++x) {
                Tuple tuple = blocksToRender.get(x + y * 9);
                this.addRenderableWidget((GuiEventListener)new ItemButton(left + x * 20, top, Rect.XAlignment.Left, Rect.YAlignment.Bottom, (ItemStack)tuple._2(), b -> this.setupTextureButtonsFor((List)tuple._1()), Minecraft.getInstance().getItemRenderer(), this.font));
            }
        }
        this.addRenderableWidget((GuiEventListener)new GuiBlockPartRenderer(this.tile.getParts().stream().map(p -> p.blockPart() == this.part ? new BlockPartInstance((BlockPart)this.displayPart, p.offset()) : p).collect(Collectors.toList()), new Point(this.width / 2, this.height / 4), Angle.fromDegrees(this.minecraft.player.getYRot() + 180.0f), Angle.fromDegrees(this.minecraft.player.getXRot()), 64.0f, this.font));
    }

    private List<Tuple<Either<TextureAtlasSprite, Material>, Optional<Tint>>> allSpritesFor(ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof BlockItem) {
            return this.allSpritesFor((BlockItem)item, stack);
        }
        if (item instanceof BucketItem) {
            return this.allSpritesFor((BucketItem)item);
        }
        throw new RuntimeException("Item type of " + String.valueOf(item.getClass()) + " not supported");
    }

    private List<Tuple<Either<TextureAtlasSprite, Material>, Optional<Tint>>> allSpritesFor(BlockItem item, ItemStack stack) {
        Block block = item.getBlock();
        if (!(block instanceof PostBlock)) {
            return this.allSpritesFor(block.defaultBlockState());
        }
        PostData data = (PostData)stack.get(PostData.TYPE);
        if (data != null) {
            ArrayList<Tuple<Either<TextureAtlasSprite, Material>, Optional<Tint>>> ret = new ArrayList<Tuple<Either<TextureAtlasSprite, Material>, Optional<Tint>>>(data.parts().size());
            for (Map.Entry<UUID, BlockPartInstance> entry : data.parts().entrySet()) {
                BlockPartInstance part = entry.getValue();
                Collection<Texture> partTextures = part.blockPart().getAllTextures();
                for (Texture tex : partTextures) {
                    ret.add(Tuple.of(Either.right(tex.toMaterial()), tex.tint()));
                }
            }
            return ret;
        }
        return this.allSpritesFor(block.defaultBlockState());
    }

    private List<Tuple<Either<TextureAtlasSprite, Material>, Optional<Tint>>> allSpritesFor(BucketItem item) {
        FluidTint fluidTint = new FluidTint(((BucketAccessor)item).getContent());
        ArrayList<Tuple<Either<TextureAtlasSprite, Material>, Optional<Tint>>> ret = new ArrayList<Tuple<Either<TextureAtlasSprite, Material>, Optional<Tint>>>(3);
        ResourceLocation loc = null;
        IFluidTextureProvider fluidTextureProvider = IFluidTextureProvider.getInstance();
        loc = fluidTextureProvider.getFlowingTexture(fluidTint.fluid());
        if (loc != null) {
            ret.add(Tuple.of(this.spriteFrom(loc), Optional.of(fluidTint)));
        }
        if ((loc = fluidTextureProvider.getOverlayTexture(fluidTint.fluid())) != null) {
            ret.add(Tuple.of(this.spriteFrom(loc), Optional.of(fluidTint)));
        }
        if ((loc = fluidTextureProvider.getStillTexture(fluidTint.fluid())) != null) {
            ret.add(Tuple.of(this.spriteFrom(loc), Optional.of(fluidTint)));
        }
        return ret;
    }

    private List<Tuple<Either<TextureAtlasSprite, Material>, Optional<Tint>>> allSpritesFor(BlockState state) {
        BlockStateModel model = Minecraft.getInstance().getBlockRenderer().getBlockModel(state);
        RandomSource random = RandomSource.create((long)((Object)((Object)this)).hashCode());
        return Arrays.stream(faces).flatMap(side -> model.collectParts(random).stream().flatMap(part -> part.getQuads(side).stream())).map(bakedQuad -> Tuple.of(bakedQuad.sprite(), bakedQuad.tintIndex())).distinct().map(loc -> Tuple.of(Either.left((TextureAtlasSprite)loc._1()), (Integer)loc._2() >= 0 ? Optional.of(new BlockColorTint(state.getBlock(), (Integer)loc._2())) : Optional.empty())).collect(Collectors.toList());
    }

    private void setupTextureButtonsFor(List<Tuple<Either<TextureAtlasSprite, Material>, Optional<Tint>>> sprites) {
        this.clearSelection();
        sprites = Streams.concat((Stream[])new Stream[]{Stream.of(this.oldSprite), sprites.stream()}).distinct().collect(Collectors.toList());
        int spriteButtonSize = 30;
        int centerY = this.height / 2 + 10;
        int left = this.width / 2 - sprites.size() * spriteButtonSize / 2;
        for (int x = 0; x < sprites.size(); ++x) {
            Tuple<Either<Object, Object>, Optional<Tint>> sprite = sprites.get(x);
            SpriteSelectionButton newButton = new SpriteSelectionButton(new Rect(new Point(left + x * spriteButtonSize, centerY), spriteButtonSize, spriteButtonSize, Rect.XAlignment.Left, Rect.YAlignment.Center), sprite._1(), sprite._2().map(t -> t.getColorAt((BlockAndTintGetter)this.minecraft.level, this.minecraft.player.blockPosition())).orElse(-1), imgButton -> this.setTexture(this.displayPart, new Texture(((Either)sprite._1()).match(tas -> tas.contents().name(), Material::texture), ((Either)sprite._1()).match(TextureAtlasSprite::atlasLocation, Material::atlasLocation), (Optional<Tint>)((Optional)sprite._2()))));
            this.addRenderableWidget((GuiEventListener)newButton);
            this.textureButtons.add(newButton);
        }
    }

    protected void clearSelection() {
        for (SpriteSelectionButton button : this.textureButtons) {
            this.removeWidget((GuiEventListener)button);
        }
    }

    protected abstract void setTexture(T var1, Texture var2);

    public void onClose() {
        super.onClose();
        PacketHandler.getInstance().sendToServer(new PostTile.PartMutatedEvent.Packet(new PostTile.TilePartInfo(this.tile, this.identifier), (BlockPart)this.displayPart, this.part.getMeta().identifier()));
    }
}

