/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.gui;

import gollorum.signpost.blockpartdata.types.SignBlockPart;
import gollorum.signpost.minecraft.block.tiles.PostTile;
import gollorum.signpost.minecraft.gui.PaintBlockPartGui;
import gollorum.signpost.minecraft.gui.utils.Point;
import gollorum.signpost.minecraft.gui.utils.Rect;
import gollorum.signpost.minecraft.utils.Texture;
import gollorum.signpost.utils.Either;
import gollorum.signpost.utils.Tint;
import gollorum.signpost.utils.Tuple;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.network.chat.Component;

public class PaintSignGui<T extends SignBlockPart<T>>
extends PaintBlockPartGui<T> {
    private final Tuple<Either<TextureAtlasSprite, Material>, Optional<Tint>> oldMainSprite;
    private final Tuple<Either<TextureAtlasSprite, Material>, Optional<Tint>> oldSecSprite;
    private boolean isTargetingMainTexture;

    public PaintSignGui(PostTile tile, T sign, UUID identifier) {
        super(tile, sign, ((SignBlockPart)sign).copy(), identifier, ((SignBlockPart)sign).getMainTexture());
        this.oldMainSprite = this.oldSprite;
        this.oldSecSprite = Tuple.of(this.spriteFrom(((SignBlockPart)sign).getSecondaryTexture().location()), ((SignBlockPart)sign).getSecondaryTexture().tint());
        this.isTargetingMainTexture = true;
    }

    public static <T extends SignBlockPart<T>> void display(PostTile tile, T sign, UUID identifier) {
        Minecraft.getInstance().setScreen(new PaintSignGui<T>(tile, sign, identifier));
    }

    @Override
    protected void init() {
        super.init();
        Rect button1Rect = new Rect(new Point(this.width / 4, this.height / 4), 125, 20, Rect.XAlignment.Center, Rect.YAlignment.Center);
        AtomicReference<Button> b1 = new AtomicReference<Button>();
        AtomicReference<Button> b2 = new AtomicReference<Button>();
        b1.set(new Button.Builder((Component)Component.translatable((String)"gui.signpost.main_material"), b -> {
            this.isTargetingMainTexture = true;
            this.oldSprite = this.oldMainSprite;
            this.clearSelection();
            ((Button)b1.get()).active = false;
            ((Button)b2.get()).active = true;
        }).bounds(button1Rect.point.x, button1Rect.point.y, button1Rect.width, button1Rect.height).build());
        Rect button2Rect = new Rect(button1Rect.max().withY(y -> y + 5), 125, 20, Rect.XAlignment.Right, Rect.YAlignment.Top);
        b2.set(new Button.Builder((Component)Component.translatable((String)"gui.signpost.secondary_material"), b -> {
            this.isTargetingMainTexture = false;
            this.oldSprite = this.oldSecSprite;
            this.clearSelection();
            ((Button)b1.get()).active = true;
            ((Button)b2.get()).active = false;
        }).bounds(button2Rect.point.x, button2Rect.point.y, button2Rect.width, button2Rect.height).build());
        ((Button)b1.get()).active = !this.isTargetingMainTexture;
        ((Button)b2.get()).active = this.isTargetingMainTexture;
        this.addRenderableWidget((GuiEventListener)((Button)b1.get()));
        this.addRenderableWidget((GuiEventListener)((Button)b2.get()));
    }

    @Override
    protected void setTexture(T sign, Texture texture) {
        if (this.isTargetingMainTexture) {
            ((SignBlockPart)sign).setMainTexture(texture);
        } else {
            ((SignBlockPart)sign).setSecondaryTexture(texture);
        }
    }
}

