/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.gui;

import gollorum.signpost.WaystoneLibrary;
import gollorum.signpost.events.WaystoneRenamedEvent;
import gollorum.signpost.events.WaystoneUpdatedEvent;
import gollorum.signpost.minecraft.gui.utils.Point;
import gollorum.signpost.minecraft.gui.utils.Rect;
import gollorum.signpost.minecraft.gui.utils.TextureResource;
import gollorum.signpost.minecraft.gui.utils.TextureSize;
import gollorum.signpost.minecraft.gui.widgets.ImageInputBox;
import gollorum.signpost.utils.WaystoneData;
import gollorum.signpost.utils.WaystoneLocationData;
import gollorum.signpost.utils.WorldLocation;
import gollorum.signpost.utils.math.geometry.Vector3;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.LockIconButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class WaystoneGui
extends Screen {
    private final WorldLocation location;
    private final Optional<WaystoneData> oldData;
    private ImageInputBox inputBox;
    private Optional<Set<String>> allWaystoneNames = Optional.empty();
    private static final TextureResource texture = TextureResource.waystoneNameField;
    private static final int inputBoxScale = 3;
    private static final int inputBoxYOffset = -46;
    private static final int buttonsYOffset = 46;
    private static final TextureSize buttonsSize = new TextureSize(98, 20);
    private LockIconButton lockButton;
    private Button doneButton;
    private final Consumer<WaystoneUpdatedEvent> waystoneUpdateListener = event -> this.allWaystoneNames.ifPresent(names -> {
        switch (event.getType()) {
            case Added: {
                names.add(event.name);
                break;
            }
            case Removed: {
                names.remove(event.name);
                break;
            }
            case Renamed: {
                names.remove(((WaystoneRenamedEvent)event).oldName);
                names.add(event.name);
            }
        }
    });

    public WaystoneGui(WorldLocation location, Optional<WaystoneData> oldData) {
        super((Component)Component.literal((String)"Waystone"));
        this.location = location;
        this.oldData = oldData;
    }

    public static void display(WorldLocation location, Optional<WaystoneData> oldData) {
        Minecraft.getInstance().setScreen((Screen)new WaystoneGui(location, oldData));
    }

    private int getCenterX() {
        return this.width / 2;
    }

    private int getCenterY() {
        return this.height / 2;
    }

    protected void init() {
        super.init();
        WaystoneLibrary.getInstance().requestAllWaystoneNames(names -> {
            this.allWaystoneNames = Optional.of(new HashSet(names.values()));
        }, Optional.empty(), true);
        WaystoneLibrary.getInstance().updateEventDispatcher.addListener(this.waystoneUpdateListener);
        Point point = new Point(this.getCenterX(), this.getCenterY() + -46);
        int n = (WaystoneGui.texture.size.width - 6) * 3;
        Objects.requireNonNull(this.font);
        this.inputBox = new ImageInputBox(this.font, new Rect(point, new TextureSize(n, 9), Rect.XAlignment.Center, Rect.YAlignment.Bottom), new Rect(Point.zero, WaystoneGui.texture.size.scale(3.0f), Rect.XAlignment.Center, Rect.YAlignment.Center), Rect.XAlignment.Center, Rect.YAlignment.Center, texture, true, 0.0);
        this.lockButton = new LockIconButton(this.inputBox.getX() + this.inputBox.width() + 10, this.inputBox.getY() + this.inputBox.getHeight() / 2 - 10, b -> this.lockButton.setLocked(!this.lockButton.isLocked()));
        this.addRenderableWidget((GuiEventListener)this.lockButton);
        this.oldData.ifPresent(data -> {
            this.inputBox.setValue(data.name());
            this.lockButton.setLocked(data.isLocked());
        });
        this.doneButton = Button.builder((Component)Component.translatable((String)"gui.done"), b -> this.done()).bounds(this.getCenterX() - WaystoneGui.buttonsSize.width / 2, this.getCenterY() - WaystoneGui.buttonsSize.height / 2 + 46, WaystoneGui.buttonsSize.width, WaystoneGui.buttonsSize.height).build();
        this.addRenderableWidget((GuiEventListener)this.inputBox);
        this.addRenderableWidget((GuiEventListener)this.doneButton);
        this.inputBox.setTextColor(-1);
        this.inputBox.setTextColorUneditable(-2236963);
        this.inputBox.setMaxLength(200);
        this.inputBox.setResponder(name -> {
            if (this.isValid((String)name)) {
                this.inputBox.setTextColor(-1);
                this.inputBox.setTextColorUneditable(-2236963);
                this.doneButton.active = true;
            } else {
                this.inputBox.setTextColor(-48060);
                this.inputBox.setTextColorUneditable(-2267546);
                this.doneButton.active = false;
            }
        });
        this.setInitialFocus((GuiEventListener)this.inputBox);
    }

    private boolean isValid(String name) {
        return this.allWaystoneNames.map(names -> !names.contains(name)).orElse(true) != false || this.oldData.isPresent() && this.oldData.get().name().equals(name);
    }

    public void onClose() {
        super.onClose();
        WaystoneLibrary.getInstance().updateEventDispatcher.removeListener(this.waystoneUpdateListener);
    }

    private void done() {
        if (this.inputBox != null && !this.inputBox.getValue().equals("") && this.isValid(this.inputBox.getValue())) {
            WaystoneLibrary.getInstance().requestUpdate(this.inputBox.getValue(), new WaystoneLocationData(this.location, Vector3.fromVec3d(this.minecraft.player.position())), this.lockButton.isLocked());
        }
        this.onClose();
    }
}

