/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.items;

import gollorum.signpost.minecraft.block.ModelWaystone;
import gollorum.signpost.minecraft.block.WaystoneBlock;
import gollorum.signpost.minecraft.data.WaystoneHandleData;
import java.util.function.Consumer;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.level.block.Block;

public class WaystoneItem
extends BlockItem {
    public WaystoneItem(WaystoneBlock waystone, Item.Properties properties) {
        super((Block)waystone, properties.setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"signpost", (String)"waystone"))));
    }

    public WaystoneItem(ModelWaystone waystone, Item.Properties properties) {
        super((Block)waystone, properties.setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"signpost", (String)waystone.variant.registryName))));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay tooltipDisplay, Consumer<Component> tooltipComponents, TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltipDisplay, tooltipComponents, flag);
        WaystoneHandleData data = (WaystoneHandleData)stack.get(WaystoneHandleData.TYPE);
        if (data != null) {
            tooltipComponents.accept((Component)Component.translatable((String)"item.signpost.waystone_has_id"));
            if (flag.isAdvanced()) {
                tooltipComponents.accept((Component)Component.translatable((String)"item.signpost.waystone_id", (Object[])new Object[]{data.handle().id().toString()}));
            }
        }
    }
}

