/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.rendering;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.vertex.VertexConsumer;
import gollorum.signpost.minecraft.gui.utils.Rect;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.render.TextureSetup;
import net.minecraft.client.gui.render.state.GuiElementRenderState;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class ModelElementRenderState
implements GuiElementRenderState {
    private final ScreenRectangle rect;
    private final Consumer<VertexConsumer> render;
    private final ResourceLocation atlasLocation;
    private final RenderPipeline renderPipeline;

    public ModelElementRenderState(Rect rect, ResourceLocation atlasLocation, RenderPipeline renderPipeline, Consumer<VertexConsumer> render) {
        this.rect = new ScreenRectangle(rect.min().x, rect.min().y, rect.width, rect.height);
        this.render = render;
        this.atlasLocation = atlasLocation;
        this.renderPipeline = renderPipeline;
    }

    public ModelElementRenderState(ScreenRectangle rect, ResourceLocation atlasLocation, RenderPipeline renderPipeline, Consumer<VertexConsumer> render) {
        this.rect = rect;
        this.render = render;
        this.atlasLocation = atlasLocation;
        this.renderPipeline = renderPipeline;
    }

    public void buildVertices(VertexConsumer vertexConsumer) {
        this.render.accept(vertexConsumer);
    }

    public RenderPipeline pipeline() {
        return this.renderPipeline;
    }

    public TextureSetup textureSetup() {
        Minecraft minecraft = Minecraft.getInstance();
        TextureManager texturemanager = minecraft.getTextureManager();
        GpuTextureView gputextureview = texturemanager.getTexture(this.atlasLocation).getTextureView();
        return TextureSetup.singleTexture((GpuTextureView)gputextureview);
    }

    @Nullable
    public ScreenRectangle scissorArea() {
        return null;
    }

    @Nullable
    public ScreenRectangle bounds() {
        return this.rect;
    }
}

