/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.rendering;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.math.Axis;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import gollorum.signpost.blockpartdata.types.BlockPartRenderer;
import gollorum.signpost.blockpartdata.types.PostBlockPart;
import gollorum.signpost.blockpartdata.types.SmallWideSignBlockPart;
import gollorum.signpost.minecraft.block.PostBlock;
import gollorum.signpost.minecraft.data.PostData;
import gollorum.signpost.minecraft.rendering.RenderingUtil;
import gollorum.signpost.utils.AngleProvider;
import gollorum.signpost.utils.BlockPartInstance;
import gollorum.signpost.utils.NameProvider;
import gollorum.signpost.utils.math.Angle;
import gollorum.signpost.utils.math.geometry.Vector3;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.special.SpecialModelRenderer;
import net.minecraft.client.resources.model.MaterialSet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class PostItemRenderer
implements SpecialModelRenderer<PostData> {
    private final PostBlock.ModelType fallbackType;
    private final MaterialSet materials;

    public PostItemRenderer(PostBlock.ModelType fallbackType, MaterialSet materials) {
        this.fallbackType = fallbackType;
        this.materials = materials;
    }

    public void getExtents(Set<Vector3f> set) {
        set.add(new Vector3f(-1.0f, 0.0f, -1.0f));
        set.add(new Vector3f(-1.0f, 0.0f, 1.0f));
        set.add(new Vector3f(1.0f, 0.0f, 1.0f));
        set.add(new Vector3f(1.0f, 0.0f, -1.0f));
    }

    public PostData extractArgument(ItemStack itemStack) {
        PostData data = (PostData)itemStack.get(PostData.TYPE);
        if (data == null) {
            HashMap<UUID, BlockPartInstance> parts = new HashMap<UUID, BlockPartInstance>();
            parts.put(UUID.randomUUID(), new BlockPartInstance(new PostBlockPart(this.fallbackType.postTexture), Vector3.ZERO));
            parts.put(UUID.randomUUID(), new BlockPartInstance(new SmallWideSignBlockPart(new AngleProvider.Literal(Angle.fromDegrees(180.0f)), new NameProvider.Literal(""), true, this.fallbackType.mainTexture, this.fallbackType.secondaryTexture, Optional.empty(), -1, Optional.empty(), Optional.empty(), this.fallbackType, false, false), new Vector3(0.0f, 0.75f, 0.0f)));
            data = new PostData(parts);
        }
        return data;
    }

    public void submit(PostData data, ItemDisplayContext displayContext, PoseStack poseStack, SubmitNodeCollector nodeCollector, int packedLight, int packedOverlay, boolean hasFoil, int outlineColor) {
        ArrayList<Object> parts;
        if (data != null) {
            parts = new ArrayList<BlockPartInstance>(data.parts().values());
        } else {
            parts = new ArrayList<BlockPartInstance>();
            parts.add(new BlockPartInstance(new PostBlockPart(this.fallbackType.postTexture), Vector3.ZERO));
            parts.add(new BlockPartInstance(new SmallWideSignBlockPart(new AngleProvider.Literal(Angle.fromDegrees(180.0f)), new NameProvider.Literal(""), true, this.fallbackType.mainTexture, this.fallbackType.secondaryTexture, Optional.empty(), -1, Optional.empty(), Optional.empty(), this.fallbackType, false, false), new Vector3(0.0f, 0.75f, 0.0f)));
        }
        RenderingUtil.wrapInMatrixEntry(poseStack, () -> {
            poseStack.translate(0.5, 0.0, 0.5);
            switch (displayContext) {
                case GUI: {
                    poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(90.0f));
                    poseStack.scale(0.9f, 0.9f, 0.9f);
                    break;
                }
                case FIRST_PERSON_RIGHT_HAND: 
                case FIRST_PERSON_LEFT_HAND: 
                case THIRD_PERSON_RIGHT_HAND: {
                    poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(270.0f));
                    break;
                }
                case THIRD_PERSON_LEFT_HAND: {
                    poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(90.0f));
                    break;
                }
                case FIXED: {
                    poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(180.0f));
                }
            }
            for (BlockPartInstance now : parts) {
                RenderingUtil.wrapInMatrixEntry(poseStack, () -> {
                    poseStack.translate(now.offset().x(), now.offset().y(), now.offset().z());
                    BlockPartRenderer.renderDynamic(now.blockPart(), (Level)Minecraft.getInstance().level, Minecraft.getInstance().player.blockPosition(), poseStack, nodeCollector, this.materials, packedLight, packedOverlay, displayContext == ItemDisplayContext.GUI ? t -> RenderType.solid() : RenderType::entityCutout, null);
                });
            }
        });
    }

    public record Unbaked(PostBlock.ModelType fallbackType) implements SpecialModelRenderer.Unbaked
    {
        public static final ResourceLocation NAME = ResourceLocation.fromNamespaceAndPath((String)"signpost", (String)"post_item");
        public static final MapCodec<Unbaked> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)PostBlock.ModelType.CODEC.fieldOf("fallback").forGetter(Unbaked::fallbackType)).apply((Applicative)instance, Unbaked::new));

        public SpecialModelRenderer<?> bake(SpecialModelRenderer.BakingContext context) {
            return new PostItemRenderer(this.fallbackType, context.materials());
        }

        public MapCodec<Unbaked> type() {
            return MAP_CODEC;
        }
    }
}

