/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.rendering;

import com.mojang.blaze3d.vertex.PoseStack;
import gollorum.signpost.blockpartdata.types.BlockPartRenderer;
import gollorum.signpost.blockpartdata.types.PostBlockPart;
import gollorum.signpost.minecraft.block.tiles.PostTile;
import gollorum.signpost.minecraft.rendering.RenderingUtil;
import gollorum.signpost.mixin.LevelRendererAccessor;
import gollorum.signpost.utils.BlockPartInstance;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.MaterialSet;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class PostRenderer
implements BlockEntityRenderer<PostTile, PostRenderState> {
    private static final double randomOffset = 0.001;
    private final MaterialSet materials;

    public PostRenderer(BlockEntityRendererProvider.Context ctx) {
        this.materials = ctx.materials();
    }

    public PostRenderState createRenderState() {
        return new PostRenderState();
    }

    public void extractRenderState(PostTile blockEntity, PostRenderState renderState, float partialTick, Vec3 cameraPosition, @Nullable ModelFeatureRenderer.CrumblingOverlay breakProgress) {
        super.extractRenderState((BlockEntity)blockEntity, (BlockEntityRenderState)renderState, partialTick, cameraPosition, breakProgress);
        renderState.tile = blockEntity;
    }

    public void submit(PostRenderState renderState, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, CameraRenderState cameraRenderState) {
        long randomSeed = renderState.tile.hashCode();
        RandomSource random = RandomSource.create((long)randomSeed);
        SortedSet destructionProgresses = (SortedSet)((LevelRendererAccessor)Minecraft.getInstance().levelRenderer).getDestructionProgress().get(renderState.blockPos.asLong());
        Set partsBeingBroken = destructionProgresses == null ? null : destructionProgresses.stream().map(progress -> Optional.ofNullable(renderState.tile.getLevel().getEntity(progress.getId())).flatMap(renderState.tile::trace).map(res -> res.part)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
        boolean shouldUseOriginalBuffer = partsBeingBroken == null || partsBeingBroken.isEmpty() || partsBeingBroken.stream().anyMatch(i -> i.blockPart() instanceof PostBlockPart);
        RenderingUtil.wrapInMatrixEntry(poseStack, () -> {
            poseStack.translate(0.5, 0.0, 0.5);
            for (BlockPartInstance now : renderState.tile.getParts()) {
                RenderingUtil.wrapInMatrixEntry(poseStack, () -> {
                    poseStack.translate((double)now.offset().x() + 0.001 * random.nextDouble(), (double)now.offset().y() + 0.001 * random.nextDouble(), (double)now.offset().z() + 0.001 * random.nextDouble());
                    BlockPartRenderer.renderDynamic(now.blockPart(), renderState.tile.getLevel(), renderState.blockPos, poseStack, submitNodeCollector, this.materials, renderState.lightCoords, OverlayTexture.NO_OVERLAY, t -> RenderType.cutout(), (ModelFeatureRenderer.CrumblingOverlay)(shouldUseOriginalBuffer || partsBeingBroken.contains(now) ? renderState.breakProgress : null));
                });
            }
        });
    }

    public static class PostRenderState
    extends BlockEntityRenderState {
        PostTile tile;
    }
}

