/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.rendering;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.SheetedDecalTextureGenerator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import gollorum.signpost.minecraft.gui.utils.Point;
import gollorum.signpost.minecraft.gui.utils.Rect;
import gollorum.signpost.minecraft.models.modelGeneration.Quad;
import gollorum.signpost.minecraft.models.modelGeneration.QuadModel;
import gollorum.signpost.minecraft.rendering.GuiFakeCollector;
import gollorum.signpost.minecraft.rendering.TexturedModel;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.resources.model.MaterialSet;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix3x2fStack;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class RenderingUtil {
    public static void render(PoseStack blockToView, TexturedModel model, SubmitNodeCollector nodeCollector, MaterialSet materials, int combinedLights, int combinedOverlay, Function<ResourceLocation, RenderType> renderTypeFactory, ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        RenderType renderType = model.texture().renderType(renderTypeFactory);
        SubmitNodeCollector.CustomGeometryRenderer doRender = (pose, vertexConsumer) -> {
            RenderingUtil.render(pose, model.model(), materials.get(model.texture()).wrap(vertexConsumer), combinedLights, combinedOverlay, model.tint(), 0.0f);
            if (crumblingOverlay != null && renderType.affectsCrumbling()) {
                RenderType crumblingTenderType = (RenderType)ModelBakery.DESTROY_TYPES.get(crumblingOverlay.progress());
                SheetedDecalTextureGenerator vertexconsumer2 = new SheetedDecalTextureGenerator(Minecraft.getInstance().renderBuffers().crumblingBufferSource().getBuffer(crumblingTenderType), crumblingOverlay.cameraPose(), 1.0f);
                RenderingUtil.render(pose, model.model(), materials.get(model.texture()).wrap((VertexConsumer)vertexconsumer2), combinedLights, combinedOverlay, model.tint(), 0.001f);
            }
        };
        if (nodeCollector instanceof GuiFakeCollector) {
            GuiFakeCollector gfc = (GuiFakeCollector)nodeCollector;
            gfc.submitCustomGeometry(blockToView, renderType, doRender, model.texture().atlasLocation());
        } else {
            nodeCollector.submitCustomGeometry(blockToView, renderType, doRender);
        }
    }

    public static void render(PoseStack.Pose pose, QuadModel model, VertexConsumer buffer, int combinedLights, int combinedOverlay, int color, float offset) {
        Matrix4f matrix = pose.pose();
        Vector3f bufferVector = new Vector3f();
        if ((color & 0xFF000000) == 0) {
            color |= 0xFF000000;
        }
        for (Quad quad : model.quads()) {
            pose.transformNormal((Vector3fc)quad.normal(), bufferVector);
            float normalX = bufferVector.x;
            float normalY = bufferVector.y;
            float normalZ = bufferVector.z;
            for (Quad.Vertex vertex : quad.vertices()) {
                matrix.transformPosition((Vector3fc)vertex.pos(), bufferVector);
                buffer.addVertex(bufferVector.x() + offset * normalX, bufferVector.y() + offset * normalY, bufferVector.z() + offset * normalZ, color, vertex.u(), vertex.v(), combinedOverlay, combinedLights, normalX, normalY, normalZ);
            }
        }
    }

    public static void drawString(GuiGraphics graphics, Font fontRenderer, String text, Point point, Rect.XAlignment xAlignment, Rect.YAlignment yAlignment, int color, int maxWidth, boolean dropShadow) {
        int textWidth = fontRenderer.width(text);
        float scale = Math.min(1.0f, (float)maxWidth / (float)textWidth);
        graphics.pose().pushMatrix();
        Matrix3x2fStack matrix3x2fStack = graphics.pose();
        float f = (float)Rect.xCoordinateFor(point.x, maxWidth, xAlignment) + (float)maxWidth * 0.5f;
        int n = point.y;
        Objects.requireNonNull(fontRenderer);
        float f2 = Rect.yCoordinateFor(n, 9, yAlignment);
        Objects.requireNonNull(fontRenderer);
        matrix3x2fStack.translation(f, f2 + 9.0f * 0.5f);
        if (scale < 1.0f) {
            graphics.pose().scale(scale, scale);
        }
        int n2 = (maxWidth - Math.min(maxWidth, textWidth)) / 2;
        Objects.requireNonNull(fontRenderer);
        graphics.drawString(fontRenderer, text, n2, -9 / 2, color, dropShadow);
        graphics.pose().popMatrix();
    }

    public static void wrapInMatrixEntry(PoseStack matrixStack, Runnable thenDo) {
        matrixStack.pushPose();
        thenDo.run();
        matrixStack.popPose();
    }
}

