/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.rendering;

import com.mojang.math.Transformation;
import gollorum.signpost.utils.math.Angle;
import java.util.Objects;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public final class RotatedModelState
implements ModelState {
    private final Angle angle;
    private final Matrix4f matrix;
    private Matrix4f _inverseMatrix = null;

    public RotatedModelState(Angle angle) {
        this.angle = angle;
        this.matrix = new Matrix4f().rotationY(angle.radians());
    }

    public Transformation transformation() {
        return new Transformation((Matrix4fc)this.matrix);
    }

    public Matrix4fc faceTransformation(Direction p_405422_) {
        return this.matrix;
    }

    public Matrix4fc inverseFaceTransformation(Direction p_405142_) {
        if (this._inverseMatrix == null) {
            this._inverseMatrix = new Matrix4f();
            this.matrix.invert(this._inverseMatrix);
        }
        return this._inverseMatrix;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RotatedModelState)) {
            return false;
        }
        RotatedModelState that = (RotatedModelState)obj;
        return Objects.equals(this.angle, that.angle);
    }

    public int hashCode() {
        return Objects.hash(this.angle);
    }

    public String toString() {
        return "RotatedModelState[angle=" + String.valueOf(this.angle) + "]";
    }
}

