/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.worldgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import gollorum.signpost.minecraft.config.IConfig;
import gollorum.signpost.minecraft.worldgen.JigsawDeserializers;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pools.LegacySinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElementType;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import org.jetbrains.annotations.NotNull;

public class SignpostJigsawPiece
extends LegacySinglePoolElement {
    private static Map<BlockPos, Integer> signpostCountForVillage;
    public static final MapCodec<SignpostJigsawPiece> codec;
    public final boolean isZombie;

    public static void reset() {
        signpostCountForVillage = new HashMap<BlockPos, Integer>();
    }

    private static RecordCodecBuilder<SignpostJigsawPiece, Boolean> isZombieCodec() {
        return Codec.BOOL.fieldOf("isZombie").forGetter(o -> o.isZombie);
    }

    public SignpostJigsawPiece(ResourceLocation location, Holder<StructureProcessorList> structureProcessorListSupplier, StructureTemplatePool.Projection placementBehaviour, Optional<LiquidSettings> liquidSettings, boolean isZombie) {
        this((Either<ResourceLocation, StructureTemplate>)Either.left((Object)location), structureProcessorListSupplier, placementBehaviour, liquidSettings, isZombie);
    }

    public SignpostJigsawPiece(Either<ResourceLocation, StructureTemplate> template, Holder<StructureProcessorList> structureProcessorListSupplier, StructureTemplatePool.Projection placementBehaviour, Optional<LiquidSettings> liquidSettings, boolean isZombie) {
        super(template, structureProcessorListSupplier, placementBehaviour, liquidSettings);
        this.isZombie = isZombie;
    }

    public boolean place(StructureTemplateManager templateManager, WorldGenLevel seedReader, StructureManager structureManager, ChunkGenerator chunkGenerator, BlockPos pieceLocation, BlockPos villageLocation, Rotation rotation, BoundingBox boundingBox, RandomSource random, LiquidSettings liquidSettings, boolean keepJigsaws) {
        StructurePlaceSettings placementSettings;
        if (!IConfig.IServer.getInstance().worldGen().isVillageGenerationEnabled()) {
            return false;
        }
        if (signpostCountForVillage.getOrDefault(villageLocation, 0) >= IConfig.IServer.getInstance().worldGen().maxSignpostsPerVillage()) {
            return false;
        }
        StructureTemplate template = (StructureTemplate)this.template.map(arg_0 -> ((StructureTemplateManager)templateManager).getOrCreate(arg_0), Function.identity());
        if (template.placeInWorld((ServerLevelAccessor)seedReader, pieceLocation, villageLocation, placementSettings = this.getSettings(rotation, boundingBox, liquidSettings, keepJigsaws), random, 18)) {
            signpostCountForVillage.put(villageLocation, signpostCountForVillage.getOrDefault(villageLocation, 0) + 1);
            return true;
        }
        return false;
    }

    @NotNull
    public StructurePoolElementType<?> getType() {
        return JigsawDeserializers.signpost;
    }

    @NotNull
    public String toString() {
        return "SingleSignpost[" + String.valueOf(this.template) + "]";
    }

    static {
        codec = RecordCodecBuilder.mapCodec(codecBuilder -> codecBuilder.group((App)SignpostJigsawPiece.templateCodec(), (App)SignpostJigsawPiece.processorsCodec(), (App)SignpostJigsawPiece.projectionCodec(), (App)SignpostJigsawPiece.overrideLiquidSettingsCodec(), SignpostJigsawPiece.isZombieCodec()).apply((Applicative)codecBuilder, SignpostJigsawPiece::new));
    }
}

