/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.mixin;

import gollorum.signpost.blockpartdata.types.PostBlockPart;
import gollorum.signpost.minecraft.block.tiles.PostTile;
import gollorum.signpost.networking.PacketHandler;
import gollorum.signpost.utils.IDelay;
import gollorum.signpost.utils.WorldLocation;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.ServerPlayerGameMode;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ServerPlayerGameMode.class})
public abstract class BlockPartBreakLogicInjector {
    @Accessor
    protected abstract ServerLevel getLevel();

    @Accessor
    protected abstract ServerPlayer getPlayer();

    @Inject(method={"destroyBlock"}, at={@At(value="HEAD")}, cancellable=true)
    private void onBeforeDestroyBlock(BlockPos pos, CallbackInfoReturnable<Boolean> cir) {
        ServerLevel level = this.getLevel();
        BlockEntity tile = level.getBlockEntity(pos);
        if (tile instanceof PostTile) {
            PostTile postTile = (PostTile)tile;
            Optional<PostTile.TraceResult> traceResult = postTile.trace((Entity)this.getPlayer());
            if (traceResult.isPresent() && !(traceResult.get().part.blockPart() instanceof PostBlockPart)) {
                IDelay.onServerForFrames(1, () -> {
                    PacketHandler.getInstance().sendToTracing(tile, () -> PostTile.UpdateAllPartsEvent.Packet.from(tile.getUpdateTag((HolderLookup.Provider)level.registryAccess()), WorldLocation.from(tile).get()));
                    postTile.removePart(((PostTile.TraceResult)traceResult.get()).id);
                    if (level instanceof ServerLevel && !this.getPlayer().isCreative()) {
                        for (ItemStack item : ((PostTile.TraceResult)traceResult.get()).part.blockPart().getDrops()) {
                            ItemEntity itementity = new ItemEntity((Level)level, (double)pos.getX() + (double)level.getRandom().nextFloat() * 0.5 + 0.25, (double)pos.getY() + (double)level.getRandom().nextFloat() * 0.5 + 0.25, (double)pos.getZ() + (double)level.getRandom().nextFloat() * 0.5 + 0.25, item);
                            itementity.setDefaultPickUpDelay();
                            level.addFreshEntity((Entity)itementity);
                        }
                    }
                });
                cir.setReturnValue((Object)false);
            } else {
                postTile.onDestroy();
            }
        }
    }
}

