/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.networking;

import gollorum.signpost.Signpost;
import gollorum.signpost.SignpostForge;
import gollorum.signpost.compat.Compat;
import gollorum.signpost.networking.PacketHandler;
import gollorum.signpost.utils.Tuple;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.Channel;
import net.minecraftforge.network.ChannelBuilder;
import net.minecraftforge.network.NetworkProtocol;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.SimpleChannel;
import net.minecraftforge.network.simple.SimpleFlow;

public class ForgePacketHandler
extends PacketHandler {
    private static final int PROTOCOL_VERSION = 0;
    private static SimpleChannel channel;

    public static void initialize() {
        channel = ChannelBuilder.named((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"signpost", (String)"main")).acceptedVersions(Channel.VersionTest.exact((int)0)).simpleChannel();
        instance = new ForgePacketHandler();
        instance.init();
        instance.register(new SignpostForge.JoinServerEvent(), ResourceLocation.fromNamespaceAndPath((String)"signpost", (String)"join_server"));
        for (Map.Entry<ResourceLocation, PacketHandler.Event<?>> entry : Compat.getEvents().entrySet()) {
            instance.register(entry.getValue(), entry.getKey());
        }
        SimpleFlow flow = (SimpleFlow)channel.protocol(NetworkProtocol.PLAY).bidirectional();
        for (Tuple<PacketHandler.Event<?>, ResourceLocation> entry : ForgePacketHandler.instance.events) {
            ((ForgePacketHandler)instance).register(entry._1(), (SimpleFlow<RegistryFriendlyByteBuf, Object>)flow);
        }
        channel.build();
    }

    private <T> void register(PacketHandler.Event<T> event, SimpleFlow<RegistryFriendlyByteBuf, Object> flow) {
        this.register(event.getMessageClass(), event.codec(), event::handle, flow);
    }

    private <T> void register(Class<T> messageClass, StreamCodec<RegistryFriendlyByteBuf, T> codec, BiConsumer<T, PacketHandler.Context> handle, SimpleFlow<RegistryFriendlyByteBuf, Object> flow) {
        flow.add(messageClass, codec, ForgePacketHandler.handle(handle));
    }

    private static <T> BiConsumer<T, CustomPayloadEvent.Context> handle(BiConsumer<T, PacketHandler.Context> handle) {
        return (message, context) -> {
            context.enqueueWork(() -> {
                if (context.getConnection().getReceiving() == PacketFlow.CLIENTBOUND) {
                    handle.accept(message, new PacketHandler.Context.Client());
                } else {
                    handle.accept(message, new PacketHandler.Context.Server(context.getSender()));
                }
            });
            context.setPacketHandled(true);
        };
    }

    @Override
    public <T> void sendToServer(T message) {
        channel.send(message, PacketDistributor.SERVER.noArg());
    }

    @Override
    public <T> void sendToPlayer(ServerPlayer target, T message) {
        channel.send(message, PacketDistributor.PLAYER.with((Object)target));
    }

    @Override
    public <T> void sendToTracing(ServerLevel world, BlockPos pos, Supplier<T> t) {
        if (world == null) {
            Signpost.LOGGER.warn("No world to notify mutation");
        } else if (pos == null) {
            Signpost.LOGGER.warn("No position to notify mutation");
        } else {
            channel.send(t.get(), PacketDistributor.TRACKING_CHUNK.with((Object)world.getChunkAt(pos)));
        }
    }

    @Override
    public <T> void sendToTracing(BlockEntity tile, Supplier<T> t) {
        this.sendToTracing((ServerLevel)tile.getLevel(), tile.getBlockPos(), t);
    }

    @Override
    public <T> void sendToAll(T message) {
        channel.send(message, PacketDistributor.ALL.noArg());
    }
}

