/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.registry;

import gollorum.signpost.minecraft.block.ModelWaystone;
import gollorum.signpost.minecraft.block.PostBlock;
import gollorum.signpost.minecraft.block.WaystoneBlock;
import gollorum.signpost.minecraft.items.Brush;
import gollorum.signpost.minecraft.items.GenerationWand;
import gollorum.signpost.minecraft.items.PostItem;
import gollorum.signpost.minecraft.items.WaystoneItem;
import gollorum.signpost.minecraft.items.Wrench;
import gollorum.signpost.registry.BlockRegistry;
import gollorum.signpost.utils.Tuple;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.eventbus.api.bus.BusGroup;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ItemRegistry {
    private static final DeferredRegister<Item> REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"signpost");
    public static final RegistryObject<Item> WAYSTONE_ITEM = REGISTER.register("waystone", () -> new WaystoneItem(WaystoneBlock.getInstance(), new Item.Properties()));
    public static final List<Tuple<ModelWaystone.Variant, RegistryObject<Item>>> ModelWaystoneItems = ModelWaystone.variants.stream().map(ItemRegistry::registerModelWaystoneItem).toList();
    public static final List<RegistryObject<Item>> POSTS_ITEMS = PostBlock.AllVariants.stream().map(ItemRegistry::registerPostItem).toList();
    public static final RegistryObject<Item> WaystoneGeneratorItem = REGISTER.register("waystone_generator", () -> new BlockItem((Block)BlockRegistry.WaystoneGenerator.get(), new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"signpost", (String)"waystone_generator")))));
    public static final RegistryObject<Item> WRENCH = REGISTER.register("tool", Wrench::new);
    public static final RegistryObject<Item> BRUSH = REGISTER.register("brush", Brush::new);
    public static final RegistryObject<Item> GENERATION_WAND = REGISTER.register("generation_wand", GenerationWand::new);

    private static RegistryObject<Item> registerPostItem(PostBlock.Variant postVariant) {
        return REGISTER.register(postVariant.registryName, () -> new PostItem(postVariant.getBlock(), new Item.Properties()));
    }

    private static Tuple<ModelWaystone.Variant, RegistryObject<Item>> registerModelWaystoneItem(ModelWaystone.Variant variant) {
        return new Tuple<ModelWaystone.Variant, RegistryObject<Item>>(variant, REGISTER.register(variant.registryName, () -> new WaystoneItem(variant.getBlock(), new Item.Properties())));
    }

    public static void register(BusGroup bus) {
        REGISTER.register(bus);
    }
}

