/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.registry;

import gollorum.signpost.PlayerHandle;
import gollorum.signpost.Signpost;
import gollorum.signpost.WaystoneHandle;
import gollorum.signpost.WaystoneLibrary;
import gollorum.signpost.minecraft.utils.TextComponents;
import gollorum.signpost.minecraft.worldgen.IWaystoneDiscoveryEventListener;
import gollorum.signpost.minecraft.worldgen.VillageWaystone;
import gollorum.signpost.utils.WaystoneData;
import io.netty.util.internal.PlatformDependent;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.level.ChunkWatchEvent;
import net.minecraftforge.eventbus.api.bus.BusGroup;
import net.minecraftforge.eventbus.api.listener.SubscribeEvent;

public class WaystoneDiscoveryEventListener
implements IWaystoneDiscoveryEventListener {
    private static final int discoveryDistance = 8;
    private static ConcurrentMap<ServerPlayer, ConcurrentMap<WaystoneHandle.Vanilla, BlockPos>> trackedPlayers;

    public static void register(BusGroup bus) {
        bus.register(MethodHandles.lookup(), WaystoneDiscoveryEventListener.class);
    }

    @Override
    public void initialize() {
        trackedPlayers = PlatformDependent.newConcurrentHashMap();
    }

    @SubscribeEvent
    public static void onWatchChunk(ChunkWatchEvent.Watch event) {
        if (!WaystoneLibrary.hasInstance()) {
            return;
        }
        VillageWaystone.ChunkEntryKey key = new VillageWaystone.ChunkEntryKey(event.getPos(), event.getPlayer().level().dimension().location());
        WaystoneLibrary lib = WaystoneLibrary.getInstance();
        Map<VillageWaystone.ChunkEntryKey, WaystoneHandle.Vanilla> allEntries = lib.getVillageWaystones().getAllEntriesByChunk(lib, true);
        WaystoneHandle.Vanilla handle = allEntries.get(key);
        if (handle != null && !lib.isDiscovered(PlayerHandle.from((Entity)event.getPlayer()), handle)) {
            Optional<WaystoneData> dataOption = lib.getData(handle);
            dataOption.ifPresentOrElse(data -> trackedPlayers.computeIfAbsent(event.getPlayer(), p -> PlatformDependent.newConcurrentHashMap()).putIfAbsent(handle, data.location().block().blockPos()), () -> allEntries.remove(key));
        }
    }

    @SubscribeEvent
    public static void onUnWatchChunk(ChunkWatchEvent.UnWatch event) {
        ConcurrentMap set = (ConcurrentMap)trackedPlayers.get(event.getPlayer());
        if (set == null) {
            return;
        }
        WaystoneLibrary lib = WaystoneLibrary.getInstance();
        WaystoneHandle.Vanilla handle = lib.getVillageWaystones().getAllEntriesByChunk(lib, false).get(new VillageWaystone.ChunkEntryKey(event.getPos(), event.getPlayer().level().dimension().location()));
        if (handle == null) {
            return;
        }
        set.remove(handle);
    }

    @SubscribeEvent
    public static void onTick(TickEvent.ServerTickEvent.Post event) {
        if (!WaystoneLibrary.hasInstance()) {
            return;
        }
        for (Map.Entry map : trackedPlayers.entrySet()) {
            for (Map.Entry inner : ((ConcurrentMap)map.getValue()).entrySet()) {
                if (!((BlockPos)inner.getValue()).closerThan((Vec3i)((ServerPlayer)map.getKey()).blockPosition(), 8.0)) continue;
                WaystoneLibrary.getInstance().getData((WaystoneHandle.Vanilla)inner.getKey()).ifPresent(data -> {
                    if (WaystoneLibrary.getInstance().addDiscovered(new PlayerHandle((Entity)map.getKey()), (WaystoneHandle.Vanilla)inner.getKey())) {
                        ((ServerPlayer)map.getKey()).sendSystemMessage((Component)Component.translatable((String)"signpost.discovered", (Object[])new Object[]{TextComponents.waystone((ServerPlayer)map.getKey(), data.name())}));
                    }
                });
                ((ConcurrentMap)map.getValue()).remove(inner.getKey());
            }
            if (!((ConcurrentMap)map.getValue()).isEmpty()) continue;
            trackedPlayers.remove(map.getKey());
        }
    }

    @Override
    public void registerNew(WaystoneHandle.Vanilla handle, ServerLevel world, BlockPos pos) {
        Signpost.getServerInstance().getPlayerList().getPlayers().forEach(player -> {
            if (player.level().equals(world) && player.blockPosition().closerThan((Vec3i)pos, 100.0)) {
                trackedPlayers.computeIfAbsent((ServerPlayer)player, p -> PlatformDependent.newConcurrentHashMap()).putIfAbsent(handle, pos);
            }
        });
    }
}

