/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.utils;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public interface NameProvider {
    public static final Codec<NameProvider> CODEC = Codec.STRING.dispatch("type", nameProvider -> {
        if (nameProvider instanceof Literal) {
            return "literal";
        }
        if (nameProvider instanceof WaystoneTarget) {
            return "waystone";
        }
        throw new RuntimeException("Unknown NameProvider type: " + String.valueOf(nameProvider.getClass()));
    }, type -> switch (type) {
        case "literal" -> Codec.STRING.fieldOf("name").xmap(Literal::new, Literal::get);
        case "waystone" -> Codec.STRING.fieldOf("name").xmap(WaystoneTarget::new, WaystoneTarget::get);
        default -> throw new RuntimeException("Unknown NameProvider type: " + type);
    });
    public static final StreamCodec<ByteBuf, NameProvider> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, t -> {
        if (t instanceof Literal) {
            return "literal";
        }
        if (t instanceof WaystoneTarget) {
            return "waystone";
        }
        throw new RuntimeException("Unknown NameProvider type: " + String.valueOf(t.getClass()));
    }, (StreamCodec)ByteBufCodecs.STRING_UTF8, NameProvider::get, NameProvider::from);

    public String get();

    private static NameProvider from(String type, String name) {
        return switch (type) {
            case "literal" -> new Literal(name);
            case "waystone" -> new WaystoneTarget(name);
            default -> throw new RuntimeException("Invalid name provider type " + type);
        };
    }

    public record Literal(String name) implements NameProvider
    {
        @Override
        public String get() {
            return this.name;
        }
    }

    public static final class WaystoneTarget
    implements NameProvider {
        private String cachedName;

        public void setCachedName(String name) {
            this.cachedName = name;
        }

        @Override
        public String get() {
            return this.cachedName;
        }

        public WaystoneTarget(String cachedName) {
            this.cachedName = cachedName;
        }
    }
}

