/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.worldgen;

import gollorum.signpost.minecraft.config.IConfig;
import gollorum.signpost.minecraft.config.IWorldGenConfig;
import gollorum.signpost.worldgen.VillageNamesProvider;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import org.apache.commons.lang3.text.WordUtils;

public class DefaultVillageNamesProvider
implements VillageNamesProvider {
    @Override
    public Optional<String> getFor(BlockPos blockPos, BlockPos villagePos, ServerLevel world, Predicate<String> validator, Random random) {
        IWorldGenConfig.INaming namingConfig = IConfig.IServer.getInstance().worldGen().naming();
        List<? extends String> prefixes = namingConfig.villageNamePrefixes();
        List<? extends String> infixes = namingConfig.villageNameInfixes();
        List<? extends String> postfixes = namingConfig.villageNamePostfixes();
        List prefixIndices = IntStream.range(0, prefixes.size()).boxed().collect(Collectors.toList());
        List infixIndices = IntStream.range(0, infixes.size()).boxed().collect(Collectors.toList());
        List postfixIndices = IntStream.range(0, postfixes.size()).boxed().collect(Collectors.toList());
        Collections.shuffle(prefixIndices, random);
        Collections.shuffle(infixIndices, random);
        Collections.shuffle(postfixIndices, random);
        Iterator iterator = prefixIndices.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            Iterator iterator2 = infixIndices.iterator();
            while (iterator2.hasNext()) {
                int j = (Integer)iterator2.next();
                Iterator iterator3 = postfixIndices.iterator();
                while (iterator3.hasNext()) {
                    int k = (Integer)iterator3.next();
                    String name = WordUtils.capitalize((String)(prefixes.get(i) + infixes.get(j) + postfixes.get(k))).trim();
                    if (!validator.test(name)) continue;
                    return Optional.of(name);
                }
            }
        }
        return Optional.empty();
    }
}

