/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.worldgen;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import gollorum.signpost.Signpost;
import gollorum.signpost.minecraft.worldgen.SignpostJigsawPiece;
import gollorum.signpost.minecraft.worldgen.VillageSignpost;
import gollorum.signpost.minecraft.worldgen.VillageWaystone;
import gollorum.signpost.minecraft.worldgen.WaystoneJigsawPiece;
import gollorum.signpost.mixin.ProcessorListsAccessor;
import gollorum.signpost.mixin.StructureTemplatePoolAccessor;
import gollorum.signpost.utils.Tuple;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.ProcessorLists;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;

public class Villages {
    public static final Villages instance = new Villages();
    private Holder<StructureProcessorList> waystoneProcessorListDesert;
    private Holder<StructureProcessorList> waystoneProcessorListPlains;
    private Holder<StructureProcessorList> waystoneProcessorListSavanna;
    private Holder<StructureProcessorList> waystoneProcessorListSnowyOrTaiga;

    private Villages() {
    }

    private void registerProcessorLists(RegistryAccess registryAccess) {
        Optional optionalReg = registryAccess.lookup(Registries.PROCESSOR_LIST);
        if (optionalReg.isEmpty()) {
            Signpost.LOGGER.error("Failed to initialize village generation: ProcessorList registry not found");
            return;
        }
        Registry reg = (Registry)optionalReg.get();
        this.waystoneProcessorListDesert = reg.getOrThrow(ProcessorListsAccessor.getEmpty());
        this.waystoneProcessorListPlains = reg.getOrThrow(ProcessorLists.STREET_PLAINS);
        this.waystoneProcessorListSavanna = reg.getOrThrow(ProcessorLists.STREET_SAVANNA);
        this.waystoneProcessorListSnowyOrTaiga = reg.getOrThrow(ProcessorLists.STREET_SNOWY_OR_TAIGA);
    }

    public static void reset() {
        VillageSignpost.reset();
        VillageWaystone.reset();
        SignpostJigsawPiece.reset();
        WaystoneJigsawPiece.reset();
    }

    public void initialize(RegistryAccess registryAccess) {
        this.registerProcessorLists(registryAccess);
        Optional optionalReg = registryAccess.lookup(Registries.TEMPLATE_POOL);
        if (optionalReg.isEmpty()) {
            Signpost.LOGGER.error("Failed to initialize village generation: TemplatePool registry not found");
            return;
        }
        Registry reg = (Registry)optionalReg.get();
        for (VillageType villageType : VillageType.values()) {
            this.registerFor(villageType, true, (Registry<StructureTemplatePool>)reg);
            this.registerFor(villageType, false, (Registry<StructureTemplatePool>)reg);
        }
        Villages.reset();
    }

    private void registerFor(VillageType villageType, boolean isZombie, Registry<StructureTemplatePool> registry) {
        this.addToPool((Collection<Tuple<SinglePoolElement, Integer>>)ImmutableList.of(Tuple.of(new WaystoneJigsawPiece(villageType.getWaystoneStructureResourceLocation("waystone"), villageType.processorList, StructureTemplatePool.Projection.RIGID, Optional.empty()), 1), Tuple.of(new SignpostJigsawPiece(villageType.getSignpostStructureResourceLocation("signpost"), villageType.processorList, StructureTemplatePool.Projection.TERRAIN_MATCHING, Optional.of(LiquidSettings.APPLY_WATERLOGGING), isZombie), 3)), isZombie ? Villages.getZombieVillagePool(villageType) : Villages.getVillagePool(villageType), registry);
    }

    private static ResourceLocation getVillagePool(VillageType villageType) {
        return ResourceLocation.parse((String)("village/" + villageType.name + "/houses"));
    }

    private static ResourceLocation getZombieVillagePool(VillageType villageType) {
        return ResourceLocation.parse((String)("village/" + villageType.name + "/zombie/houses"));
    }

    private void addToPool(Collection<Tuple<SinglePoolElement, Integer>> houses, ResourceLocation poolKey, Registry<StructureTemplatePool> registry) {
        ResourceKey key = ResourceKey.create((ResourceKey)Registries.TEMPLATE_POOL, (ResourceLocation)poolKey);
        StructureTemplatePool pool = (StructureTemplatePool)registry.getValue(key);
        if (pool == null) {
            Signpost.LOGGER.error("Tried to add elements to village pool " + String.valueOf(poolKey) + ", but it was not found in the registry.");
            return;
        }
        StructureTemplatePoolAccessor templatePool = (StructureTemplatePoolAccessor)pool;
        ArrayList<Pair<StructurePoolElement, Integer>> templates = new ArrayList<Pair<StructurePoolElement, Integer>>(templatePool.getRawTemplates());
        for (Tuple<SinglePoolElement, Integer> tuple : houses) {
            templates.add((Pair<StructurePoolElement, Integer>)new Pair((Object)((StructurePoolElement)tuple._1()), (Object)tuple._2()));
            for (int i = 0; i < tuple._2(); ++i) {
                templatePool.getTemplates().add((Object)((StructurePoolElement)tuple._1()));
            }
        }
        templatePool.setRawTemplates(templates);
    }

    private static enum VillageType {
        Desert("desert", Villages.instance.waystoneProcessorListDesert, false),
        Plains("plains", Villages.instance.waystoneProcessorListPlains, true),
        Savanna("savanna", Villages.instance.waystoneProcessorListSavanna, true),
        Snowy("snowy", Villages.instance.waystoneProcessorListSnowyOrTaiga, true),
        Taiga("taiga", Villages.instance.waystoneProcessorListSnowyOrTaiga, true);

        public final String name;
        public final Holder<StructureProcessorList> processorList;
        public final boolean isCommonGround;

        private VillageType(String name, Holder<StructureProcessorList> processorList, boolean isCommonGround) {
            this.name = name;
            this.processorList = processorList;
            this.isCommonGround = isCommonGround;
        }

        public ResourceLocation getSignpostStructureResourceLocation(String structureName) {
            return ResourceLocation.fromNamespaceAndPath((String)"signpost", (String)("village/" + this.name + "/" + structureName));
        }

        public ResourceLocation getWaystoneStructureResourceLocation(String structureName) {
            return ResourceLocation.fromNamespaceAndPath((String)"signpost", (String)("village/" + (this.isCommonGround ? "common" : this.name) + "/" + structureName));
        }
    }
}

