/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost;

import gollorum.signpost.Signpost;
import gollorum.signpost.WaystoneLibrary;
import gollorum.signpost.compat.Compat;
import gollorum.signpost.compat.ExternalWaystoneLibrary;
import gollorum.signpost.config.Config;
import gollorum.signpost.minecraft.block.tiles.PostTile;
import gollorum.signpost.minecraft.loot.LootEntries;
import gollorum.signpost.minecraft.rendering.PostRenderer;
import gollorum.signpost.minecraft.worldgen.JigsawDeserializers;
import gollorum.signpost.networking.NeoForgePacketHandler;
import gollorum.signpost.networking.PacketHandler;
import gollorum.signpost.registry.BlockRegistry;
import gollorum.signpost.registry.CreativeModeTabRegistry;
import gollorum.signpost.registry.DataComponentsRegistry;
import gollorum.signpost.registry.ItemRegistry;
import gollorum.signpost.registry.LootItemConditionRegistry;
import gollorum.signpost.registry.MiscRegistry;
import gollorum.signpost.registry.RecipeRegistry;
import gollorum.signpost.registry.TileEntityRegistry;
import gollorum.signpost.registry.WaystoneDiscoveryEventListener;
import gollorum.signpost.utils.Delay;
import gollorum.signpost.utils.IDelay;
import gollorum.signpost.worldgen.Villages;
import java.util.function.Consumer;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.server.ServerAboutToStartEvent;
import net.neoforged.neoforge.event.server.ServerStoppedEvent;
import net.neoforged.neoforge.registries.RegisterEvent;

@Mod(value="signpost")
public class SignpostNeoforge {
    private final Consumer<MinecraftServer> serverSetter = Signpost.init(Config.INSTANCE, (IDelay)Delay.INSTANCE);

    public SignpostNeoforge(IEventBus modBus) {
        IEventBus forgeBus = NeoForge.EVENT_BUS;
        forgeBus.register((Object)new ForgeEvents());
        modBus.register((Object)new ModBusEvents());
        BlockRegistry.register(modBus);
        ItemRegistry.register(modBus);
        DataComponentsRegistry.register(modBus);
        RecipeRegistry.register(modBus);
        TileEntityRegistry.register(modBus);
        CreativeModeTabRegistry.register(modBus);
        WaystoneDiscoveryEventListener.register(forgeBus);
        NeoForgePacketHandler.initialize(modBus);
        forgeBus.register((Object)Delay.INSTANCE);
        Config.INSTANCE.register();
        LootItemConditionRegistry.register(modBus);
        MiscRegistry.register(modBus);
        Compat.register();
    }

    private class ForgeEvents {
        private ForgeEvents() {
        }

        @SubscribeEvent
        public void serverAboutToStart(ServerAboutToStartEvent e) {
            SignpostNeoforge.this.serverSetter.accept(e.getServer());
            Villages.instance.initialize((RegistryAccess)e.getServer().registryAccess());
            new WaystoneDiscoveryEventListener().initialize();
        }

        @SubscribeEvent
        public void joinServer(PlayerEvent.PlayerLoggedInEvent e) {
            if (!e.getEntity().level().isClientSide() && Signpost.getServerInstance().isDedicatedServer()) {
                PacketHandler.getInstance().sendToPlayer((ServerPlayer)e.getEntity(), JoinServerEvent.Package.INSTANCE);
            }
        }

        @SubscribeEvent
        public void onWorldLoad(LevelEvent.Load event) {
            LevelAccessor levelAccessor = event.getLevel();
            if (levelAccessor instanceof ServerLevel) {
                ServerLevel world = (ServerLevel)levelAccessor;
                if (((ServerLevel)event.getLevel()).dimension().equals(Level.OVERWORLD)) {
                    WaystoneLibrary.initializeServer(world);
                }
            }
        }

        @SubscribeEvent
        public void onServerStopped(ServerStoppedEvent event) {
            SignpostNeoforge.this.serverSetter.accept(null);
        }
    }

    private static class ModBusEvents {
        private ModBusEvents() {
        }

        @SubscribeEvent
        public void setup(FMLCommonSetupEvent event) {
            ExternalWaystoneLibrary.initialize();
        }

        @SubscribeEvent
        public void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
            event.registerBlockEntityRenderer(PostTile.getBlockEntityType(), PostRenderer::new);
        }

        @SubscribeEvent
        public void registerStuff(RegisterEvent event) {
            JigsawDeserializers.register((loc, elem) -> event.register(Registries.STRUCTURE_POOL_ELEMENT, loc, () -> elem));
            LootEntries.register((loc, elem) -> event.register(Registries.LOOT_POOL_ENTRY_TYPE, loc, () -> elem));
        }
    }

    public static final class JoinServerEvent
    implements PacketHandler.Event<Package> {
        @Override
        public StreamCodec<RegistryFriendlyByteBuf, Package> codec() {
            return Package.CODEC;
        }

        @Override
        public Class<Package> getMessageClass() {
            return Package.class;
        }

        @Override
        public void handle(Package message, PacketHandler.Context context) {
            WaystoneLibrary.initializeClient();
        }

        public static final class Package {
            public static final Package INSTANCE = new Package();
            public static final StreamCodec<RegistryFriendlyByteBuf, Package> CODEC = StreamCodec.unit((Object)INSTANCE);
        }
    }
}

